/*
 * Decompiled with CFR 0.152.
 */
package com.yonghui.zxing.camera.open;

import android.hardware.Camera;
import com.yonghui.zxing.camera.open.CameraFacing;
import com.yonghui.zxing.camera.open.OpenCamera;
import com.yonghui.zxing.util.LogUtils;

public final class OpenCameraInterface {
    public static final int NO_REQUESTED_CAMERA = -1;

    private OpenCameraInterface() {
    }

    public static OpenCamera open(int cameraId) {
        Camera.CameraInfo cameraInfo;
        int numCameras = Camera.getNumberOfCameras();
        if (numCameras == 0) {
            LogUtils.w("No cameras!");
            return null;
        }
        if (cameraId >= numCameras) {
            LogUtils.w("Requested camera does not exist: " + cameraId);
            return null;
        }
        if (cameraId <= -1) {
            for (cameraId = 0; cameraId < numCameras; ++cameraId) {
                cameraInfo = new Camera.CameraInfo();
                Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)cameraInfo);
                if (CameraFacing.values()[cameraInfo.facing] == CameraFacing.BACK) break;
            }
            if (cameraId == numCameras) {
                LogUtils.i("No camera facing " + (Object)((Object)CameraFacing.BACK) + "; returning camera #0");
                cameraId = 0;
            }
        }
        LogUtils.i("Opening camera #" + cameraId);
        cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)cameraInfo);
        Camera camera = Camera.open((int)cameraId);
        if (camera == null) {
            return null;
        }
        return new OpenCamera(cameraId, camera, CameraFacing.values()[cameraInfo.facing], cameraInfo.orientation);
    }
}

