/*
 * Decompiled with CFR 0.152.
 */
package com.yonghui.zxing.camera;

import android.graphics.Point;
import android.graphics.Rect;
import android.hardware.Camera;
import android.os.Build;
import com.yonghui.zxing.util.LogUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public final class CameraConfigurationUtils {
    private static final Pattern SEMICOLON = Pattern.compile(";");
    private static final int MIN_PREVIEW_PIXELS = 153600;
    private static final float MAX_EXPOSURE_COMPENSATION = 1.5f;
    private static final float MIN_EXPOSURE_COMPENSATION = 0.0f;
    private static final double MAX_ASPECT_DISTORTION = 0.05;
    private static final int MIN_FPS = 10;
    private static final int MAX_FPS = 20;
    private static final int AREA_PER_1000 = 400;

    private CameraConfigurationUtils() {
    }

    public static void setFocus(Camera.Parameters parameters, boolean autoFocus, boolean disableContinuous, boolean safeMode) {
        List supportedFocusModes = parameters.getSupportedFocusModes();
        String focusMode = null;
        if (autoFocus) {
            focusMode = safeMode || disableContinuous ? CameraConfigurationUtils.findSettableValue("focus mode", supportedFocusModes, "auto") : CameraConfigurationUtils.findSettableValue("focus mode", supportedFocusModes, "continuous-picture", "continuous-video", "auto");
        }
        if (!safeMode && focusMode == null) {
            focusMode = CameraConfigurationUtils.findSettableValue("focus mode", supportedFocusModes, "macro", "edof");
        }
        if (focusMode != null) {
            if (focusMode.equals(parameters.getFocusMode())) {
                LogUtils.d("Focus mode already set to " + focusMode);
            } else {
                parameters.setFocusMode(focusMode);
            }
        }
    }

    public static void setTorch(Camera.Parameters parameters, boolean on) {
        List supportedFlashModes = parameters.getSupportedFlashModes();
        String flashMode = on ? CameraConfigurationUtils.findSettableValue("flash mode", supportedFlashModes, "torch", "on") : CameraConfigurationUtils.findSettableValue("flash mode", supportedFlashModes, "off");
        if (flashMode != null) {
            if (flashMode.equals(parameters.getFlashMode())) {
                LogUtils.d("Flash mode already set to " + flashMode);
            } else {
                LogUtils.d("Setting flash mode to " + flashMode);
                parameters.setFlashMode(flashMode);
            }
        }
    }

    public static void setBestExposure(Camera.Parameters parameters, boolean lightOn) {
        int minExposure = parameters.getMinExposureCompensation();
        int maxExposure = parameters.getMaxExposureCompensation();
        float step = parameters.getExposureCompensationStep();
        if ((minExposure != 0 || maxExposure != 0) && step > 0.0f) {
            float targetCompensation = lightOn ? 0.0f : 1.5f;
            int compensationSteps = Math.round(targetCompensation / step);
            float actualCompensation = step * (float)compensationSteps;
            compensationSteps = Math.max(Math.min(compensationSteps, maxExposure), minExposure);
            if (parameters.getExposureCompensation() == compensationSteps) {
                LogUtils.d("Exposure compensation already set to " + compensationSteps + " / " + actualCompensation);
            } else {
                LogUtils.d("Setting exposure compensation to " + compensationSteps + " / " + actualCompensation);
                parameters.setExposureCompensation(compensationSteps);
            }
        } else {
            LogUtils.d("Camera does not support exposure compensation");
        }
    }

    public static void setBestPreviewFPS(Camera.Parameters parameters) {
        CameraConfigurationUtils.setBestPreviewFPS(parameters, 10, 20);
    }

    public static void setBestPreviewFPS(Camera.Parameters parameters, int minFPS, int maxFPS) {
        List supportedPreviewFpsRanges = parameters.getSupportedPreviewFpsRange();
        LogUtils.d("Supported FPS ranges: " + CameraConfigurationUtils.toString(supportedPreviewFpsRanges));
        if (supportedPreviewFpsRanges != null && !supportedPreviewFpsRanges.isEmpty()) {
            int[] suitableFPSRange = null;
            for (int[] fpsRange : supportedPreviewFpsRanges) {
                int thisMin = fpsRange[0];
                int thisMax = fpsRange[1];
                if (thisMin < minFPS * 1000 || thisMax > maxFPS * 1000) continue;
                suitableFPSRange = fpsRange;
                break;
            }
            if (suitableFPSRange == null) {
                LogUtils.d("No suitable FPS range?");
            } else {
                int[] currentFpsRange = new int[2];
                parameters.getPreviewFpsRange(currentFpsRange);
                if (Arrays.equals(currentFpsRange, suitableFPSRange)) {
                    LogUtils.d("FPS range already set to " + Arrays.toString(suitableFPSRange));
                } else {
                    LogUtils.d("Setting FPS range to " + Arrays.toString(suitableFPSRange));
                    parameters.setPreviewFpsRange(suitableFPSRange[0], suitableFPSRange[1]);
                }
            }
        }
    }

    public static void setFocusArea(Camera.Parameters parameters) {
        if (parameters.getMaxNumFocusAreas() > 0) {
            LogUtils.d("Old focus areas: " + CameraConfigurationUtils.toString(parameters.getFocusAreas()));
            List<Camera.Area> middleArea = CameraConfigurationUtils.buildMiddleArea(400);
            LogUtils.d("Setting focus area to : " + CameraConfigurationUtils.toString(middleArea));
            parameters.setFocusAreas(middleArea);
        } else {
            LogUtils.d("Device does not support focus areas");
        }
    }

    public static void setMetering(Camera.Parameters parameters) {
        if (parameters.getMaxNumMeteringAreas() > 0) {
            LogUtils.d("Old metering areas: " + parameters.getMeteringAreas());
            List<Camera.Area> middleArea = CameraConfigurationUtils.buildMiddleArea(400);
            LogUtils.d("Setting metering area to : " + CameraConfigurationUtils.toString(middleArea));
            parameters.setMeteringAreas(middleArea);
        } else {
            LogUtils.d("Device does not support metering areas");
        }
    }

    private static List<Camera.Area> buildMiddleArea(int areaPer1000) {
        return Collections.singletonList(new Camera.Area(new Rect(-areaPer1000, -areaPer1000, areaPer1000, areaPer1000), 1));
    }

    public static void setVideoStabilization(Camera.Parameters parameters) {
        if (parameters.isVideoStabilizationSupported()) {
            if (parameters.getVideoStabilization()) {
                LogUtils.d("Video stabilization already enabled");
            } else {
                LogUtils.d("Enabling video stabilization...");
                parameters.setVideoStabilization(true);
            }
        } else {
            LogUtils.d("This device does not support video stabilization");
        }
    }

    public static void setBarcodeSceneMode(Camera.Parameters parameters) {
        if ("barcode".equals(parameters.getSceneMode())) {
            LogUtils.d("Barcode scene mode already set");
            return;
        }
        String sceneMode = CameraConfigurationUtils.findSettableValue("scene mode", parameters.getSupportedSceneModes(), "barcode");
        if (sceneMode != null) {
            parameters.setSceneMode(sceneMode);
        }
    }

    public static void setZoom(Camera.Parameters parameters, double targetZoomRatio) {
        if (parameters.isZoomSupported()) {
            Integer zoom = CameraConfigurationUtils.indexOfClosestZoom(parameters, targetZoomRatio);
            if (zoom == null) {
                return;
            }
            if (parameters.getZoom() == zoom.intValue()) {
                LogUtils.d("Zoom is already set to " + zoom);
            } else {
                LogUtils.d("Setting zoom to " + zoom);
                parameters.setZoom(zoom.intValue());
            }
        } else {
            LogUtils.d("Zoom is not supported");
        }
    }

    private static Integer indexOfClosestZoom(Camera.Parameters parameters, double targetZoomRatio) {
        List ratios = parameters.getZoomRatios();
        LogUtils.d("Zoom ratios: " + ratios);
        int maxZoom = parameters.getMaxZoom();
        if (ratios == null || ratios.isEmpty() || ratios.size() != maxZoom + 1) {
            LogUtils.w("Invalid zoom ratios!");
            return null;
        }
        double target100 = 100.0 * targetZoomRatio;
        double smallestDiff = Double.POSITIVE_INFINITY;
        int closestIndex = 0;
        for (int i = 0; i < ratios.size(); ++i) {
            double diff = Math.abs((double)((Integer)ratios.get(i)).intValue() - target100);
            if (!(diff < smallestDiff)) continue;
            smallestDiff = diff;
            closestIndex = i;
        }
        LogUtils.d("Chose zoom ratio of " + (double)((Integer)ratios.get(closestIndex)).intValue() / 100.0);
        return closestIndex;
    }

    public static void setInvertColor(Camera.Parameters parameters) {
        if ("negative".equals(parameters.getColorEffect())) {
            LogUtils.d("Negative effect already set");
            return;
        }
        String colorMode = CameraConfigurationUtils.findSettableValue("color effect", parameters.getSupportedColorEffects(), "negative");
        if (colorMode != null) {
            parameters.setColorEffect(colorMode);
        }
    }

    public static Point findBestPreviewSizeValue(Camera.Parameters parameters, Point screenResolution) {
        List rawSupportedSizes = parameters.getSupportedPreviewSizes();
        if (rawSupportedSizes == null) {
            LogUtils.w("Device returned no supported preview sizes; using default");
            Camera.Size defaultSize = parameters.getPreviewSize();
            if (defaultSize == null) {
                throw new IllegalStateException("Parameters contained no preview size!");
            }
            return new Point(defaultSize.width, defaultSize.height);
        }
        if (LogUtils.isShowLog()) {
            StringBuilder previewSizesString = new StringBuilder();
            for (Camera.Size size : rawSupportedSizes) {
                previewSizesString.append(size.width).append('x').append(size.height).append(' ');
            }
            LogUtils.d("Supported preview sizes: " + previewSizesString);
        }
        double screenAspectRatio = screenResolution.x < screenResolution.y ? (double)screenResolution.x / (double)screenResolution.y : (double)screenResolution.y / (double)screenResolution.x;
        LogUtils.d("screenAspectRatio: " + screenAspectRatio);
        int maxResolution = 0;
        Camera.Size maxResPreviewSize = null;
        for (Camera.Size size : rawSupportedSizes) {
            int realWidth = size.width;
            int realHeight = size.height;
            int resolution = realWidth * realHeight;
            if (resolution < 153600) continue;
            boolean isCandidatePortrait = realWidth < realHeight;
            int maybeFlippedWidth = isCandidatePortrait ? realWidth : realHeight;
            int maybeFlippedHeight = isCandidatePortrait ? realHeight : realWidth;
            LogUtils.d(String.format("maybeFlipped:%d * %d", maybeFlippedWidth, maybeFlippedHeight));
            double aspectRatio = (double)maybeFlippedWidth / (double)maybeFlippedHeight;
            LogUtils.d("aspectRatio: " + aspectRatio);
            double distortion = Math.abs(aspectRatio - screenAspectRatio);
            LogUtils.d("distortion: " + distortion);
            if (distortion > 0.05) continue;
            if (maybeFlippedWidth == screenResolution.x && maybeFlippedHeight == screenResolution.y) {
                Point exactPoint = new Point(realWidth, realHeight);
                LogUtils.d("Found preview size exactly matching screen size: " + exactPoint);
                return exactPoint;
            }
            if (resolution <= maxResolution) continue;
            maxResolution = resolution;
            maxResPreviewSize = size;
        }
        if (maxResPreviewSize != null) {
            Point largestSize = new Point(maxResPreviewSize.width, maxResPreviewSize.height);
            LogUtils.d("Using largest suitable preview size: " + largestSize);
            return largestSize;
        }
        Camera.Size defaultPreview = parameters.getPreviewSize();
        if (defaultPreview == null) {
            throw new IllegalStateException("Parameters contained no preview size!");
        }
        Point defaultSize = new Point(defaultPreview.width, defaultPreview.height);
        LogUtils.d("No suitable preview sizes, using default: " + defaultSize);
        return defaultSize;
    }

    private static String findSettableValue(String name, Collection<String> supportedValues, String ... desiredValues) {
        LogUtils.d("Requesting " + name + " value from among: " + Arrays.toString(desiredValues));
        LogUtils.d("Supported " + name + " values: " + supportedValues);
        if (supportedValues != null) {
            for (String desiredValue : desiredValues) {
                if (!supportedValues.contains(desiredValue)) continue;
                LogUtils.d("Can set " + name + " to: " + desiredValue);
                return desiredValue;
            }
        }
        LogUtils.d("No supported values match");
        return null;
    }

    private static String toString(Collection<int[]> arrays) {
        if (arrays == null || arrays.isEmpty()) {
            return "[]";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append('[');
        Iterator<int[]> it = arrays.iterator();
        while (it.hasNext()) {
            buffer.append(Arrays.toString(it.next()));
            if (!it.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append(']');
        return buffer.toString();
    }

    private static String toString(Iterable<Camera.Area> areas) {
        if (areas == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (Camera.Area area : areas) {
            result.append(area.rect).append(':').append(area.weight).append(' ');
        }
        return result.toString();
    }

    public static String collectStats(Camera.Parameters parameters) {
        return CameraConfigurationUtils.collectStats(parameters.flatten());
    }

    public static String collectStats(CharSequence flattenedParams) {
        StringBuilder result = new StringBuilder(1000);
        result.append("BOARD=").append(Build.BOARD).append('\n');
        result.append("BRAND=").append(Build.BRAND).append('\n');
        result.append("CPU_ABI=").append(Build.CPU_ABI).append('\n');
        result.append("DEVICE=").append(Build.DEVICE).append('\n');
        result.append("DISPLAY=").append(Build.DISPLAY).append('\n');
        result.append("FINGERPRINT=").append(Build.FINGERPRINT).append('\n');
        result.append("HOST=").append(Build.HOST).append('\n');
        result.append("ID=").append(Build.ID).append('\n');
        result.append("MANUFACTURER=").append(Build.MANUFACTURER).append('\n');
        result.append("MODEL=").append(Build.MODEL).append('\n');
        result.append("PRODUCT=").append(Build.PRODUCT).append('\n');
        result.append("TAGS=").append(Build.TAGS).append('\n');
        result.append("TIME=").append(Build.TIME).append('\n');
        result.append("TYPE=").append(Build.TYPE).append('\n');
        result.append("USER=").append(Build.USER).append('\n');
        result.append("VERSION.CODENAME=").append(Build.VERSION.CODENAME).append('\n');
        result.append("VERSION.INCREMENTAL=").append(Build.VERSION.INCREMENTAL).append('\n');
        result.append("VERSION.RELEASE=").append(Build.VERSION.RELEASE).append('\n');
        result.append("VERSION.SDK_INT=").append(Build.VERSION.SDK_INT).append('\n');
        if (flattenedParams != null) {
            Object[] params = SEMICOLON.split(flattenedParams);
            Arrays.sort(params);
            for (Object param : params) {
                result.append((String)param).append('\n');
            }
        }
        return result.toString();
    }
}

