/*
 * Decompiled with CFR 0.152.
 */
package com.yonghui.zxing;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Handler;
import android.os.Looper;
import android.preference.PreferenceManager;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.ResultPointCallback;
import com.yonghui.zxing.CaptureHandler;
import com.yonghui.zxing.DecodeFormatManager;
import com.yonghui.zxing.DecodeHandler;
import com.yonghui.zxing.camera.CameraManager;
import com.yonghui.zxing.util.LogUtils;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

final class DecodeThread
extends Thread {
    public static final String BARCODE_BITMAP = "barcode_bitmap";
    public static final String BARCODE_SCALED_FACTOR = "barcode_scaled_factor";
    private final Context context;
    private final CameraManager cameraManager;
    private final Map<DecodeHintType, Object> hints;
    private Handler handler;
    private CaptureHandler captureHandler;
    private final CountDownLatch handlerInitLatch;

    DecodeThread(Context context, CameraManager cameraManager, CaptureHandler captureHandler, Collection<BarcodeFormat> decodeFormats, Map<DecodeHintType, Object> baseHints, String characterSet, ResultPointCallback resultPointCallback) {
        this.context = context;
        this.cameraManager = cameraManager;
        this.captureHandler = captureHandler;
        this.handlerInitLatch = new CountDownLatch(1);
        this.hints = new EnumMap<DecodeHintType, Object>(DecodeHintType.class);
        if (baseHints != null) {
            this.hints.putAll(baseHints);
        }
        if (decodeFormats == null || decodeFormats.isEmpty()) {
            SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)context);
            decodeFormats = EnumSet.noneOf(BarcodeFormat.class);
            if (prefs.getBoolean("preferences_decode_1D_product", true)) {
                decodeFormats.addAll(DecodeFormatManager.PRODUCT_FORMATS);
            }
            if (prefs.getBoolean("preferences_decode_1D_industrial", true)) {
                decodeFormats.addAll(DecodeFormatManager.INDUSTRIAL_FORMATS);
            }
            if (prefs.getBoolean("preferences_decode_QR", true)) {
                decodeFormats.addAll(DecodeFormatManager.QR_CODE_FORMATS);
            }
            if (prefs.getBoolean("preferences_decode_Data_Matrix", true)) {
                decodeFormats.addAll(DecodeFormatManager.DATA_MATRIX_FORMATS);
            }
            if (prefs.getBoolean("preferences_decode_Aztec", false)) {
                decodeFormats.addAll(DecodeFormatManager.AZTEC_FORMATS);
            }
            if (prefs.getBoolean("preferences_decode_PDF417", false)) {
                decodeFormats.addAll(DecodeFormatManager.PDF417_FORMATS);
            }
        }
        this.hints.put(DecodeHintType.POSSIBLE_FORMATS, decodeFormats);
        if (characterSet != null) {
            this.hints.put(DecodeHintType.CHARACTER_SET, characterSet);
        }
        this.hints.put(DecodeHintType.NEED_RESULT_POINT_CALLBACK, resultPointCallback);
        LogUtils.i("Hints: " + this.hints);
    }

    Handler getHandler() {
        try {
            this.handlerInitLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.handler;
    }

    @Override
    public void run() {
        Looper.prepare();
        this.handler = new DecodeHandler(this.context, this.cameraManager, this.captureHandler, this.hints);
        this.handlerInitLatch.countDown();
        Looper.loop();
    }
}

