/*
 * Decompiled with CFR 0.152.
 */
package com.yonghui.zxing;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.Camera;
import android.support.annotation.FloatRange;
import android.support.v4.app.Fragment;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.Result;
import com.yonghui.zxing.AmbientLightManager;
import com.yonghui.zxing.BeepManager;
import com.yonghui.zxing.CaptureHandler;
import com.yonghui.zxing.CaptureLifecycle;
import com.yonghui.zxing.CaptureManager;
import com.yonghui.zxing.CaptureTouchEvent;
import com.yonghui.zxing.InactivityTimer;
import com.yonghui.zxing.OnCaptureCallback;
import com.yonghui.zxing.OnCaptureListener;
import com.yonghui.zxing.ViewfinderView;
import com.yonghui.zxing.camera.CameraManager;
import com.yonghui.zxing.camera.FrontLightMode;
import com.yonghui.zxing.util.LogUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;

public class CaptureHelper
implements CaptureLifecycle,
CaptureTouchEvent,
CaptureManager,
SurfaceHolder.Callback {
    private Activity activity;
    private CaptureHandler captureHandler;
    private OnCaptureListener onCaptureListener;
    private CameraManager cameraManager;
    private InactivityTimer inactivityTimer;
    private BeepManager beepManager;
    private AmbientLightManager ambientLightManager;
    private SurfaceView surfaceView;
    private ViewfinderView viewfinderView;
    private SurfaceHolder surfaceHolder;
    private View ivTorch;
    private Collection<BarcodeFormat> decodeFormats;
    private Map<DecodeHintType, Object> decodeHints;
    private String characterSet;
    private boolean hasSurface;
    private static final int DEVIATION = 6;
    private boolean isSupportZoom = true;
    private float oldDistance;
    private boolean isSupportAutoZoom = true;
    private boolean isSupportLuminanceInvert = false;
    private boolean isContinuousScan = false;
    private boolean isAutoRestartPreviewAndDecode = true;
    private boolean isPlayBeep;
    private boolean isVibrate;
    private boolean isSupportVerticalCode;
    private boolean isReturnBitmap;
    private boolean isFullScreenScan;
    private float framingRectRatio = 0.9f;
    private int framingRectVerticalOffset;
    private int framingRectHorizontalOffset;
    private float tooDarkLux = 45.0f;
    private float brightEnoughLux = 100.0f;
    private OnCaptureCallback onCaptureCallback;
    private boolean hasCameraFlash;

    @Deprecated
    public CaptureHelper(Fragment fragment, SurfaceView surfaceView, ViewfinderView viewfinderView) {
        this(fragment, surfaceView, viewfinderView, null);
    }

    public CaptureHelper(Fragment fragment, SurfaceView surfaceView, ViewfinderView viewfinderView, View ivTorch) {
        this((Activity)fragment.getActivity(), surfaceView, viewfinderView, ivTorch);
    }

    @Deprecated
    public CaptureHelper(Activity activity, SurfaceView surfaceView, ViewfinderView viewfinderView) {
        this(activity, surfaceView, viewfinderView, null);
    }

    public CaptureHelper(Activity activity, SurfaceView surfaceView, ViewfinderView viewfinderView, View ivTorch) {
        this.activity = activity;
        this.surfaceView = surfaceView;
        this.viewfinderView = viewfinderView;
        this.ivTorch = ivTorch;
    }

    @Override
    public void onCreate() {
        this.surfaceHolder = this.surfaceView.getHolder();
        this.hasSurface = false;
        this.inactivityTimer = new InactivityTimer(this.activity);
        this.beepManager = new BeepManager(this.activity);
        this.ambientLightManager = new AmbientLightManager((Context)this.activity);
        this.hasCameraFlash = this.activity.getPackageManager().hasSystemFeature("android.hardware.camera.flash");
        this.initCameraManager();
        this.onCaptureListener = (result, barcode, scaleFactor) -> {
            this.inactivityTimer.onActivity();
            this.beepManager.playBeepSoundAndVibrate();
            this.onResult(result, barcode, scaleFactor);
        };
        this.beepManager.setPlayBeep(this.isPlayBeep);
        this.beepManager.setVibrate(this.isVibrate);
        this.ambientLightManager.setTooDarkLux(this.tooDarkLux);
        this.ambientLightManager.setBrightEnoughLux(this.brightEnoughLux);
    }

    @Override
    public void onResume() {
        this.beepManager.updatePrefs();
        this.inactivityTimer.onResume();
        if (this.hasSurface) {
            this.initCamera(this.surfaceHolder);
        } else {
            this.surfaceHolder.addCallback((SurfaceHolder.Callback)this);
        }
        this.ambientLightManager.start(this.cameraManager);
    }

    @Override
    public void onPause() {
        if (this.captureHandler != null) {
            this.captureHandler.quitSynchronously();
            this.captureHandler = null;
        }
        this.inactivityTimer.onPause();
        this.ambientLightManager.stop();
        this.beepManager.close();
        this.cameraManager.closeDriver();
        if (!this.hasSurface) {
            this.surfaceHolder.removeCallback((SurfaceHolder.Callback)this);
        }
        if (this.ivTorch != null && this.ivTorch.getVisibility() == 0) {
            this.ivTorch.setSelected(false);
            this.ivTorch.setVisibility(4);
        }
    }

    @Override
    public void onDestroy() {
        this.inactivityTimer.shutdown();
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        if (this.isSupportZoom && this.cameraManager.isOpen()) {
            Camera camera = this.cameraManager.getOpenCamera().getCamera();
            if (camera == null) {
                return false;
            }
            if (event.getPointerCount() > 1) {
                switch (event.getAction() & 0xFF) {
                    case 5: {
                        this.oldDistance = this.calcFingerSpacing(event);
                        break;
                    }
                    case 2: {
                        float newDistance = this.calcFingerSpacing(event);
                        if (newDistance > this.oldDistance + 6.0f) {
                            this.handleZoom(true, camera);
                        } else if (newDistance < this.oldDistance - 6.0f) {
                            this.handleZoom(false, camera);
                        }
                        this.oldDistance = newDistance;
                    }
                }
                return true;
            }
        }
        return false;
    }

    private void initCameraManager() {
        this.cameraManager = new CameraManager((Context)this.activity);
        this.cameraManager.setFullScreenScan(this.isFullScreenScan);
        this.cameraManager.setFramingRectRatio(this.framingRectRatio);
        this.cameraManager.setFramingRectVerticalOffset(this.framingRectVerticalOffset);
        this.cameraManager.setFramingRectHorizontalOffset(this.framingRectHorizontalOffset);
        if (this.ivTorch != null && this.hasCameraFlash) {
            this.ivTorch.setOnClickListener(v -> {
                if (this.cameraManager != null) {
                    this.cameraManager.setTorch(!this.ivTorch.isSelected());
                }
            });
            this.cameraManager.setOnSensorListener((torch, tooDark, ambientLightLux) -> {
                if (tooDark) {
                    if (this.ivTorch.getVisibility() != 0) {
                        this.ivTorch.setVisibility(0);
                    }
                } else if (!torch && this.ivTorch.getVisibility() == 0) {
                    this.ivTorch.setVisibility(4);
                }
            });
            this.cameraManager.setOnTorchListener(torch -> this.ivTorch.setSelected(torch));
        }
    }

    private void initCamera(SurfaceHolder surfaceHolder) {
        if (surfaceHolder == null) {
            throw new IllegalStateException("No SurfaceHolder provided");
        }
        if (this.cameraManager.isOpen()) {
            LogUtils.w("initCamera() while already open -- late SurfaceView callback?");
            return;
        }
        try {
            this.cameraManager.openDriver(surfaceHolder);
            if (this.captureHandler == null) {
                this.captureHandler = new CaptureHandler(this.activity, this.viewfinderView, this.onCaptureListener, this.decodeFormats, this.decodeHints, this.characterSet, this.cameraManager);
                this.captureHandler.setSupportVerticalCode(this.isSupportVerticalCode);
                this.captureHandler.setReturnBitmap(this.isReturnBitmap);
                this.captureHandler.setSupportAutoZoom(this.isSupportAutoZoom);
                this.captureHandler.setSupportLuminanceInvert(this.isSupportLuminanceInvert);
            }
        }
        catch (IOException ioe) {
            LogUtils.w(ioe);
        }
        catch (RuntimeException e) {
            LogUtils.w("Unexpected error initializing camera", e);
        }
    }

    public void surfaceCreated(SurfaceHolder holder) {
        if (holder == null) {
            LogUtils.w("*** WARNING *** surfaceCreated() gave us a null surface!");
        }
        if (!this.hasSurface) {
            this.hasSurface = true;
            this.initCamera(holder);
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.hasSurface = false;
    }

    private void handleZoom(boolean isZoomIn, Camera camera) {
        Camera.Parameters params = camera.getParameters();
        if (params.isZoomSupported()) {
            int maxZoom = params.getMaxZoom();
            int zoom = params.getZoom();
            if (isZoomIn && zoom < maxZoom) {
                ++zoom;
            } else if (zoom > 0) {
                --zoom;
            }
            params.setZoom(zoom);
            camera.setParameters(params);
        } else {
            LogUtils.i("zoom not supported");
        }
    }

    @Deprecated
    private void focusOnTouch(MotionEvent event, Camera camera) {
        Camera.Parameters params = camera.getParameters();
        Camera.Size previewSize = params.getPreviewSize();
        Rect focusRect = this.calcTapArea(event.getRawX(), event.getRawY(), 1.0f, previewSize);
        Rect meteringRect = this.calcTapArea(event.getRawX(), event.getRawY(), 1.5f, previewSize);
        Camera.Parameters parameters = camera.getParameters();
        if (parameters.getMaxNumFocusAreas() > 0) {
            ArrayList<Camera.Area> focusAreas = new ArrayList<Camera.Area>();
            focusAreas.add(new Camera.Area(focusRect, 600));
            parameters.setFocusAreas(focusAreas);
        }
        if (parameters.getMaxNumMeteringAreas() > 0) {
            ArrayList<Camera.Area> meteringAreas = new ArrayList<Camera.Area>();
            meteringAreas.add(new Camera.Area(meteringRect, 600));
            parameters.setMeteringAreas(meteringAreas);
        }
        String currentFocusMode = params.getFocusMode();
        params.setFocusMode("macro");
        camera.setParameters(params);
        camera.autoFocus((success, camera1) -> {
            Camera.Parameters params1 = camera1.getParameters();
            params1.setFocusMode(currentFocusMode);
            camera1.setParameters(params1);
        });
    }

    private float calcFingerSpacing(MotionEvent event) {
        float x = event.getX(0) - event.getX(1);
        float y = event.getY(0) - event.getY(1);
        return (float)Math.sqrt(x * x + y * y);
    }

    private Rect calcTapArea(float x, float y, float coefficient, Camera.Size previewSize) {
        float focusAreaSize = 200.0f;
        int areaSize = Float.valueOf(focusAreaSize * coefficient).intValue();
        int centerX = (int)(x / (float)previewSize.width * 2000.0f - 1000.0f);
        int centerY = (int)(y / (float)previewSize.height * 2000.0f - 1000.0f);
        int left = this.clamp(centerX - areaSize / 2, -1000, 1000);
        int top = this.clamp(centerY - areaSize / 2, -1000, 1000);
        RectF rectF = new RectF((float)left, (float)top, (float)(left + areaSize), (float)(top + areaSize));
        return new Rect(Math.round(rectF.left), Math.round(rectF.top), Math.round(rectF.right), Math.round(rectF.bottom));
    }

    private int clamp(int x, int min, int max) {
        if (x > max) {
            return max;
        }
        if (x < min) {
            return min;
        }
        return x;
    }

    public void restartPreviewAndDecode() {
        if (this.captureHandler != null) {
            this.captureHandler.restartPreviewAndDecode();
        }
    }

    public void onResult(Result result, Bitmap barcode, float scaleFactor) {
        this.onResult(result);
    }

    public void onResult(Result result) {
        String text = result.getText();
        if (this.isContinuousScan) {
            if (this.onCaptureCallback != null) {
                this.onCaptureCallback.onResultCallback(text);
            }
            if (this.isAutoRestartPreviewAndDecode) {
                this.restartPreviewAndDecode();
            }
            return;
        }
        if (this.isPlayBeep && this.captureHandler != null) {
            this.captureHandler.postDelayed(() -> {
                if (this.onCaptureCallback != null && this.onCaptureCallback.onResultCallback(text)) {
                    return;
                }
                Intent intent = new Intent();
                intent.putExtra("SCAN_RESULT", text);
                this.activity.setResult(-1, intent);
                this.activity.finish();
            }, 100L);
            return;
        }
        if (this.onCaptureCallback != null && this.onCaptureCallback.onResultCallback(text)) {
            return;
        }
        Intent intent = new Intent();
        intent.putExtra("SCAN_RESULT", text);
        this.activity.setResult(-1, intent);
        this.activity.finish();
    }

    public CaptureHelper continuousScan(boolean isContinuousScan) {
        this.isContinuousScan = isContinuousScan;
        return this;
    }

    public CaptureHelper autoRestartPreviewAndDecode(boolean isAutoRestartPreviewAndDecode) {
        this.isAutoRestartPreviewAndDecode = isAutoRestartPreviewAndDecode;
        return this;
    }

    public CaptureHelper playBeep(boolean playBeep) {
        this.isPlayBeep = playBeep;
        if (this.beepManager != null) {
            this.beepManager.setPlayBeep(playBeep);
        }
        return this;
    }

    public CaptureHelper vibrate(boolean vibrate) {
        this.isVibrate = vibrate;
        if (this.beepManager != null) {
            this.beepManager.setVibrate(vibrate);
        }
        return this;
    }

    public CaptureHelper supportZoom(boolean supportZoom) {
        this.isSupportZoom = supportZoom;
        return this;
    }

    public CaptureHelper decodeFormats(Collection<BarcodeFormat> decodeFormats) {
        this.decodeFormats = decodeFormats;
        return this;
    }

    public CaptureHelper decodeHints(Map<DecodeHintType, Object> decodeHints) {
        this.decodeHints = decodeHints;
        return this;
    }

    public CaptureHelper decodeHint(DecodeHintType key, Object value) {
        if (this.decodeHints == null) {
            this.decodeHints = new EnumMap<DecodeHintType, Object>(DecodeHintType.class);
        }
        this.decodeHints.put(key, value);
        return this;
    }

    public CaptureHelper characterSet(String characterSet) {
        this.characterSet = characterSet;
        return this;
    }

    public CaptureHelper supportVerticalCode(boolean supportVerticalCode) {
        this.isSupportVerticalCode = supportVerticalCode;
        if (this.captureHandler != null) {
            this.captureHandler.setSupportVerticalCode(this.isSupportVerticalCode);
        }
        return this;
    }

    public CaptureHelper frontLightMode(FrontLightMode mode) {
        FrontLightMode.put((Context)this.activity, mode);
        if (this.ivTorch != null && mode != FrontLightMode.AUTO) {
            this.ivTorch.setVisibility(4);
        }
        return this;
    }

    public CaptureHelper tooDarkLux(float tooDarkLux) {
        this.tooDarkLux = tooDarkLux;
        if (this.ambientLightManager != null) {
            this.ambientLightManager.setTooDarkLux(tooDarkLux);
        }
        return this;
    }

    public CaptureHelper brightEnoughLux(float brightEnoughLux) {
        this.brightEnoughLux = brightEnoughLux;
        if (this.ambientLightManager != null) {
            this.ambientLightManager.setTooDarkLux(this.tooDarkLux);
        }
        return this;
    }

    public CaptureHelper returnBitmap(boolean returnBitmap) {
        this.isReturnBitmap = returnBitmap;
        if (this.captureHandler != null) {
            this.captureHandler.setReturnBitmap(this.isReturnBitmap);
        }
        return this;
    }

    public CaptureHelper supportAutoZoom(boolean supportAutoZoom) {
        this.isSupportAutoZoom = supportAutoZoom;
        if (this.captureHandler != null) {
            this.captureHandler.setSupportAutoZoom(this.isSupportAutoZoom);
        }
        return this;
    }

    public CaptureHelper supportLuminanceInvert(boolean supportLuminanceInvert) {
        this.isSupportLuminanceInvert = supportLuminanceInvert;
        if (this.captureHandler != null) {
            this.captureHandler.setSupportLuminanceInvert(this.isSupportLuminanceInvert);
        }
        return this;
    }

    public CaptureHelper fullScreenScan(boolean fullScreenScan) {
        this.isFullScreenScan = fullScreenScan;
        if (this.cameraManager != null) {
            this.cameraManager.setFullScreenScan(this.isFullScreenScan);
        }
        return this;
    }

    public CaptureHelper framingRectRatio(@FloatRange(from=0.0, to=1.0) float framingRectRatio) {
        this.framingRectRatio = framingRectRatio;
        if (this.cameraManager != null) {
            this.cameraManager.setFramingRectRatio(framingRectRatio);
        }
        return this;
    }

    public CaptureHelper framingRectVerticalOffset(int framingRectVerticalOffset) {
        this.framingRectVerticalOffset = framingRectVerticalOffset;
        if (this.cameraManager != null) {
            this.cameraManager.setFramingRectVerticalOffset(framingRectVerticalOffset);
        }
        return this;
    }

    public CaptureHelper framingRectHorizontalOffset(int framingRectHorizontalOffset) {
        this.framingRectHorizontalOffset = framingRectHorizontalOffset;
        if (this.cameraManager != null) {
            this.cameraManager.setFramingRectHorizontalOffset(framingRectHorizontalOffset);
        }
        return this;
    }

    public CaptureHelper setOnCaptureCallback(OnCaptureCallback callback) {
        this.onCaptureCallback = callback;
        return this;
    }

    @Override
    public CameraManager getCameraManager() {
        return this.cameraManager;
    }

    @Override
    public BeepManager getBeepManager() {
        return this.beepManager;
    }

    @Override
    public AmbientLightManager getAmbientLightManager() {
        return this.ambientLightManager;
    }

    @Override
    public InactivityTimer getInactivityTimer() {
        return this.inactivityTimer;
    }
}

