/*
 * Decompiled with CFR 0.152.
 */
package com.yonghui.zxing;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.AsyncTask;
import com.yonghui.zxing.util.LogUtils;
import java.lang.ref.WeakReference;
import java.util.concurrent.RejectedExecutionException;

final class InactivityTimer {
    private static final long INACTIVITY_DELAY_MS = 300000L;
    private final Activity activity;
    private final BroadcastReceiver powerStatusReceiver;
    private boolean registered;
    private AsyncTask<Object, Object, Object> inactivityTask;

    InactivityTimer(Activity activity) {
        this.activity = activity;
        this.powerStatusReceiver = new PowerStatusReceiver(this);
        this.registered = false;
        this.onActivity();
    }

    void onActivity() {
        this.cancel();
        this.inactivityTask = new InactivityAsyncTask(this.activity);
        try {
            this.inactivityTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Object[0]);
        }
        catch (RejectedExecutionException ree) {
            LogUtils.w("Couldn't schedule inactivity task; ignoring");
        }
    }

    void onPause() {
        this.cancel();
        if (this.registered) {
            this.activity.unregisterReceiver(this.powerStatusReceiver);
            this.registered = false;
        } else {
            LogUtils.w("PowerStatusReceiver was never registered?");
        }
    }

    void onResume() {
        if (this.registered) {
            LogUtils.w("PowerStatusReceiver was already registered?");
        } else {
            this.activity.registerReceiver(this.powerStatusReceiver, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
            this.registered = true;
        }
        this.onActivity();
    }

    private void cancel() {
        AsyncTask<Object, Object, Object> task = this.inactivityTask;
        if (task != null) {
            task.cancel(true);
            this.inactivityTask = null;
        }
    }

    void shutdown() {
        this.cancel();
    }

    private static class InactivityAsyncTask
    extends AsyncTask<Object, Object, Object> {
        private WeakReference<Activity> weakReference;

        public InactivityAsyncTask(Activity activity) {
            this.weakReference = new WeakReference<Activity>(activity);
        }

        protected Object doInBackground(Object ... objects) {
            try {
                Thread.sleep(300000L);
                LogUtils.i("Finishing activity due to inactivity");
                Activity activity = (Activity)this.weakReference.get();
                if (activity != null) {
                    activity.finish();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return null;
        }
    }

    private static class PowerStatusReceiver
    extends BroadcastReceiver {
        private WeakReference<InactivityTimer> weakReference;

        public PowerStatusReceiver(InactivityTimer inactivityTimer) {
            this.weakReference = new WeakReference<InactivityTimer>(inactivityTimer);
        }

        public void onReceive(Context context, Intent intent) {
            InactivityTimer inactivityTimer;
            if ("android.intent.action.BATTERY_CHANGED".equals(intent.getAction()) && (inactivityTimer = (InactivityTimer)this.weakReference.get()) != null) {
                boolean onBatteryNow;
                boolean bl = onBatteryNow = intent.getIntExtra("plugged", -1) <= 0;
                if (onBatteryNow) {
                    inactivityTimer.onActivity();
                } else {
                    inactivityTimer.cancel();
                }
            }
        }
    }
}

