/*
 * Decompiled with CFR 0.152.
 */
package com.yonghui.zxing;

import android.content.Context;
import android.content.SharedPreferences;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.preference.PreferenceManager;
import com.yonghui.zxing.camera.CameraManager;
import com.yonghui.zxing.camera.FrontLightMode;

final class AmbientLightManager
implements SensorEventListener {
    protected static final float TOO_DARK_LUX = 45.0f;
    protected static final float BRIGHT_ENOUGH_LUX = 100.0f;
    private float tooDarkLux = 45.0f;
    private float brightEnoughLux = 100.0f;
    private final Context context;
    private CameraManager cameraManager;
    private Sensor lightSensor;

    AmbientLightManager(Context context) {
        this.context = context;
    }

    void start(CameraManager cameraManager) {
        this.cameraManager = cameraManager;
        SharedPreferences sharedPrefs = PreferenceManager.getDefaultSharedPreferences((Context)this.context);
        if (FrontLightMode.readPref(sharedPrefs) == FrontLightMode.AUTO) {
            SensorManager sensorManager = (SensorManager)this.context.getSystemService("sensor");
            this.lightSensor = sensorManager.getDefaultSensor(5);
            if (this.lightSensor != null) {
                sensorManager.registerListener((SensorEventListener)this, this.lightSensor, 3);
            }
        }
    }

    void stop() {
        if (this.lightSensor != null) {
            SensorManager sensorManager = (SensorManager)this.context.getSystemService("sensor");
            sensorManager.unregisterListener((SensorEventListener)this);
            this.cameraManager = null;
            this.lightSensor = null;
        }
    }

    public void onSensorChanged(SensorEvent sensorEvent) {
        float ambientLightLux = sensorEvent.values[0];
        if (this.cameraManager != null) {
            if (ambientLightLux <= this.tooDarkLux) {
                this.cameraManager.sensorChanged(true, ambientLightLux);
            } else if (ambientLightLux >= this.brightEnoughLux) {
                this.cameraManager.sensorChanged(false, ambientLightLux);
            }
        }
    }

    public void setTooDarkLux(float tooDarkLux) {
        this.tooDarkLux = tooDarkLux;
    }

    public void setBrightEnoughLux(float brightEnoughLux) {
        this.brightEnoughLux = brightEnoughLux;
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }
}

