/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.sql.read.impl;

import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.parser.constant.ReadType;
import com.yomahub.liteflow.parser.sql.exception.ELSQLException;
import com.yomahub.liteflow.parser.sql.read.AbstractSqlRead;
import com.yomahub.liteflow.parser.sql.read.vo.ChainVO;
import com.yomahub.liteflow.parser.sql.vo.SQLParserVO;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ChainRead
extends AbstractSqlRead<ChainVO> {
    public ChainRead(SQLParserVO config) {
        super(config);
    }

    @Override
    protected ChainVO parse(ResultSet rs) throws SQLException {
        ChainVO chainVO = new ChainVO();
        chainVO.setChainId(this.getStringFromRsWithCheck(rs, this.config.getChainNameField()));
        chainVO.setBody(this.getStringFromRsWithCheck(rs, this.config.getElDataField()));
        if (StrUtil.isNotBlank((CharSequence)this.config.getNamespaceField())) {
            chainVO.setNamespace(this.getStringFromRs(rs, this.config.getNamespaceField()));
        }
        if (StrUtil.isNotBlank((CharSequence)this.config.getRouteField())) {
            chainVO.setRoute(this.getStringFromRs(rs, this.config.getRouteField()));
        }
        return chainVO;
    }

    @Override
    public boolean hasEnableFiled() {
        String chainEnableField = this.config.getChainEnableField();
        return StrUtil.isNotBlank((CharSequence)chainEnableField);
    }

    @Override
    public boolean getEnableFiledValue(ResultSet rs) throws SQLException {
        String chainEnableField = this.config.getChainEnableField();
        byte enable = rs.getByte(chainEnableField);
        return enable == 1;
    }

    @Override
    public String buildQuerySql() {
        if (StrUtil.isNotBlank((CharSequence)this.config.getChainCustomSql())) {
            return this.config.getChainCustomSql();
        }
        String chainTableName = this.config.getChainTableName();
        String chainApplicationNameField = this.config.getChainApplicationNameField();
        String applicationName = this.config.getApplicationName();
        return StrUtil.format((CharSequence)"SELECT * FROM {} WHERE {}='{}'", (Object[])new Object[]{chainTableName, chainApplicationNameField, applicationName});
    }

    @Override
    public String buildQuerySql(String chainId) {
        if (StrUtil.isNotBlank((CharSequence)this.config.getChainCustomSql())) {
            return this.config.getChainCustomSql();
        }
        String chainTableName = this.config.getChainTableName();
        String chainApplicationNameField = this.config.getChainApplicationNameField();
        String applicationName = this.config.getApplicationName();
        return StrUtil.format((CharSequence)"SELECT * FROM {} WHERE {}='{}' and  {}='{}'", (Object[])new Object[]{chainTableName, chainApplicationNameField, applicationName, this.config.getChainNameField(), chainId});
    }

    @Override
    public void checkConfig() {
        String chainTableName = this.config.getChainTableName();
        String elDataField = this.config.getElDataField();
        String chainNameField = this.config.getChainNameField();
        String chainApplicationNameField = this.config.getChainApplicationNameField();
        String applicationName = this.config.getApplicationName();
        if (StrUtil.isBlank((CharSequence)chainTableName)) {
            throw new ELSQLException("You did not define the chainTableName property");
        }
        if (StrUtil.isBlank((CharSequence)elDataField)) {
            throw new ELSQLException("You did not define the elDataField property");
        }
        if (StrUtil.isBlank((CharSequence)chainNameField)) {
            throw new ELSQLException("You did not define the chainNameField property");
        }
        if (StrUtil.isBlank((CharSequence)chainApplicationNameField)) {
            throw new ELSQLException("You did not define the chainApplicationNameField property");
        }
        if (StrUtil.isBlank((CharSequence)applicationName)) {
            throw new ELSQLException("You did not define the applicationName property");
        }
    }

    @Override
    public ReadType type() {
        return ReadType.CHAIN;
    }
}

