/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.sql.datasource.impl;

import cn.hutool.core.util.ClassLoaderUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.exception.MissMavenDependencyException;
import com.yomahub.liteflow.parser.sql.datasource.LiteFlowDataSourceConnect;
import com.yomahub.liteflow.parser.sql.vo.SQLParserVO;
import com.yomahub.liteflow.spi.ContextAware;
import com.yomahub.liteflow.spi.holder.ContextAwareHolder;
import java.sql.Connection;
import javax.sql.DataSource;

public class ShardingJdbcDsConn
implements LiteFlowDataSourceConnect {
    @Override
    public boolean filter(SQLParserVO config) {
        if (StrUtil.isBlank((CharSequence)config.getShardingJdbcDataSource())) {
            return false;
        }
        boolean classLoadFlag = ClassLoaderUtil.isPresent((String)"org.apache.shardingsphere.driver.jdbc.core.datasource.ShardingSphereDataSource");
        if (!classLoadFlag) {
            throw new MissMavenDependencyException("org.apache.shardingsphere", "sharding-jdbc-core");
        }
        return true;
    }

    @Override
    public Connection getConn(SQLParserVO config) throws Exception {
        ContextAware contextAware = ContextAwareHolder.loadContextAware();
        return ((DataSource)contextAware.getBean(DataSource.class)).getConnection();
    }

    public static class Constant {
        public static final String LOAD_CLASS_NAME = "org.apache.shardingsphere.driver.jdbc.core.datasource.ShardingSphereDataSource";
        public static final String MAVEN_GROUP_ID = "org.apache.shardingsphere";
        public static final String MAVEN_ARTIFACT_ID = "sharding-jdbc-core";
    }
}

