/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.slot;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import com.yomahub.liteflow.exception.NoSuchContextBeanException;
import com.yomahub.liteflow.exception.NullParamException;
import com.yomahub.liteflow.flow.entity.CmpStep;
import com.yomahub.liteflow.flow.id.IdGeneratorHolder;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slot {
    private static final Logger LOG = LoggerFactory.getLogger(Slot.class);
    private static final String REQUEST = "_request";
    private static final String RESPONSE = "_response";
    private static final String CHAIN_NAME = "_chain_name";
    private static final String SWITCH_NODE_PREFIX = "_switch_";
    private static final String NODE_INPUT_PREFIX = "_input_";
    private static final String NODE_OUTPUT_PREFIX = "_output_";
    private static final String CHAIN_REQ_PREFIX = "_chain_req_";
    private static final String REQUEST_ID = "_req_id";
    private static final String EXCEPTION = "_exception";
    private static final String PRIVATE_DELIVERY_PREFIX = "_private_d_";
    private final Deque<CmpStep> executeSteps = new ConcurrentLinkedDeque<CmpStep>();
    private String executeStepsStr;
    protected ConcurrentHashMap<String, Object> metaDataMap = new ConcurrentHashMap();
    private List<Object> contextBeanList;

    public Slot() {
    }

    public Slot(List<Object> contextBeanList) {
        this.contextBeanList = contextBeanList;
    }

    private boolean hasMetaData(String key) {
        return this.metaDataMap.containsKey(key);
    }

    private <T> void putMetaDataMap(String key, T t) {
        if (ObjectUtil.isNull(t)) {
            throw new NullParamException("data slot can't accept null param");
        }
        this.metaDataMap.put(key, t);
    }

    public <T> T getInput(String nodeId) {
        return (T)this.metaDataMap.get(NODE_INPUT_PREFIX + nodeId);
    }

    public <T> T getOutput(String nodeId) {
        return (T)this.metaDataMap.get(NODE_OUTPUT_PREFIX + nodeId);
    }

    public <T> void setInput(String nodeId, T t) {
        this.putMetaDataMap(NODE_INPUT_PREFIX + nodeId, t);
    }

    public <T> void setOutput(String nodeId, T t) {
        this.putMetaDataMap(NODE_OUTPUT_PREFIX + nodeId, t);
    }

    public <T> T getRequestData() {
        return (T)this.metaDataMap.get(REQUEST);
    }

    public <T> void setRequestData(T t) {
        this.putMetaDataMap(REQUEST, t);
    }

    public <T> T getResponseData() {
        return (T)this.metaDataMap.get(RESPONSE);
    }

    public <T> void setResponseData(T t) {
        this.putMetaDataMap(RESPONSE, t);
    }

    public <T> T getChainReqData(String chainId) {
        String key = CHAIN_REQ_PREFIX + chainId;
        if (this.hasMetaData(key)) {
            Queue queue = (Queue)this.metaDataMap.get(key);
            return (T)queue.poll();
        }
        return null;
    }

    public synchronized <T> void setChainReqData(String chainId, T t) {
        String key = CHAIN_REQ_PREFIX + chainId;
        if (this.hasMetaData(key)) {
            Queue queue = (Queue)this.metaDataMap.get(key);
            queue.offer(t);
        } else {
            this.putMetaDataMap(key, new ConcurrentLinkedQueue(ListUtil.toList((Object[])new Object[]{t})));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void setPrivateDeliveryData(String nodeId, T t) {
        String privateDKey = PRIVATE_DELIVERY_PREFIX + nodeId;
        Slot slot = this;
        synchronized (slot) {
            if (this.metaDataMap.containsKey(privateDKey)) {
                Queue queue = (Queue)this.metaDataMap.get(privateDKey);
                queue.add(t);
            } else {
                ConcurrentLinkedQueue<T> queue = new ConcurrentLinkedQueue<T>();
                queue.add(t);
                this.putMetaDataMap(privateDKey, queue);
            }
        }
    }

    public <T> Queue<T> getPrivateDeliveryQueue(String nodeId) {
        String privateDKey = PRIVATE_DELIVERY_PREFIX + nodeId;
        if (this.metaDataMap.containsKey(privateDKey)) {
            return (Queue)this.metaDataMap.get(privateDKey);
        }
        return null;
    }

    public <T> T getPrivateDeliveryData(String nodeId) {
        String privateDKey = PRIVATE_DELIVERY_PREFIX + nodeId;
        if (this.metaDataMap.containsKey(privateDKey)) {
            Queue queue = (Queue)this.metaDataMap.get(privateDKey);
            return (T)queue.poll();
        }
        return null;
    }

    public <T> void setSwitchResult(String key, T t) {
        this.putMetaDataMap(SWITCH_NODE_PREFIX + key, t);
    }

    public <T> T getSwitchResult(String key) {
        return (T)this.metaDataMap.get(SWITCH_NODE_PREFIX + key);
    }

    public void setChainName(String chainName) {
        if (!this.hasMetaData(CHAIN_NAME)) {
            this.putMetaDataMap(CHAIN_NAME, chainName);
        }
    }

    public String getChainName() {
        return (String)this.metaDataMap.get(CHAIN_NAME);
    }

    public void addStep(CmpStep step) {
        this.executeSteps.add(step);
    }

    public String getExecuteStepStr(boolean withTimeSpent) {
        StringBuilder str = new StringBuilder();
        Iterator<CmpStep> it = this.executeSteps.iterator();
        while (it.hasNext()) {
            CmpStep cmpStep = it.next();
            if (withTimeSpent) {
                str.append(cmpStep.buildStringWithTime());
            } else {
                str.append(cmpStep.buildString());
            }
            if (!it.hasNext()) continue;
            str.append("==>");
        }
        this.executeStepsStr = str.toString();
        return this.executeStepsStr;
    }

    public String getExecuteStepStr() {
        return this.getExecuteStepStr(false);
    }

    public void printStep() {
        if (ObjectUtil.isNull((Object)this.executeStepsStr)) {
            this.executeStepsStr = this.getExecuteStepStr(true);
        }
        LOG.info("[{}]:CHAIN_NAME[{}]\n{}", new Object[]{this.getRequestId(), this.getChainName(), this.executeStepsStr});
    }

    public void generateRequestId() {
        this.metaDataMap.put(REQUEST_ID, IdGeneratorHolder.getInstance().generate());
    }

    public String getRequestId() {
        return (String)this.metaDataMap.get(REQUEST_ID);
    }

    public Deque<CmpStep> getExecuteSteps() {
        return this.executeSteps;
    }

    public Exception getException() {
        return (Exception)this.metaDataMap.get(EXCEPTION);
    }

    public void setException(Exception e) {
        this.putMetaDataMap(EXCEPTION, e);
    }

    public List<Object> getContextBeanList() {
        return this.contextBeanList;
    }

    public <T> T getContextBean(Class<T> contextBeanClazz) {
        T t = this.contextBeanList.stream().filter(o -> o.getClass().equals(contextBeanClazz)).findFirst().orElse(null);
        if (t == null) {
            throw new NoSuchContextBeanException("this type is not in the context type passed in");
        }
        return t;
    }

    public <T> T getFirstContextBean() {
        Class<?> firstContextBeanClazz = this.getContextBeanList().get(0).getClass();
        return (T)this.getContextBean(firstContextBeanClazz);
    }
}

