/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.helper;

import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.exception.ParseException;
import java.text.MessageFormat;
import java.util.List;
import java.util.function.Consumer;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.curator.retry.RetryNTimes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkParserHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ZkParserHelper.class);
    private final String nodePath;
    private final Consumer<String> parseConsumer;

    public ZkParserHelper(String node, Consumer<String> parseConsumer) {
        this.nodePath = node;
        this.parseConsumer = parseConsumer;
    }

    public CuratorFramework getZkCuratorFramework(List<String> pathList) throws Exception {
        String path = pathList.get(0);
        CuratorFramework client = CuratorFrameworkFactory.newClient((String)path, (RetryPolicy)new RetryNTimes(10, 5000));
        client.start();
        if (client.checkExists().forPath(this.nodePath) == null) {
            client.create().creatingParentsIfNeeded().forPath(this.nodePath, "".getBytes());
        }
        return client;
    }

    public void checkContent(String content) {
        if (StrUtil.isBlank((CharSequence)content)) {
            String error = MessageFormat.format("the node[{0}] value is empty", this.nodePath);
            throw new ParseException(error);
        }
    }

    public void listenZkNode(CuratorFramework client) throws Exception {
        NodeCache cache = new NodeCache(client, this.nodePath);
        cache.start();
        cache.getListenable().addListener(() -> {
            String content1 = new String(cache.getCurrentData().getData());
            LOG.info("stating load flow config....");
            this.parseConsumer.accept(content1);
        });
    }
}

