/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.helper;

import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.yomahub.liteflow.annotation.LiteflowCmpDefine;
import com.yomahub.liteflow.annotation.LiteflowSwitchCmpDefine;
import com.yomahub.liteflow.builder.LiteFlowChainBuilder;
import com.yomahub.liteflow.builder.LiteFlowConditionBuilder;
import com.yomahub.liteflow.builder.LiteFlowNodeBuilder;
import com.yomahub.liteflow.builder.el.LiteFlowChainELBuilder;
import com.yomahub.liteflow.builder.prop.ChainPropBean;
import com.yomahub.liteflow.builder.prop.NodePropBean;
import com.yomahub.liteflow.core.NodeComponent;
import com.yomahub.liteflow.core.NodeSwitchComponent;
import com.yomahub.liteflow.enums.ConditionTypeEnum;
import com.yomahub.liteflow.enums.NodeTypeEnum;
import com.yomahub.liteflow.exception.ChainDuplicateException;
import com.yomahub.liteflow.exception.EmptyConditionValueException;
import com.yomahub.liteflow.exception.NodeClassNotFoundException;
import com.yomahub.liteflow.exception.NodeTypeCanNotGuessException;
import com.yomahub.liteflow.exception.NodeTypeNotSupportException;
import com.yomahub.liteflow.exception.NotSupportConditionException;
import com.yomahub.liteflow.flow.FlowBus;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.Element;

public class ParserHelper {
    private ParserHelper() {
    }

    public static void buildNode(NodePropBean nodePropBean) {
        String id = nodePropBean.getId();
        String name = nodePropBean.getName();
        String clazz = nodePropBean.getClazz();
        String script = nodePropBean.getScript();
        String type = nodePropBean.getType();
        String file = nodePropBean.getFile();
        if (StrUtil.isNotBlank((CharSequence)clazz)) {
            try {
                LiteflowSwitchCmpDefine liteflowSwitchCmpDefine;
                LiteflowCmpDefine liteflowCmpDefine;
                Class<?> c = Class.forName(clazz);
                Object o = ReflectUtil.newInstanceIfPossible(c);
                if (o instanceof NodeSwitchComponent) {
                    type = NodeTypeEnum.SWITCH.getCode();
                } else if (o instanceof NodeComponent) {
                    type = NodeTypeEnum.COMMON.getCode();
                }
                if (type == null && (liteflowCmpDefine = (LiteflowCmpDefine)AnnotationUtil.getAnnotation(c, LiteflowCmpDefine.class)) != null) {
                    type = NodeTypeEnum.COMMON.getCode();
                }
                if (type == null && (liteflowSwitchCmpDefine = (LiteflowSwitchCmpDefine)AnnotationUtil.getAnnotation(c, LiteflowSwitchCmpDefine.class)) != null) {
                    type = NodeTypeEnum.SWITCH.getCode();
                }
            }
            catch (Exception e) {
                throw new NodeClassNotFoundException(StrUtil.format((CharSequence)"cannot find the node[{}]", (Object[])new Object[]{clazz}));
            }
        }
        if (StrUtil.isBlank((CharSequence)type)) {
            throw new NodeTypeCanNotGuessException(StrUtil.format((CharSequence)"cannot guess the type of node[{}]", (Object[])new Object[]{clazz}));
        }
        NodeTypeEnum nodeTypeEnum = NodeTypeEnum.getEnumByCode(type);
        if (ObjectUtil.isNull((Object)((Object)nodeTypeEnum))) {
            throw new NodeTypeNotSupportException(StrUtil.format((CharSequence)"type [{}] is not support", (Object[])new Object[]{type}));
        }
        LiteFlowNodeBuilder.createNode().setId(id).setName(name).setClazz(clazz).setType(nodeTypeEnum).setScript(script).setFile(file).build();
    }

    public static void buildChain(ChainPropBean chainPropBean, LiteFlowChainBuilder chainBuilder) {
        String condValueStr = chainPropBean.getCondValueStr();
        String group = chainPropBean.getGroup();
        String errorResume = chainPropBean.getErrorResume();
        String any = chainPropBean.getAny();
        String threadExecutorClass = chainPropBean.getThreadExecutorClass();
        ConditionTypeEnum conditionType = chainPropBean.getConditionType();
        if (ObjectUtil.isNull((Object)((Object)conditionType))) {
            throw new NotSupportConditionException("ConditionType is not supported");
        }
        if (StrUtil.isBlank((CharSequence)condValueStr)) {
            throw new EmptyConditionValueException("Condition value cannot be empty");
        }
        if (conditionType.equals((Object)ConditionTypeEnum.TYPE_WHEN)) {
            chainBuilder.setCondition(LiteFlowConditionBuilder.createWhenCondition().setErrorResume(errorResume).setGroup(group).setAny(any).setThreadExecutorClass(threadExecutorClass).setValue(condValueStr).build()).build();
        } else {
            chainBuilder.setCondition(LiteFlowConditionBuilder.createCondition(conditionType).setValue(condValueStr).build()).build();
        }
    }

    public static void parseDocument(List<Document> documentList, Set<String> chainNameSet, Consumer<Element> parseOneChainConsumer) {
        documentList.forEach(document -> {
            List chainList = document.getRootElement().elements("chain");
            chainList.forEach(e -> {
                String chainName = e.attributeValue("name");
                if (!chainNameSet.add(chainName)) {
                    throw new ChainDuplicateException(String.format("[chain name duplicate] chainName=%s", chainName));
                }
                FlowBus.addChain(chainName);
            });
        });
        chainNameSet.clear();
        for (Document document2 : documentList) {
            Element rootElement = document2.getRootElement();
            Element nodesElement = rootElement.element("nodes");
            if (ObjectUtil.isNotNull((Object)nodesElement)) {
                List nodeList = nodesElement.elements("node");
                for (Element e : nodeList) {
                    String id = e.attributeValue("id");
                    String name = e.attributeValue("name");
                    String clazz = e.attributeValue("class");
                    String type = e.attributeValue("type");
                    String script = e.getTextTrim();
                    String file = e.attributeValue("file");
                    NodePropBean nodePropBean = new NodePropBean().setId(id).setName(name).setClazz(clazz).setScript(script).setType(type).setFile(file);
                    ParserHelper.buildNode(nodePropBean);
                }
            }
            List chainList = rootElement.elements("chain");
            chainList.forEach(parseOneChainConsumer);
        }
    }

    public static void parseJsonNode(List<JsonNode> flowJsonObjectList, Set<String> chainNameSet, Consumer<JsonNode> parseOneChainConsumer) {
        flowJsonObjectList.forEach(jsonObject -> {
            Iterator iterator = jsonObject.get("flow").get("chain").elements();
            while (iterator.hasNext()) {
                JsonNode innerJsonObject = (JsonNode)iterator.next();
                String chainName = innerJsonObject.get("name").textValue();
                if (!chainNameSet.add(chainName)) {
                    throw new ChainDuplicateException(String.format("[chain name duplicate] chainName=%s", chainName));
                }
                FlowBus.addChain(innerJsonObject.get("name").textValue());
            }
        });
        chainNameSet.clear();
        for (JsonNode flowJsonNode : flowJsonObjectList) {
            if (flowJsonNode.get("flow").has("nodes")) {
                Iterator nodeIterator = flowJsonNode.get("flow").get("nodes").get("node").elements();
                while (nodeIterator.hasNext()) {
                    JsonNode nodeObject = (JsonNode)nodeIterator.next();
                    String id = nodeObject.get("id").textValue();
                    String name = nodeObject.hasNonNull("name") ? nodeObject.get("name").textValue() : "";
                    String clazz = nodeObject.hasNonNull("class") ? nodeObject.get("class").textValue() : "";
                    String type = nodeObject.hasNonNull("type") ? nodeObject.get("type").textValue() : null;
                    String script = nodeObject.hasNonNull("value") ? nodeObject.get("value").textValue() : "";
                    String file = nodeObject.hasNonNull("file") ? nodeObject.get("file").textValue() : "";
                    NodePropBean nodePropBean = new NodePropBean().setId(id).setName(name).setClazz(clazz).setScript(script).setType(type).setFile(file);
                    ParserHelper.buildNode(nodePropBean);
                }
            }
            Iterator chainIterator = flowJsonNode.get("flow").get("chain").elements();
            while (chainIterator.hasNext()) {
                JsonNode jsonNode = (JsonNode)chainIterator.next();
                parseOneChainConsumer.accept(jsonNode);
            }
        }
    }

    public static void parseOneChain(JsonNode chainNode) {
        String chainName = chainNode.get("name").textValue();
        LiteFlowChainBuilder chainBuilder = LiteFlowChainBuilder.createChain().setChainName(chainName);
        for (JsonNode condNode : chainNode.get("condition")) {
            ConditionTypeEnum conditionType = ConditionTypeEnum.getEnumByCode(condNode.get("type").textValue());
            String condValueStr = condNode.get("value").textValue();
            String errorResume = condNode.hasNonNull("errorResume") ? condNode.get("errorResume").textValue() : "";
            String group = condNode.hasNonNull("group") ? condNode.get("group").textValue() : "";
            String any = condNode.hasNonNull("any") ? condNode.get("any").textValue() : "";
            String threadExecutorClass = condNode.hasNonNull("threadExecutorClass") ? condNode.get("threadExecutorClass").textValue() : "";
            ChainPropBean chainPropBean = new ChainPropBean().setCondValueStr(condValueStr).setGroup(group).setErrorResume(errorResume).setAny(any).setThreadExecutorClass(threadExecutorClass).setConditionType(conditionType);
            ParserHelper.buildChain(chainPropBean, chainBuilder);
        }
    }

    public static void parseOneChain(Element e) {
        String chainName = e.attributeValue("name");
        LiteFlowChainBuilder chainBuilder = LiteFlowChainBuilder.createChain().setChainName(chainName);
        Iterator it = e.elementIterator();
        while (it.hasNext()) {
            Element condE = (Element)it.next();
            ConditionTypeEnum conditionType = ConditionTypeEnum.getEnumByCode(condE.getName());
            String condValueStr = condE.attributeValue("value");
            String errorResume = condE.attributeValue("errorResume");
            String group = condE.attributeValue("group");
            String any = condE.attributeValue("any");
            String threadExecutorClass = condE.attributeValue("threadExecutorClass");
            ChainPropBean chainPropBean = new ChainPropBean().setCondValueStr(condValueStr).setGroup(group).setErrorResume(errorResume).setAny(any).setThreadExecutorClass(threadExecutorClass).setConditionType(conditionType);
            ParserHelper.buildChain(chainPropBean, chainBuilder);
        }
    }

    public static void parseOneChainEl(JsonNode chainNode) {
        String chainName = chainNode.get("name").textValue();
        String el = chainNode.get("value").textValue();
        LiteFlowChainELBuilder chainELBuilder = LiteFlowChainELBuilder.createChain().setChainName(chainName);
        chainELBuilder.setEL(el).build();
    }

    public static void parseOneChainEl(Element e) {
        String chainName = e.attributeValue("name");
        String text = e.getText();
        String el = RegexUtil.removeComments(text);
        LiteFlowChainELBuilder chainELBuilder = LiteFlowChainELBuilder.createChain().setChainName(chainName);
        chainELBuilder.setEL(el).build();
    }

    private static class RegexUtil {
        private static final String REGEX_COMMENT = "/\\*((?!\\*/).|[\\r\\n])*?\\*/|[ \\t]*//.*";

        private RegexUtil() {
        }

        private static String removeComments(String elStr) {
            if (StrUtil.isBlank((CharSequence)elStr)) {
                return elStr;
            }
            String text = Pattern.compile(REGEX_COMMENT).matcher(elStr).replaceAll("").replaceAll(" ", "");
            return StrUtil.removeAllLineBreaks((CharSequence)text);
        }
    }
}

