/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow.parallel;

import com.yomahub.liteflow.flow.element.Executable;
import com.yomahub.liteflow.flow.parallel.WhenFutureObj;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelSupplier
implements Supplier<WhenFutureObj> {
    private static final Logger LOG = LoggerFactory.getLogger(ParallelSupplier.class);
    private final Executable executableItem;
    private final String currChainName;
    private final Integer slotIndex;

    public ParallelSupplier(Executable executableItem, String currChainName, Integer slotIndex) {
        this.executableItem = executableItem;
        this.currChainName = currChainName;
        this.slotIndex = slotIndex;
    }

    @Override
    public WhenFutureObj get() {
        try {
            this.executableItem.setCurrChainName(this.currChainName);
            this.executableItem.execute(this.slotIndex);
            return WhenFutureObj.success(this.executableItem.getExecuteName());
        }
        catch (Exception e) {
            return WhenFutureObj.fail(this.executableItem.getExecuteName(), e);
        }
    }
}

