/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow.element.condition;

import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.enums.ConditionTypeEnum;
import com.yomahub.liteflow.exception.WhenExecuteException;
import com.yomahub.liteflow.flow.element.Executable;
import com.yomahub.liteflow.flow.element.condition.Condition;
import com.yomahub.liteflow.flow.element.condition.FinallyCondition;
import com.yomahub.liteflow.flow.element.condition.PreCondition;
import com.yomahub.liteflow.flow.parallel.CompletableFutureTimeout;
import com.yomahub.liteflow.flow.parallel.ParallelSupplier;
import com.yomahub.liteflow.flow.parallel.WhenFutureObj;
import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.property.LiteflowConfigGetter;
import com.yomahub.liteflow.slot.DataBus;
import com.yomahub.liteflow.slot.Slot;
import com.yomahub.liteflow.thread.ExecutorHelper;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhenCondition
extends Condition {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());

    @Override
    public void execute(Integer slotIndex) throws Exception {
        this.executeAsyncCondition(slotIndex);
    }

    @Override
    public ConditionTypeEnum getConditionType() {
        return ConditionTypeEnum.TYPE_WHEN;
    }

    private void executeAsyncCondition(Integer slotIndex) throws Exception {
        Slot slot = DataBus.getSlot(slotIndex);
        String currChainName = this.getCurrChainName();
        ExecutorService parallelExecutor = ExecutorHelper.loadInstance().buildWhenExecutor(this.getThreadExecutorClass());
        LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
        boolean[] interrupted = new boolean[]{false};
        List<CompletableFuture> completableFutureList = this.getExecutableList().stream().filter(executable -> !(executable instanceof PreCondition) && !(executable instanceof FinallyCondition)).filter(executable -> {
            try {
                return executable.isAccess(slotIndex);
            }
            catch (Exception e) {
                this.LOG.error("there was an error when executing the when component isAccess", (Throwable)e);
                return false;
            }
        }).map(executable -> CompletableFutureTimeout.completeOnTimeout(WhenFutureObj.timeOut(executable.getExecuteName()), CompletableFuture.supplyAsync(new ParallelSupplier((Executable)executable, currChainName, slotIndex), parallelExecutor), liteflowConfig.getWhenMaxWaitSeconds().intValue(), TimeUnit.SECONDS)).collect(Collectors.toList());
        CompletableFuture<Object> resultCompletableFuture = this.isAny() ? CompletableFuture.anyOf(completableFutureList.toArray(new CompletableFuture[0])) : CompletableFuture.allOf(completableFutureList.toArray(new CompletableFuture[0]));
        try {
            resultCompletableFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.LOG.error("there was an error when executing the CompletableFuture", (Throwable)e);
            interrupted[0] = true;
        }
        List allCompletableWhenFutureObjList = completableFutureList.stream().filter(f -> {
            if (f.isDone()) {
                return true;
            }
            f.cancel(true);
            return false;
        }).map(f -> {
            try {
                return (WhenFutureObj)f.get();
            }
            catch (InterruptedException | ExecutionException e) {
                interrupted[0] = true;
                return null;
            }
        }).collect(Collectors.toList());
        List<WhenFutureObj> timeOutWhenFutureObjList = allCompletableWhenFutureObjList.stream().filter(WhenFutureObj::isTimeout).collect(Collectors.toList());
        timeOutWhenFutureObjList.forEach(whenFutureObj -> this.LOG.warn("requestId [{}] executing thread has reached max-wait-seconds, thread canceled.Execute-item: [{}]", (Object)slot.getRequestId(), (Object)whenFutureObj.getExecutorName()));
        if (!this.isErrorResume()) {
            if (interrupted[0]) {
                throw new WhenExecuteException(StrUtil.format((CharSequence)"requestId [{}] when execute interrupted. errorResume [false].", (Object[])new Object[]{slot.getRequestId()}));
            }
            for (WhenFutureObj whenFutureObj2 : allCompletableWhenFutureObjList) {
                if (whenFutureObj2.isSuccess()) continue;
                this.LOG.info(StrUtil.format((CharSequence)"requestId [{}] when-executor[{}] execute failed. errorResume [false].", (Object[])new Object[]{slot.getRequestId(), whenFutureObj2.getExecutorName()}));
                throw whenFutureObj2.getEx();
            }
        } else if (interrupted[0]) {
            this.LOG.warn("requestId [{}] executing when condition timeout , but ignore with errorResume.", (Object)slot.getRequestId());
        }
    }
}

