/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.yomahub.liteflow.builder.LiteFlowChainBuilder;
import com.yomahub.liteflow.builder.LiteFlowConditionBuilder;
import com.yomahub.liteflow.builder.LiteFlowNodeBuilder;
import com.yomahub.liteflow.enums.ConditionTypeEnum;
import com.yomahub.liteflow.enums.NodeTypeEnum;
import com.yomahub.liteflow.exception.EmptyConditionValueException;
import com.yomahub.liteflow.exception.NodeTypeNotSupportException;
import com.yomahub.liteflow.exception.NotSupportConditionException;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.parser.FlowParser;
import com.yomahub.liteflow.spi.holder.ContextCmpInitHolder;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JsonFlowParser
implements FlowParser {
    private final Logger LOG = LoggerFactory.getLogger(JsonFlowParser.class);

    public void parse(String content) throws Exception {
        this.parse(ListUtil.toList((Object[])new String[]{content}));
    }

    @Override
    public void parse(List<String> contentList) throws Exception {
        if (CollectionUtil.isEmpty(contentList)) {
            return;
        }
        ArrayList jsonObjectList = ListUtil.toList((Object[])new JSONObject[0]);
        for (String content : contentList) {
            JSONObject flowJsonObject = JSONObject.parseObject((String)content, (Feature[])new Feature[]{Feature.OrderedField});
            jsonObjectList.add(flowJsonObject);
        }
        this.parseJsonObject(jsonObjectList);
    }

    public void parseJsonObject(List<JSONObject> flowJsonObjectList) throws Exception {
        ContextCmpInitHolder.loadContextCmpInit().initCmp();
        flowJsonObjectList.forEach(jsonObject -> {
            JSONArray chainArray = jsonObject.getJSONObject("flow").getJSONArray("chain");
            chainArray.forEach(o -> {
                JSONObject innerJsonObject = (JSONObject)o;
                FlowBus.addChain(innerJsonObject.getString("name"));
            });
        });
        for (JSONObject flowJsonObject : flowJsonObjectList) {
            if (flowJsonObject.getJSONObject("flow").containsKey((Object)"nodes")) {
                JSONArray nodeArrayList = flowJsonObject.getJSONObject("flow").getJSONObject("nodes").getJSONArray("node");
                for (int i = 0; i < nodeArrayList.size(); ++i) {
                    NodeTypeEnum nodeTypeEnum;
                    JSONObject nodeObject = nodeArrayList.getJSONObject(i);
                    String id = nodeObject.getString("id");
                    String name = nodeObject.getString("name");
                    String clazz = nodeObject.getString("class");
                    String type = nodeObject.getString("type");
                    String script = nodeObject.getString("value");
                    String file = nodeObject.getString("file");
                    if (StrUtil.isBlank((CharSequence)type)) {
                        type = NodeTypeEnum.COMMON.getCode();
                    }
                    if (ObjectUtil.isNull((Object)((Object)(nodeTypeEnum = NodeTypeEnum.getEnumByCode(type))))) {
                        throw new NodeTypeNotSupportException(StrUtil.format((CharSequence)"type [{}] is not support", (Object[])new Object[]{type}));
                    }
                    LiteFlowNodeBuilder.createNode().setId(id).setName(name).setClazz(clazz).setType(nodeTypeEnum).setScript(script).setFile(file).build();
                }
            }
            JSONArray chainArray = flowJsonObject.getJSONObject("flow").getJSONArray("chain");
            chainArray.forEach(o -> {
                JSONObject jsonObject = (JSONObject)o;
                this.parseOneChain(jsonObject);
            });
        }
    }

    private void parseOneChain(JSONObject chainObject) {
        String chainName = chainObject.getString("name");
        LiteFlowChainBuilder chainBuilder = LiteFlowChainBuilder.createChain().setChainName(chainName);
        for (Object o : chainObject.getJSONArray("condition")) {
            JSONObject condObject = (JSONObject)o;
            ConditionTypeEnum conditionType = ConditionTypeEnum.getEnumByCode(condObject.getString("type"));
            String condValueStr = condObject.getString("value");
            String errorResume = condObject.getString("errorResume");
            String group = condObject.getString("group");
            String any = condObject.getString("any");
            String threadExecutorClass = condObject.getString("threadExecutorClass");
            if (ObjectUtil.isNull((Object)((Object)conditionType))) {
                throw new NotSupportConditionException("ConditionType is not supported");
            }
            if (StrUtil.isBlank((CharSequence)condValueStr)) {
                throw new EmptyConditionValueException("Condition value cannot be empty");
            }
            if (conditionType.equals((Object)ConditionTypeEnum.TYPE_WHEN)) {
                chainBuilder.setCondition(LiteFlowConditionBuilder.createWhenCondition().setErrorResume(errorResume).setGroup(group).setAny(any).setThreadExecutorClass(threadExecutorClass).setValue(condValueStr).build()).build();
                continue;
            }
            chainBuilder.setCondition(LiteFlowConditionBuilder.createCondition(conditionType).setValue(condValueStr).build()).build();
        }
    }
}

