/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.core;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import com.google.common.collect.Lists;
import com.yomahub.liteflow.entity.data.DataBus;
import com.yomahub.liteflow.entity.data.DefaultSlot;
import com.yomahub.liteflow.entity.data.LiteflowResponse;
import com.yomahub.liteflow.entity.data.Slot;
import com.yomahub.liteflow.entity.flow.Chain;
import com.yomahub.liteflow.entity.flow.Node;
import com.yomahub.liteflow.enums.FlowParserTypeEnum;
import com.yomahub.liteflow.exception.ChainEndException;
import com.yomahub.liteflow.exception.ChainNotFoundException;
import com.yomahub.liteflow.exception.ConfigErrorException;
import com.yomahub.liteflow.exception.CyclicDependencyException;
import com.yomahub.liteflow.exception.ErrorSupportPathException;
import com.yomahub.liteflow.exception.FlowExecutorNotInitException;
import com.yomahub.liteflow.exception.MultipleParsersException;
import com.yomahub.liteflow.exception.NoAvailableSlotException;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.parser.ClassJsonFlowParser;
import com.yomahub.liteflow.parser.ClassXmlFlowParser;
import com.yomahub.liteflow.parser.ClassYmlFlowParser;
import com.yomahub.liteflow.parser.FlowParser;
import com.yomahub.liteflow.parser.JsonFlowParser;
import com.yomahub.liteflow.parser.LocalJsonFlowParser;
import com.yomahub.liteflow.parser.LocalXmlFlowParser;
import com.yomahub.liteflow.parser.LocalYmlFlowParser;
import com.yomahub.liteflow.parser.XmlFlowParser;
import com.yomahub.liteflow.parser.YmlFlowParser;
import com.yomahub.liteflow.parser.ZookeeperJsonFlowParser;
import com.yomahub.liteflow.parser.ZookeeperXmlFlowParser;
import com.yomahub.liteflow.parser.ZookeeperYmlFlowParser;
import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.property.LiteflowConfigGetter;
import com.yomahub.liteflow.spi.holder.ContextAwareHolder;
import java.util.ArrayList;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(FlowExecutor.class);
    private static final String ZK_CONFIG_REGEX = "[\\w\\d][\\w\\d\\.]+\\:(\\d)+(\\,[\\w\\d][\\w\\d\\.]+\\:(\\d)+)*";
    private static final String LOCAL_XML_CONFIG_REGEX = "^[\\w_\\-\\@\\/\\*]+\\.xml$";
    private static final String LOCAL_JSON_CONFIG_REGEX = "^[\\w_\\-\\@\\/\\*]+\\.json$";
    private static final String LOCAL_YML_CONFIG_REGEX = "^[\\w_\\-\\@\\/\\*]+\\.yml$";
    private static final String FORMATE_XML_CONFIG_REGEX = "xml:.+";
    private static final String FORMATE_JSON_CONFIG_REGEX = "json:.+";
    private static final String FORMATE_YML_CONFIG_REGEX = "yml:.+";
    private static final String PREFIX_FORMATE_CONFIG_REGEX = "xml:|json:|yml:";
    private static final String CLASS_CONFIG_REGEX = "^\\w+(\\.\\w+)*$";
    private LiteflowConfig liteflowConfig;

    public FlowExecutor() {
        DataBus.init();
    }

    public FlowExecutor(LiteflowConfig liteflowConfig) {
        this.liteflowConfig = liteflowConfig;
        LiteflowConfigGetter.setLiteflowConfig(liteflowConfig);
        if (liteflowConfig.isParseOnStart().booleanValue()) {
            this.init();
        }
        DataBus.init();
    }

    public void init() {
        if (ObjectUtil.isNull((Object)this.liteflowConfig)) {
            throw new ConfigErrorException("config error, please check liteflow config property");
        }
        if (StrUtil.isBlank((CharSequence)this.liteflowConfig.getRuleSource())) {
            return;
        }
        ArrayList sourceRulePathList = Lists.newArrayList((Object[])this.liteflowConfig.getRuleSource().split(",|;"));
        FlowParser parser = null;
        HashSet<String> parserNameSet = new HashSet<String>();
        ArrayList<String> rulePathList = new ArrayList<String>();
        for (String path : sourceRulePathList) {
            try {
                FlowParserTypeEnum pattern = this.matchFormatConfig(path);
                if (ObjectUtil.isNotNull((Object)((Object)pattern))) {
                    path = ReUtil.replaceAll((CharSequence)path, (String)PREFIX_FORMATE_CONFIG_REGEX, (String)"");
                    switch (pattern) {
                        case TYPE_XML: {
                            parser = this.matchFormatParser(path, FlowParserTypeEnum.TYPE_XML);
                            parserNameSet.add(parser.getClass().getName());
                            break;
                        }
                        case TYPE_JSON: {
                            parser = this.matchFormatParser(path, FlowParserTypeEnum.TYPE_JSON);
                            parserNameSet.add(parser.getClass().getName());
                            break;
                        }
                        case TYPE_YML: {
                            parser = this.matchFormatParser(path, FlowParserTypeEnum.TYPE_YML);
                            parserNameSet.add(parser.getClass().getName());
                            break;
                        }
                        default: {
                            String errorMsg = StrUtil.format((CharSequence)"can't support the format {}", (Object[])new Object[]{path});
                            throw new ErrorSupportPathException(errorMsg);
                        }
                    }
                }
                rulePathList.add(path);
                if (!this.liteflowConfig.isSupportMultipleType().booleanValue()) continue;
                if (ObjectUtil.isNotNull((Object)parser)) {
                    parser.parseMain(ListUtil.toList((Object[])new String[]{path}));
                    continue;
                }
                throw new ConfigErrorException("parse error, please check liteflow config property");
            }
            catch (CyclicDependencyException e) {
                LOG.error(e.getMessage());
                throw e;
            }
            catch (Exception e) {
                String errorMsg = StrUtil.format((CharSequence)"init flow executor cause error,cannot find the parse for path {}", (Object[])new Object[]{path});
                LOG.error(errorMsg, (Throwable)e);
                throw new FlowExecutorNotInitException(errorMsg);
            }
        }
        if (!this.liteflowConfig.isSupportMultipleType().booleanValue()) {
            if (parserNameSet.size() > 1) {
                String errorMsg = "cannot have multiple different parsers";
                LOG.error(errorMsg);
                throw new MultipleParsersException(errorMsg);
            }
            try {
                if (!ObjectUtil.isNotNull(parser)) {
                    throw new ConfigErrorException("parse error, please check liteflow config property");
                }
                parser.parseMain(rulePathList);
            }
            catch (CyclicDependencyException e) {
                LOG.error(e.getMessage());
                throw e;
            }
            catch (Exception e) {
                String errorMsg = StrUtil.format((CharSequence)"init flow executor cause error,can not parse rule file {}", (Object[])new Object[]{rulePathList});
                LOG.error(errorMsg, (Throwable)e);
                throw new FlowExecutorNotInitException(errorMsg);
            }
        }
    }

    private FlowParser matchFormatParser(String path, FlowParserTypeEnum pattern) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        boolean isLocalFile = this.isLocalConfig(path);
        if (isLocalFile) {
            LOG.info("flow info loaded from local file,path={},format type={}", (Object)path, (Object)pattern.getType());
            switch (pattern) {
                case TYPE_XML: {
                    return new LocalXmlFlowParser();
                }
                case TYPE_JSON: {
                    return new LocalJsonFlowParser();
                }
                case TYPE_YML: {
                    return new LocalYmlFlowParser();
                }
            }
        } else if (this.isClassConfig(path)) {
            LOG.info("flow info loaded from class config,class={},format type={}", (Object)path, (Object)pattern.getType());
            Class<?> c = Class.forName(path);
            switch (pattern) {
                case TYPE_XML: {
                    return (XmlFlowParser)ContextAwareHolder.loadContextAware().registerBean(c);
                }
                case TYPE_JSON: {
                    return (JsonFlowParser)ContextAwareHolder.loadContextAware().registerBean(c);
                }
                case TYPE_YML: {
                    return (YmlFlowParser)ContextAwareHolder.loadContextAware().registerBean(c);
                }
            }
        } else if (this.isZKConfig(path)) {
            LOG.info("flow info loaded from Zookeeper,zkNode={},format type={}", (Object)path, (Object)pattern.getType());
            switch (pattern) {
                case TYPE_XML: {
                    return new ZookeeperXmlFlowParser(this.liteflowConfig.getZkNode());
                }
                case TYPE_JSON: {
                    return new ZookeeperJsonFlowParser(this.liteflowConfig.getZkNode());
                }
                case TYPE_YML: {
                    return new ZookeeperYmlFlowParser(this.liteflowConfig.getZkNode());
                }
            }
        }
        LOG.info("load flow info error, path={}, pattern={}", (Object)path, (Object)pattern.getType());
        return null;
    }

    private boolean isLocalConfig(String path) {
        return ReUtil.isMatch((String)LOCAL_XML_CONFIG_REGEX, (CharSequence)path) || ReUtil.isMatch((String)LOCAL_JSON_CONFIG_REGEX, (CharSequence)path) || ReUtil.isMatch((String)LOCAL_YML_CONFIG_REGEX, (CharSequence)path);
    }

    private boolean isClassConfig(String path) {
        return ReUtil.isMatch((String)CLASS_CONFIG_REGEX, (CharSequence)path);
    }

    private boolean isZKConfig(String path) {
        return ReUtil.isMatch((String)ZK_CONFIG_REGEX, (CharSequence)path);
    }

    private FlowParserTypeEnum matchFormatConfig(String path) {
        if (ReUtil.isMatch((String)LOCAL_XML_CONFIG_REGEX, (CharSequence)path) || ReUtil.isMatch((String)FORMATE_XML_CONFIG_REGEX, (CharSequence)path)) {
            return FlowParserTypeEnum.TYPE_XML;
        }
        if (ReUtil.isMatch((String)LOCAL_JSON_CONFIG_REGEX, (CharSequence)path) || ReUtil.isMatch((String)FORMATE_JSON_CONFIG_REGEX, (CharSequence)path)) {
            return FlowParserTypeEnum.TYPE_JSON;
        }
        if (ReUtil.isMatch((String)LOCAL_YML_CONFIG_REGEX, (CharSequence)path) || ReUtil.isMatch((String)FORMATE_YML_CONFIG_REGEX, (CharSequence)path)) {
            return FlowParserTypeEnum.TYPE_YML;
        }
        if (this.isClassConfig(path)) {
            try {
                Class<?> clazz = Class.forName(path);
                if (ClassXmlFlowParser.class.isAssignableFrom(clazz)) {
                    return FlowParserTypeEnum.TYPE_XML;
                }
                if (ClassJsonFlowParser.class.isAssignableFrom(clazz)) {
                    return FlowParserTypeEnum.TYPE_JSON;
                }
                if (ClassYmlFlowParser.class.isAssignableFrom(clazz)) {
                    return FlowParserTypeEnum.TYPE_YML;
                }
            }
            catch (ClassNotFoundException e) {
                LOG.error(e.getMessage());
            }
        }
        return null;
    }

    public void reloadRule() {
        this.init();
    }

    public <T extends Slot> void invoke(String chainId, Object param, Class<T> slotClazz, Integer slotIndex) throws Exception {
        this.execute(chainId, param, slotClazz, slotIndex, true);
    }

    public <T extends Slot> void invoke(String nodeId, Integer slotIndex) throws Exception {
        Node node = FlowBus.getNode(nodeId);
        node.execute(slotIndex);
    }

    public DefaultSlot execute(String chainId) throws Exception {
        return this.execute(chainId, null, DefaultSlot.class, null, false);
    }

    public DefaultSlot execute(String chainId, Object param) throws Exception {
        return this.execute(chainId, param, DefaultSlot.class, null, false);
    }

    public <T extends Slot> T execute(String chainId, Object param, Class<T> slotClazz) throws Exception {
        return this.execute(chainId, param, slotClazz, null, false);
    }

    public <T extends Slot> T execute(String chainId, Object param, Class<T> slotClazz, Integer slotIndex, boolean isInnerChain) throws Exception {
        T slot = this.doExecute(chainId, param, slotClazz, slotIndex, isInnerChain);
        if (ObjectUtil.isNotNull((Object)slot.getException())) {
            throw slot.getException();
        }
        return slot;
    }

    public LiteflowResponse<DefaultSlot> execute2Resp(String chainId) {
        return this.execute2Resp(chainId, null, DefaultSlot.class);
    }

    public LiteflowResponse<DefaultSlot> execute2Resp(String chainId, Object param) {
        return this.execute2Resp(chainId, param, DefaultSlot.class);
    }

    public <T extends Slot> LiteflowResponse<T> execute2Resp(String chainId, Object param, Class<T> slotClazz) {
        return this.execute2Resp(chainId, param, slotClazz, null, false);
    }

    public <T extends Slot> LiteflowResponse<T> execute2Resp(String chainId, Object param, Class<T> slotClazz, Integer slotIndex, boolean isInnerChain) {
        LiteflowResponse<T> response = new LiteflowResponse<T>();
        T slot = this.doExecute(chainId, param, slotClazz, slotIndex, isInnerChain);
        if (ObjectUtil.isNotNull((Object)slot.getException())) {
            response.setSuccess(false);
            response.setMessage(slot.getException().getMessage());
            response.setCause(slot.getException());
        } else {
            response.setSuccess(true);
        }
        response.setSlot(slot);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private <T extends Slot> T doExecute(String chainId, Object param, Class<T> slotClazz, Integer slotIndex, boolean isInnerChain) {
        Object slot;
        block34: {
            if (FlowBus.needInit()) {
                this.init();
            }
            if (!isInnerChain && ObjectUtil.isNull((Object)slotIndex)) {
                slotIndex = DataBus.offerSlot(slotClazz);
                LOG.info("slot[{}] offered", (Object)slotIndex);
            }
            if (slotIndex == -1) {
                throw new NoAvailableSlotException("there is no available slot");
            }
            slot = DataBus.getSlot(slotIndex);
            if (ObjectUtil.isNull(slot)) {
                throw new NoAvailableSlotException(StrUtil.format((CharSequence)"the slot[{}] is not exist", (Object[])new Object[]{slotIndex}));
            }
            if (StrUtil.isBlank((CharSequence)slot.getRequestId())) {
                slot.generateRequestId();
                LOG.info("requestId[{}] has generated", (Object)slot.getRequestId());
            }
            if (!isInnerChain) {
                if (ObjectUtil.isNotNull((Object)param)) {
                    slot.setRequestData((Object)param);
                }
                slot.setChainName(chainId);
            } else if (ObjectUtil.isNotNull((Object)param)) {
                slot.setChainReqData(chainId, (Object)param);
            }
            Chain chain = null;
            chain = FlowBus.getChain(chainId);
            if (ObjectUtil.isNull((Object)chain)) {
                String errorMsg = StrUtil.format((CharSequence)"[{}]:couldn't find chain with the id[{}]", (Object[])new Object[]{slot.getRequestId(), chainId});
                throw new ChainNotFoundException(errorMsg);
            }
            chain.executePre(slotIndex);
            chain.execute(slotIndex);
            try {
                if (ObjectUtil.isNotNull((Object)chain)) {
                    chain.executeFinally(slotIndex);
                }
            }
            catch (Exception e) {
                String errMsg = StrUtil.format((CharSequence)"[{}]:an exception occurred during the finally Component execution in chain[{}]", (Object[])new Object[]{slot.getRequestId(), chain.getChainName()});
                LOG.error(errMsg, (Throwable)e);
            }
            if (!isInnerChain) {
                slot.printStep();
                DataBus.releaseSlot(slotIndex);
            }
            break block34;
            catch (ChainEndException e) {
                block33: {
                    if (!ObjectUtil.isNotNull((Object)chain)) break block33;
                    String warnMsg = StrUtil.format((CharSequence)"[{}]:chain[{}] execute end on slot[{}]", (Object[])new Object[]{slot.getRequestId(), chain.getChainName(), slotIndex});
                    LOG.warn(warnMsg);
                }
                try {
                    if (ObjectUtil.isNotNull((Object)chain)) {
                        chain.executeFinally(slotIndex);
                    }
                }
                catch (Exception e2) {
                    String errMsg = StrUtil.format((CharSequence)"[{}]:an exception occurred during the finally Component execution in chain[{}]", (Object[])new Object[]{slot.getRequestId(), chain.getChainName()});
                    LOG.error(errMsg, (Throwable)e2);
                }
                if (!isInnerChain) {
                    slot.printStep();
                    DataBus.releaseSlot(slotIndex);
                }
            }
            catch (Exception e2) {
                String errMsg;
                if (ObjectUtil.isNotNull((Object)chain)) {
                    errMsg = StrUtil.format((CharSequence)"[{}]:chain[{}] execute error on slot[{}]", (Object[])new Object[]{slot.getRequestId(), chain.getChainName(), slotIndex});
                    LOG.error(errMsg, (Throwable)e2);
                }
                slot.setException(e2);
                {
                    catch (Throwable throwable) {
                        try {
                            if (ObjectUtil.isNotNull((Object)chain)) {
                                chain.executeFinally(slotIndex);
                            }
                        }
                        catch (Exception e3) {
                            String errMsg2 = StrUtil.format((CharSequence)"[{}]:an exception occurred during the finally Component execution in chain[{}]", (Object[])new Object[]{slot.getRequestId(), chain.getChainName()});
                            LOG.error(errMsg2, (Throwable)e3);
                        }
                        if (!isInnerChain) {
                            slot.printStep();
                            DataBus.releaseSlot(slotIndex);
                        }
                        throw throwable;
                    }
                }
                try {
                    if (ObjectUtil.isNotNull((Object)chain)) {
                        chain.executeFinally(slotIndex);
                    }
                }
                catch (Exception e4) {
                    errMsg = StrUtil.format((CharSequence)"[{}]:an exception occurred during the finally Component execution in chain[{}]", (Object[])new Object[]{slot.getRequestId(), chain.getChainName()});
                    LOG.error(errMsg, (Throwable)e4);
                }
                if (!isInnerChain) {
                    slot.printStep();
                    DataBus.releaseSlot(slotIndex);
                }
            }
        }
        return (T)slot;
    }

    public LiteflowConfig getLiteflowConfig() {
        return this.liteflowConfig;
    }

    public void setLiteflowConfig(LiteflowConfig liteflowConfig) {
        this.liteflowConfig = liteflowConfig;
        LiteflowConfigGetter.setLiteflowConfig(liteflowConfig);
    }
}

