/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.thread.ExecutorCondition;

import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.yomahub.liteflow.enums.ConditionTypeEnum;
import com.yomahub.liteflow.flow.element.Chain;
import com.yomahub.liteflow.flow.element.Condition;
import com.yomahub.liteflow.flow.element.condition.LoopCondition;
import com.yomahub.liteflow.flow.element.condition.WhenCondition;
import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.thread.ExecutorCondition.ExecutorCondition;

public class ExecutorConditionBuilder {
    public static ExecutorCondition buildExecutorCondition(Condition condition, Chain chain, LiteflowConfig liteflowConfig, ConditionTypeEnum type) {
        boolean chainLevel;
        String conditionExecutorClass;
        boolean conditionLevel;
        switch (type) {
            case TYPE_FOR: 
            case TYPE_WHILE: 
            case TYPE_ITERATOR: {
                LoopCondition loopCondition = (LoopCondition)condition;
                conditionLevel = ObjectUtil.isNotEmpty((Object)loopCondition.getThreadPoolExecutorClass());
                conditionExecutorClass = loopCondition.getThreadPoolExecutorClass();
                chainLevel = ObjectUtil.isNotEmpty((Object)chain.getThreadPoolExecutorClass());
                break;
            }
            case TYPE_WHEN: {
                WhenCondition whenCondition = (WhenCondition)condition;
                conditionLevel = BooleanUtil.isTrue((Boolean)liteflowConfig.getWhenThreadPoolIsolate()) || ObjectUtil.isNotEmpty((Object)whenCondition.getThreadExecutorClass());
                conditionExecutorClass = whenCondition.getThreadExecutorClass() == null ? liteflowConfig.getGlobalThreadPoolExecutorClass() : whenCondition.getThreadExecutorClass();
                chainLevel = ObjectUtil.isNotEmpty((Object)chain.getThreadPoolExecutorClass());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported condition type: " + (Object)((Object)type));
            }
        }
        return ExecutorCondition.create(conditionLevel, chainLevel, conditionExecutorClass);
    }
}

