/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.thread;

import cn.hutool.core.util.ReflectUtil;
import com.alibaba.ttl.threadpool.TtlExecutors;
import com.yomahub.liteflow.thread.ExecutorHelper;
import java.lang.reflect.Method;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public interface ExecutorBuilder {
    public ExecutorService buildExecutor();

    default public ExecutorService buildDefaultExecutor(int corePoolSize, int maximumPoolSize, int queueCapacity, final String threadName) {
        ExecutorService executorService;
        if (ExecutorHelper.loadInstance().isEnabledVirtualThreads()) {
            Method method = ReflectUtil.getMethodByName(Executors.class, (String)"newVirtualThreadPerTaskExecutor");
            executorService = TtlExecutors.getTtlExecutorService((ExecutorService)((ExecutorService)ReflectUtil.invokeStatic((Method)method, (Object[])new Object[0])));
        } else {
            executorService = TtlExecutors.getTtlExecutorService((ExecutorService)new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(queueCapacity), new ThreadFactory(){
                private final AtomicLong number = new AtomicLong();

                @Override
                public Thread newThread(Runnable r) {
                    Thread newThread = Executors.defaultThreadFactory().newThread(r);
                    newThread.setName(threadName + this.number.getAndIncrement());
                    newThread.setDaemon(false);
                    return newThread;
                }
            }, new ThreadPoolExecutor.CallerRunsPolicy()));
        }
        return executorService;
    }

    default public ExecutorService buildCommonExecutor(int corePoolSize, int maximumPoolSize, int queueCapacity, final String threadName) {
        return TtlExecutors.getTtlExecutorService((ExecutorService)new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(queueCapacity), new ThreadFactory(){
            private final AtomicLong number = new AtomicLong();

            @Override
            public Thread newThread(Runnable r) {
                Thread newThread = Executors.defaultThreadFactory().newThread(r);
                newThread.setName(threadName + this.number.getAndIncrement());
                newThread.setDaemon(false);
                return newThread;
            }
        }, new ThreadPoolExecutor.CallerRunsPolicy()));
    }
}

