/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.meta;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import com.yomahub.liteflow.core.FlowExecutorHolder;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.flow.element.Chain;
import com.yomahub.liteflow.flow.element.Condition;
import com.yomahub.liteflow.flow.element.Executable;
import com.yomahub.liteflow.flow.element.Node;
import com.yomahub.liteflow.flow.instanceId.NodeInstanceIdManageSpiHolder;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class LiteflowMetaOperator {
    public static Chain getChain(String chainId) {
        return FlowBus.getChain(chainId);
    }

    public static List<Chain> getChainsContainsNodeId(String nodeId) {
        return FlowBus.getChainMap().values().stream().filter(chain -> LiteflowMetaOperator.getNodes(chain.getChainId()).stream().anyMatch(node -> node.getId().equals(nodeId))).collect(Collectors.toList());
    }

    public static void reloadAllChain() {
        FlowExecutorHolder.loadInstance().reloadRule();
    }

    public static void reloadOneChain(String chainId, String el) {
        FlowBus.reloadChain(chainId, el);
    }

    public static void reloadOneChain(String chainId, String el, String routeEl) {
        FlowBus.reloadChain(chainId, el, routeEl);
    }

    public static void removeChain(String chainId) {
        FlowBus.removeChain(chainId);
    }

    public static void removeChain(String ... chainIds) {
        FlowBus.removeChain(chainIds);
    }

    public static List<Node> getNodes(Executable executable) {
        if (executable instanceof Chain) {
            Chain chain = (Chain)executable;
            return chain.getConditionList().stream().flatMap(condition -> LiteflowMetaOperator.getNodes(condition).stream()).collect(Collectors.toList());
        }
        if (executable instanceof Condition) {
            Condition condition2 = (Condition)executable;
            return condition2.getExecutableGroup().entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream()).flatMap(item -> LiteflowMetaOperator.getNodes(item).stream()).collect(Collectors.toList());
        }
        if (executable instanceof Node) {
            return CollectionUtil.toList((Object[])new Node[]{(Node)executable});
        }
        return ListUtil.empty();
    }

    public static List<Node> getNodes(String chainId) {
        return LiteflowMetaOperator.getNodes(LiteflowMetaOperator.getChain(chainId));
    }

    public static List<Node> getNodes(String chainId, String nodeId) {
        return LiteflowMetaOperator.getNodes(chainId).stream().filter(node -> nodeId.equals(node.getId())).collect(Collectors.toList());
    }

    public static Node getNode(String chainId, String nodeInstanceId) {
        return NodeInstanceIdManageSpiHolder.getInstance().getNodeInstanceIdManageSpi().getNodeByIdAndInstanceId(chainId, nodeInstanceId);
    }

    public static Node getNode(String chainId, String nodeId, int index) {
        return NodeInstanceIdManageSpiHolder.getInstance().getNodeInstanceIdManageSpi().getNodeByIdAndIndex(chainId, nodeId, index);
    }

    public static int getNodeIndex(String chainId, String nodeInstanceId) {
        return NodeInstanceIdManageSpiHolder.getInstance().getNodeInstanceIdManageSpi().getNodeLocationById(chainId, nodeInstanceId);
    }

    public static List<String> getNodeInstanceIds(String chainId, String nodeId) {
        return NodeInstanceIdManageSpiHolder.getInstance().getNodeInstanceIdManageSpi().getNodeInstanceIds(chainId, nodeId);
    }

    public static List<Node> getNodesInAllChain(String nodeId) {
        return FlowBus.getChainMap().values().stream().flatMap(chain -> Objects.requireNonNull(LiteflowMetaOperator.getNodes(chain.getChainId(), nodeId)).stream().filter(node -> node.getId().equals(nodeId))).collect(Collectors.toList());
    }

    public static void reloadScript(String nodeId, String script) {
        FlowBus.reloadScript(nodeId, script);
    }
}

