/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow.instanceId;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.FileUtil;
import com.yomahub.liteflow.flow.entity.InstanceInfoDto;
import com.yomahub.liteflow.flow.instanceId.BaseNodeInstanceIdManageSpi;
import com.yomahub.liteflow.util.JsonUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class DefaultNodeInstanceIdManageSpiImpl
extends BaseNodeInstanceIdManageSpi {
    private final String basePath = System.getProperty("user.dir") + File.separator + ".node_instance_id" + File.separator;

    @Override
    public List<String> readInstanceIdFile(String chainId) {
        if (StringUtils.isBlank((String)chainId)) {
            return Collections.emptyList();
        }
        File nodeDir = new File(this.basePath + chainId);
        if (FileUtil.isEmpty((File)nodeDir)) {
            return Collections.emptyList();
        }
        return FileUtil.readLines((String)nodeDir.getPath(), (String)"UTF-8");
    }

    @Override
    public void writeInstanceIdFile(List<InstanceInfoDto> instanceIdList, String elMd5, String chainId) {
        if (StringUtils.isBlank((String)chainId) || CollUtil.isEmpty(instanceIdList)) {
            return;
        }
        File nodeDir = new File(this.basePath + chainId);
        ArrayList<String> writeContent = new ArrayList<String>();
        writeContent.add(elMd5);
        writeContent.add(JsonUtil.toJsonString(instanceIdList));
        FileUtil.writeLines(writeContent, (String)nodeDir.getPath(), (String)"UTF-8");
    }
}

