/*
 * Decompiled with CFR 0.152.
 */
package mobi.oneway.sdk.base;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import java.util.ArrayList;
import java.util.Arrays;
import mobi.oneway.sdk.c.a;
import mobi.oneway.sdk.common.c.c;
import mobi.oneway.sdk.common.c.v;
import mobi.oneway.sdk.common.f.r;
import mobi.oneway.sdk.port.Player;
import mobi.oneway.sdk.port.Unit;
import mobi.oneway.sdk.utils.d;
import mobi.oneway.sdk.views.VideoPlayerView;

public class BaseAdShowActivity
extends Activity {
    public static final String EXTRA_VIEWS = "views";
    public static final String EXTRA_ACTIVITY_ID = "activityId";
    public static final String EXTRA_ORIENTATION = "orientation";
    public static final String EXTRA_SYSTEM_UI_VISIBILITY = "systemUiVisibility";
    public static final String EXTRA_KEY_EVENT_LIST = "keyEvents";
    public static final String EXTRA_KEEP_SCREEN_ON = "keepScreenOn";
    public static final String EXTRA_APP_URL = "app_url";
    public static final String EXTRA_VIDEO_FRAME = "videoFrame";
    public static final String EXTRA_BGCOLOR = "bgColor";
    public static final String EXTRA_FULL_SCREEN = "fullScreen";
    public static final String VIEW_VIDEO_PLAYER = "videoplayer";
    public static final String VIEW_WEBVIEW = "webview";
    protected RelativeLayout rlRoot;
    protected String[] views;
    private int orientation = -1;
    private int systemUiVisibility;
    protected int activityId;
    private ArrayList<Integer> keyEventList;
    boolean keepScreenOn;
    private int[] videoFrame = null;
    private RelativeLayout.LayoutParams rlpVideo;
    private int bgColor = -16777216;
    private boolean videoPlayFinished = false;

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        r.a("AdShowActivity.onCreate.");
        try {
            c c2;
            Player.setState(1);
            Unit.setAdShowActivity(this);
            d.b((View)this.rlRoot);
            this.initData(bundle == null ? this.getIntent().getExtras() : bundle);
            this.createLayout();
            this.setContentView((View)this.rlRoot);
            if (bundle == null) {
                c2 = c.b;
            } else {
                this.keepScreenOn = bundle.getBoolean(EXTRA_KEEP_SCREEN_ON);
                this.setKeepScreenOn(this.keepScreenOn);
                c2 = c.g;
            }
            this.setOrientation(this.orientation);
            this.setSystemUiVisibility(this.systemUiVisibility);
            if (this.views != null && Arrays.asList(this.views).contains(VIEW_VIDEO_PLAYER)) {
                this.createVideoPlayer();
            }
            a.b(v.a, c2, this.activityId);
        }
        catch (Throwable throwable) {
            r.a("Exception on AdShowActivity.", throwable);
            throwable.printStackTrace();
            this.finish();
        }
        r.a("AdShowActivity.onCreateOk");
    }

    protected void initData(Bundle bundle) {
        this.views = bundle.getStringArray(EXTRA_VIEWS);
        this.keyEventList = bundle.getIntegerArrayList(EXTRA_KEY_EVENT_LIST);
        this.orientation = bundle.getInt(EXTRA_ORIENTATION, -1);
        this.systemUiVisibility = bundle.getInt(EXTRA_SYSTEM_UI_VISIBILITY, 0);
        this.activityId = bundle.getInt(EXTRA_ACTIVITY_ID);
        this.setBgColor(bundle.getDoubleArray(EXTRA_BGCOLOR));
        this.setVideoFrame(bundle.getIntArray(EXTRA_VIDEO_FRAME));
    }

    public void setVideoFrame(int[] nArray) {
        if (nArray == null || nArray.length < 4) {
            this.videoFrame = null;
        } else {
            if (nArray[2] > 0) {
                nArray[2] = d.a((Context)this, nArray[2]);
            }
            if (nArray[3] > 0) {
                nArray[3] = d.a((Context)this, nArray[3]);
            }
            this.videoFrame = nArray;
        }
    }

    public void setBgColor(double[] dArray) {
        if (dArray == null) {
            return;
        }
        try {
            int n2 = (int)(dArray[3] * 255.0);
            this.bgColor = Color.argb((int)n2, (int)((int)dArray[0]), (int)((int)dArray[1]), (int)((int)dArray[2]));
        }
        catch (Exception exception) {
            r.a("Error on setBgColor.", exception);
        }
    }

    protected void onStart() {
        super.onStart();
        a.b(v.a, c.a, this.activityId);
    }

    protected void onStop() {
        super.onStop();
        a.b(v.a, c.h, this.activityId);
    }

    protected void onResume() {
        super.onResume();
        this.setViews(this.views);
        a.b(v.a, c.c, this.activityId);
    }

    protected void onPause() {
        super.onPause();
        a a2 = a.c();
        if (a2 == null) {
            r.d("Error on AdShowActivity.onPause: webViewApp is null.");
            return;
        }
        if (this.isFinishing()) {
            d.b((View)a2.a());
            this.destroyVideoPlayer();
        }
        a.b(v.a, c.e, this.isFinishing(), this.activityId);
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putInt(EXTRA_ORIENTATION, this.orientation);
        bundle.putInt(EXTRA_SYSTEM_UI_VISIBILITY, this.systemUiVisibility);
        bundle.putIntegerArrayList(EXTRA_KEY_EVENT_LIST, this.keyEventList);
        bundle.putBoolean(EXTRA_KEEP_SCREEN_ON, this.keepScreenOn);
        bundle.putStringArray(EXTRA_VIEWS, this.views);
        bundle.putInt(EXTRA_ACTIVITY_ID, this.activityId);
    }

    protected void onDestroy() {
        super.onDestroy();
        try {
            Unit.setAdShowActivity(null);
            a.b(v.a, c.d, this.isFinishing(), this.activityId);
            if (Unit.getCurrentAdShowActivityId() == this.activityId) {
                Unit.setAdShowActivity(null);
            }
        }
        catch (Throwable throwable) {
            r.d("error onDestory: " + throwable);
        }
    }

    public boolean onKeyDown(int n2, KeyEvent keyEvent) {
        if (this.keyEventList == null || !this.keyEventList.contains(n2)) {
            return false;
        }
        a.b(v.a, c.f, n2, keyEvent.getEventTime(), keyEvent.getDownTime(), keyEvent.getRepeatCount(), this.activityId);
        return true;
    }

    public void setViews(String[] stringArray) {
        r.a("AdShowActivity.setViews");
        try {
            a a2 = a.c();
            if (a2 == null) {
                r.d("Error on AdShowActivity: webViewApp is null.");
                this.finish();
                return;
            }
            String[] stringArray2 = stringArray == null ? new String[]{} : stringArray;
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray2));
            if (this.views == null) {
                this.views = new String[0];
            }
            ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList(this.views));
            arrayList2.removeAll(arrayList);
            for (String string : arrayList2) {
                if (string.equalsIgnoreCase(VIEW_VIDEO_PLAYER)) {
                    this.destroyVideoPlayer();
                    continue;
                }
                if (!string.equalsIgnoreCase(VIEW_WEBVIEW)) continue;
                d.b((View)a.c().a());
            }
            this.views = stringArray2;
            for (String string : stringArray2) {
                if (string == null) continue;
                if (string.equals(VIEW_VIDEO_PLAYER)) {
                    this.createVideoPlayer();
                    this.setView((View)Player.getVideoPlayerView(), this.rlpVideo);
                    continue;
                }
                if (!string.equals(VIEW_WEBVIEW)) continue;
                this.setView((View)a2.a(), null);
            }
        }
        catch (Throwable throwable) {
            r.a("Exception on setViews.", throwable);
            throwable.printStackTrace();
        }
    }

    protected void setView(View view, RelativeLayout.LayoutParams layoutParams) {
        if (view.getParent() != null && view.getParent().equals(this.rlRoot)) {
            this.rlRoot.bringChildToFront(view);
            return;
        }
        if (layoutParams == null) {
            layoutParams = d.a(-1, -1);
            layoutParams.addRule(13);
            layoutParams.setMargins(0, 0, 0, 0);
        }
        d.b(view);
        view.setPadding(0, 0, 0, 0);
        this.rlRoot.addView(view, (ViewGroup.LayoutParams)layoutParams);
    }

    public String[] getViews() {
        return this.views;
    }

    public void setOrientation(int n2) {
        this.orientation = n2;
        this.setRequestedOrientation(n2);
    }

    public boolean setKeepScreenOn(boolean bl2) {
        this.keepScreenOn = bl2;
        if (this.getWindow() == null) {
            return false;
        }
        if (bl2) {
            this.getWindow().addFlags(128);
        } else {
            this.getWindow().clearFlags(128);
        }
        return true;
    }

    public boolean setSystemUiVisibility(int n2) {
        this.systemUiVisibility = n2;
        if (Build.VERSION.SDK_INT < 11) {
            return false;
        }
        try {
            this.getWindow().getDecorView().setSystemUiVisibility(n2);
            return true;
        }
        catch (Exception exception) {
            r.a("set setSystemUiVisibility error", exception);
            return false;
        }
    }

    public void setKeyEventList(ArrayList<Integer> arrayList) {
        this.keyEventList = arrayList;
    }

    private void createLayout() {
        if (this.rlRoot != null) {
            return;
        }
        this.rlRoot = new RelativeLayout((Context)this);
        this.rlRoot.setLayoutParams((ViewGroup.LayoutParams)d.a(-1, -1));
        this.rlRoot.setBackgroundColor(this.bgColor);
    }

    protected void createVideoPlayer() {
        if (Player.getVideoPlayerView() != null) {
            return;
        }
        VideoPlayerView videoPlayerView = new VideoPlayerView((Context)this);
        Player.setVideoPlayerView(videoPlayerView);
        if (this.videoFrame != null) {
            int n2 = this.videoFrame[0];
            int n3 = this.videoFrame[1];
            int n4 = this.videoFrame[2];
            int n5 = this.videoFrame[3];
            this.rlpVideo = d.a(n4, n5);
            if (n2 == -1) {
                this.rlpVideo.addRule(14);
            } else {
                this.rlpVideo.leftMargin = n2;
            }
            if (n3 == -1) {
                this.rlpVideo.addRule(15);
            } else {
                this.rlpVideo.topMargin = n3;
            }
        }
    }

    protected void destroyVideoPlayer() {
        VideoPlayerView videoPlayerView = Player.getVideoPlayerView();
        if (videoPlayerView == null) {
            return;
        }
        videoPlayerView.a();
        d.b((View)videoPlayerView);
        videoPlayerView.stopPlayback();
        Player.setVideoPlayerView(null);
    }

    public void onGooglePlatStoreClose() {
        a.b(v.a, c.i, this.isFinishing(), this.activityId);
    }

    public boolean isVideoPlayFinished() {
        return this.videoPlayFinished;
    }

    public void setVideoPlayFinished(boolean bl2) {
        this.videoPlayFinished = bl2;
    }
}

