/*
 * Decompiled with CFR 0.152.
 */
package com.uniplay.adsdk.video.flyview;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import com.uniplay.adsdk.video.flyview.TextSprite;
import java.util.ArrayList;

public class FlyView
extends View {
    private boolean is_pause = false;
    private int width;
    private int height;
    private Paint paint;
    private Paint paint_item_bg;
    private boolean end;
    private int frames;
    private int update_time;
    private int rom;
    private float[] speed;
    private int[] rom_y;
    private boolean[] is_add;
    private float max_speed;
    private float min_speed;
    private int max_text_size;
    private int min_text_size;
    private int spacing;
    private Bitmap def_bitmap;
    private int bitmap_size;
    private int bitmap_height;
    private int text_left;
    private int[] text_color = new int[]{-1};
    private ArrayList<TextSprite> list;
    private ArrayList<ArrayList<TextSprite>> list_fly;
    private int which_text = 0;
    private Handler handler = new Handler(){

        public void handleMessage(Message message) {
            FlyView.this.invalidate();
        }
    };

    public FlyView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public void init(Context context, ArrayList<TextSprite> arrayList, int n2, int n3) {
        this.setBackgroundColor(0);
        this.frames = n2;
        this.setFrames(n2);
        this.rom = n3;
        this.min_speed = 1.3f;
        this.max_speed = 2.5f;
        this.max_text_size = (int)TypedValue.applyDimension((int)1, (float)18.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
        this.min_text_size = (int)TypedValue.applyDimension((int)1, (float)18.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
        this.bitmap_size = (int)TypedValue.applyDimension((int)1, (float)35.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
        this.bitmap_height = (int)TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
        this.text_left = (int)TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
        this.list_fly = new ArrayList();
        this.def_bitmap = Bitmap.createScaledBitmap((Bitmap)this.def_bitmap, (int)this.bitmap_size, (int)this.bitmap_size, (boolean)true);
        this.paint = new Paint();
        this.paint.setColor(-1);
        this.paint.setAntiAlias(true);
        this.spacing = (int)TypedValue.applyDimension((int)1, (float)100.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
        this.paint_item_bg = new Paint();
        this.paint_item_bg.setColor(Integer.MIN_VALUE);
        this.paint_item_bg.setAntiAlias(true);
        this.end = true;
        new Logic().start();
    }

    private void init() {
        if (this.list_fly != null) {
            for (int i2 = 0; i2 < this.list_fly.size(); ++i2) {
                this.list_fly.remove(i2);
                --i2;
            }
        }
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int n2) {
        this.spacing = n2;
    }

    public int[] getText_color() {
        return this.text_color;
    }

    public void setText_color(int[] nArray) {
        this.text_color = nArray;
    }

    public float getMax_text_size() {
        return this.max_text_size;
    }

    public void setMax_text_size(int n2) {
        this.max_text_size = n2;
    }

    public float getMin_text_size() {
        return this.min_text_size;
    }

    public void setMin_text_size(int n2) {
        this.min_text_size = n2;
    }

    public float getMax_speed() {
        return this.max_speed;
    }

    public void setMax_speed(float f2) {
        this.max_speed = f2;
        this.setRom(this.rom);
    }

    public float getMin_speed() {
        return this.min_speed;
    }

    public void setMin_speed(float f2) {
        this.min_speed = f2;
        this.setRom(this.rom);
    }

    public int getFrames() {
        return this.frames;
    }

    public void setFrames(int n2) {
        this.frames = n2;
        this.update_time = 1000 / n2;
    }

    public int getRom() {
        return this.rom;
    }

    public void setRom(int n2) {
        this.init();
        this.rom = n2;
        this.rom_y = new int[n2];
        this.speed = new float[n2];
        this.is_add = new boolean[n2];
        int n3 = (int)((float)this.height / (float)n2);
        for (int i2 = 0; i2 < this.rom_y.length; ++i2) {
            float f2;
            this.rom_y[i2] = (int)((double)(n3 * i2) + (double)n3 * 0.7);
            this.speed[i2] = f2 = (float)(Math.random() * (double)(this.max_speed - this.min_speed) + (double)this.min_speed);
            this.is_add[i2] = true;
        }
    }

    public void stop() {
        this.end = false;
        this.def_bitmap.recycle();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        for (int i2 = 0; i2 < this.list_fly.size(); ++i2) {
            ArrayList<TextSprite> arrayList = this.list_fly.get(i2);
            for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                TextSprite textSprite = arrayList.get(i3);
                if (textSprite == null) continue;
                try {
                    Bitmap bitmap = textSprite.getBitmap();
                    if (bitmap == null || bitmap.isRecycled()) {
                        bitmap = this.def_bitmap;
                    }
                    float f2 = this.bitmap_size / 2;
                    RectF rectF = new RectF(textSprite.getX(), textSprite.getY() - (float)this.bitmap_height, textSprite.getX() + (float)textSprite.getLenght() - (float)(this.bitmap_size / 2), textSprite.getY() - (float)this.bitmap_height + (float)this.bitmap_size);
                    canvas.drawRoundRect(rectF, f2, f2, this.paint_item_bg);
                    canvas.drawBitmap(bitmap, textSprite.getX() - 1.0f, textSprite.getY() - (float)this.bitmap_height - 1.0f, this.paint);
                    this.paint.setTextSize((float)textSprite.getText_size());
                    this.paint.setColor(textSprite.getText_color());
                    canvas.drawText(textSprite.getText(), textSprite.getX() + (float)this.text_left, textSprite.getY() - (float)(this.bitmap_height / 4), this.paint);
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
        canvas.restore();
    }

    private Bitmap drawableToBitmap(Drawable drawable2) {
        if (drawable2 == null) {
            return null;
        }
        int n2 = drawable2.getIntrinsicWidth();
        int n3 = drawable2.getIntrinsicHeight();
        Bitmap bitmap = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)(drawable2.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565));
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, n2, n3);
        drawable2.draw(canvas);
        return bitmap;
    }

    private void logic() {
        ArrayList<TextSprite> arrayList;
        int n2;
        for (n2 = 0; n2 < this.is_add.length && this.list.size() > 0; ++n2) {
            if (!this.is_add[n2]) continue;
            arrayList = this.list.get(this.which_text);
            TextSprite textSprite = new TextSprite(((TextSprite)((Object)arrayList)).getImg_url(), ((TextSprite)((Object)arrayList)).getText());
            textSprite.setBitmap(((TextSprite)((Object)arrayList)).getBitmap());
            ++this.which_text;
            if (textSprite == null) continue;
            try {
                ArrayList<Object> arrayList2;
                if (this.which_text >= this.list.size()) {
                    this.which_text = 0;
                }
                textSprite.setX(this.width);
                textSprite.setY(this.rom_y[n2]);
                textSprite.setSpeed_x(this.speed[n2]);
                int n3 = (int)((double)this.min_text_size + Math.random() * (double)(this.max_text_size - this.min_text_size));
                textSprite.setText_size(n3);
                int n4 = (int)(Math.random() * (double)this.text_color.length);
                if (n4 == this.text_color.length) {
                    --n4;
                }
                int n5 = this.text_color[n4];
                textSprite.setText_color(n5);
                Paint paint = new Paint();
                paint.setTextSize((float)n3);
                int n6 = (int)paint.measureText(textSprite.getText()) + this.spacing;
                if (n6 == 0) continue;
                textSprite.setLenght(n6);
                textSprite.setWhich_rom(n2);
                if (n2 >= this.list_fly.size()) {
                    arrayList2 = new ArrayList();
                    this.list_fly.add(arrayList2);
                } else {
                    arrayList2 = this.list_fly.get(n2);
                }
                arrayList2.add(textSprite);
            }
            catch (NullPointerException nullPointerException) {
                continue;
            }
            this.is_add[n2] = false;
        }
        for (n2 = 0; n2 < this.list_fly.size(); ++n2) {
            arrayList = this.list_fly.get(n2);
            if (arrayList.size() == 0) {
                this.is_add[n2] = true;
            }
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                TextSprite textSprite = (TextSprite)arrayList.get(i2);
                if (textSprite == null) {
                    arrayList.remove(i2);
                    --i2;
                    continue;
                }
                try {
                    if (i2 == 0 && textSprite.getX() + (float)textSprite.getLenght() <= 0.0f) {
                        arrayList.remove(i2);
                        --i2;
                        continue;
                    }
                    if (i2 == arrayList.size() - 1 && textSprite.getX() + (float)textSprite.getLenght() >= (float)this.width && textSprite.getX() + (float)textSprite.getLenght() - textSprite.getSpeed_x() < (float)this.width) {
                        this.is_add[n2] = true;
                    }
                    textSprite.setX(textSprite.getX() - textSprite.getSpeed_x());
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
    }

    public void setPause(boolean bl2) {
        this.is_pause = bl2;
    }

    public void addData(TextSprite textSprite) {
        this.list.add(this.which_text + 1, textSprite);
    }

    class Logic
    extends Thread {
        Logic() {
        }

        @Override
        public void run() {
            while (FlyView.this.width == 0) {
                FlyView.this.width = FlyView.this.getWidth();
                FlyView.this.height = FlyView.this.getHeight();
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            FlyView.this.setRom(FlyView.this.rom);
            try {
                Thread.sleep(600L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            while (FlyView.this.end) {
                if (!FlyView.this.is_pause) {
                    FlyView.this.logic();
                    FlyView.this.handler.sendEmptyMessage(0);
                }
                try {
                    Thread.sleep(FlyView.this.update_time);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }
}

