/*
 * Decompiled with CFR 0.152.
 */
package com.uniplay.adsdk.utils;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.net.TrafficStats;
import android.util.Base64;
import com.uniplay.adsdk.utils.MD5FileUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class AppUtils {
    private static long getApkFileSize(String string) {
        File file = new File(string);
        if (file.exists()) {
            return file.length();
        }
        return 0L;
    }

    public static synchronized String drawableToByte(Drawable drawable2) {
        if (drawable2 != null) {
            Bitmap bitmap = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)(drawable2.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565));
            Canvas canvas = new Canvas(bitmap);
            drawable2.setBounds(0, 0, drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight());
            drawable2.draw(canvas);
            int n2 = bitmap.getWidth() * bitmap.getHeight() * 4;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
            bitmap.compress(Bitmap.CompressFormat.PNG, 80, (OutputStream)byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            String string = Base64.encodeToString((byte[])byArray, (int)0);
            return string;
        }
        return null;
    }

    public static HashMap<String, String> getPackageInfo(Context context, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(string, 0);
            int n2 = packageInfo.applicationInfo.uid;
            long l2 = TrafficStats.getUidRxBytes((int)n2);
            long l3 = TrafficStats.getUidTxBytes((int)n2);
            hashMap.put("rxb", String.valueOf(l2));
            hashMap.put("txb", String.valueOf(l3));
            hashMap.put("del", String.valueOf(0));
            String string2 = MD5FileUtil.getFileMD5String(packageInfo.applicationInfo.publicSourceDir);
            hashMap.put("md5", string2);
            hashMap.put("pkg", string);
        }
        catch (Exception exception) {
            hashMap.put("del", String.valueOf(1));
            hashMap.put("rxb", String.valueOf(0));
            hashMap.put("txb", String.valueOf(0));
            hashMap.put("md5", "");
            hashMap.put("pkg", string);
        }
        return hashMap;
    }

    public static boolean isPkgInstalled(Context context, String string) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(string, 1);
            return packageInfo != null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    public static List<ApplicationInfo> getPackagename(Context context) {
        PackageManager packageManager = context.getPackageManager();
        Intent intent = new Intent("android.intent.action.MAIN", null);
        intent.addCategory("android.intent.category.LAUNCHER");
        List list = packageManager.getInstalledApplications(8192);
        Collections.sort(list, new ApplicationInfo.DisplayNameComparator(packageManager));
        return list;
    }

    public static boolean hasPkg(Context context, String string) {
        boolean bl2 = false;
        List<ApplicationInfo> list = AppUtils.getPackagename(context);
        for (ApplicationInfo applicationInfo : list) {
            if (!string.contains(applicationInfo.packageName)) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }
}

