/*
 * Decompiled with CFR 0.152.
 */
package com.uniplay.adsdk.imagecache;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.AsyncTask;
import android.view.Display;
import android.view.WindowManager;
import com.uniplay.adsdk.imagecache.LoaderImpl;
import com.uniplay.adsdk.utils.SDKLog;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class AsyncImageLoader {
    private static AsyncImageLoader instance;
    private HashSet<String> sDownloadingSet;
    private static Map<String, SoftReference<Bitmap>> sImageCache;
    private static Map<String, Long> filesizeCache;
    private LoaderImpl impl;
    private Context mContext;
    private int show_width;
    private int show_height;

    private AsyncImageLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AsyncImageLoader getInstance() {
        if (instance != null) return instance;
        Class<AsyncImageLoader> clazz = AsyncImageLoader.class;
        synchronized (AsyncImageLoader.class) {
            if (instance != null) return instance;
            instance = new AsyncImageLoader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public AsyncImageLoader init(Context context) {
        this.mContext = context;
        this.sDownloadingSet = new HashSet();
        if (null == sImageCache) {
            sImageCache = new HashMap<String, SoftReference<Bitmap>>();
        }
        if (null == filesizeCache) {
            filesizeCache = new HashMap<String, Long>();
        }
        WindowManager windowManager = (WindowManager)this.mContext.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        this.show_width = display.getWidth() / 2;
        this.show_height = display.getHeight() / 2;
        this.impl = new LoaderImpl(sImageCache, filesizeCache);
        String string = context.getCacheDir().getAbsolutePath();
        this.setCachedDir(string);
        return this;
    }

    public Bitmap getBitmapFromMemory(String string) {
        if (this.impl == null) {
            return null;
        }
        return this.impl.getBitmapFromMemory(string, this.show_width, this.show_height);
    }

    public AsyncImageLoader setCache2File(boolean bl2) {
        this.impl.setCache2File(bl2);
        return this;
    }

    public AsyncImageLoader setCachedDir(String string) {
        this.impl.setCachedDir(string);
        return this;
    }

    public void downloadImage(String string, ImageCallback imageCallback) {
        this.downloadImage(string, true, imageCallback);
    }

    private void downloadImage(final String string, boolean bl2, final ImageCallback imageCallback) {
        SDKLog.e("AsyncImageLoader", "lpic downloadImage");
        if (this.sDownloadingSet.contains(string)) {
            SDKLog.e("AsyncImageLoader", "lpic ###\u8be5\u56fe\u7247\u6b63\u5728\u4e0b\u8f7d\uff0c\u4e0d\u80fd\u91cd\u590d\u4e0b\u8f7d\uff01");
            return;
        }
        Bitmap bitmap = this.impl.getBitmapFromMemory(string, this.show_width, this.show_height);
        if (bitmap != null) {
            SDKLog.e("AsyncImageLoader", "lpic \u7f13\u5b58\u6216sd\u5361\u83b7\u53d6\u6587\u4ef6\u6210\u529f");
            if (imageCallback != null) {
                imageCallback.onImageLoaded(bitmap, string);
                this.sDownloadingSet.remove(string);
            }
        } else {
            SDKLog.e("AsyncImageLoader", "lpic \u4ece\u7f51\u7edc\u7aef\u4e0b\u8f7d\u56fe\u7247");
            AsyncTask<String, Void, Bitmap> asyncTask = new AsyncTask<String, Void, Bitmap>(){

                protected Bitmap doInBackground(String ... stringArray) {
                    AsyncImageLoader.this.sDownloadingSet.add(string);
                    SDKLog.e("AsyncImageLoader", "lpic \u7f51\u7edc\u83b7\u53d6\u56fe\u7247\u6210\u529f");
                    return AsyncImageLoader.this.impl.getBitmapFromUrl(stringArray[0], true, AsyncImageLoader.this.show_width, AsyncImageLoader.this.show_height);
                }

                protected void onPostExecute(Bitmap bitmap) {
                    super.onPostExecute((Object)bitmap);
                    if (imageCallback != null) {
                        imageCallback.onImageLoaded(bitmap, string);
                    }
                    AsyncImageLoader.this.sDownloadingSet.remove(string);
                }
            };
            asyncTask.executeOnExecutor((Executor)Executors.newCachedThreadPool(), (Object[])new String[]{string});
        }
    }

    public void preLoadNextImage(String string) {
        this.downloadImage(string, null);
    }

    public static interface ImageCallback {
        public void onImageLoaded(Bitmap var1, String var2);
    }
}

