/*
 * Decompiled with CFR 0.152.
 */
package com.uniplay.adsdk.download;

import android.net.Uri;
import com.uniplay.adsdk.download.DownloadException;
import com.uniplay.adsdk.download.Downloader;
import com.uniplay.adsdk.download.Utils;
import com.uniplay.adsdk.utils.MD5;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

public final class URLDownloader
implements Downloader {
    private static final String ACCPET_ENCODING = "Accept-Encoding";
    private static final String TRANSFER_ENCODING = "Transfer-Encoding";
    private static final String CONTENT_LENGTH = "Content-Length";
    private HttpURLConnection httpURLConnection;
    private final AtomicInteger redirectionCount = new AtomicInteger();

    private URLDownloader() {
    }

    public static URLDownloader create() {
        return new URLDownloader();
    }

    @Override
    public String detectFilename(Uri uri) {
        return MD5.getMD5(uri.toString());
    }

    @Override
    public int start(Uri uri, long l2) {
        this.redirectionCount.set(5);
        this.httpURLConnection = this.innerRequest(uri, l2);
        return this.httpURLConnection.getResponseCode();
    }

    @Override
    public long contentLength() {
        return this.getContentLength(this.httpURLConnection);
    }

    @Override
    public InputStream byteStream() {
        return this.httpURLConnection.getInputStream();
    }

    @Override
    public void close() {
        if (this.httpURLConnection != null) {
            this.httpURLConnection.disconnect();
        }
    }

    @Override
    public Downloader copy() {
        return URLDownloader.create();
    }

    HttpURLConnection innerRequest(Uri uri, long l2) {
        HttpURLConnection httpURLConnection;
        Object object;
        URL uRL = new URL(uri.toString());
        if ("https".equals(uri.getScheme())) {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
            object = Utils.createSSLContext();
            if (object != null) {
                SSLSocketFactory sSLSocketFactory = ((SSLContext)object).getSocketFactory();
                httpsURLConnection.setSSLSocketFactory(sSLSocketFactory);
            }
            httpURLConnection = httpsURLConnection;
        } else {
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
        }
        httpURLConnection.setInstanceFollowRedirects(true);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setRequestProperty(ACCPET_ENCODING, "identity");
        httpURLConnection.setConnectTimeout(20000);
        httpURLConnection.setReadTimeout(25000);
        if (l2 > 0L) {
            httpURLConnection.setRequestProperty("Range", "bytes=" + l2 + "-");
        }
        int n2 = httpURLConnection.getResponseCode();
        switch (n2) {
            case 301: 
            case 302: 
            case 303: 
            case 307: {
                if (this.redirectionCount.decrementAndGet() >= 0) {
                    object = httpURLConnection.getHeaderField("Location");
                    httpURLConnection.disconnect();
                    return this.innerRequest(Uri.parse((String)object), l2);
                }
                throw new DownloadException(n2, "redirects too many times");
            }
        }
        return httpURLConnection;
    }

    int getContentLength(HttpURLConnection httpURLConnection) {
        String string = httpURLConnection.getHeaderField(TRANSFER_ENCODING);
        if (string == null || string.equalsIgnoreCase("chunked")) {
            return httpURLConnection.getHeaderFieldInt(CONTENT_LENGTH, -1);
        }
        return -1;
    }
}

