/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.adapters.applovin;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.View;
import android.widget.FrameLayout;
import com.applovin.adview.f;
import com.applovin.sdk.a;
import com.applovin.sdk.b;
import com.applovin.sdk.c;
import com.applovin.sdk.d;
import com.applovin.sdk.e;
import com.applovin.sdk.g;
import com.applovin.sdk.j;
import com.applovin.sdk.m;
import com.applovin.sdk.n;
import com.applovin.sdk.p;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AdapterUtils;
import com.ironsource.mediationsdk.ISBannerSize;
import com.ironsource.mediationsdk.IntegrationData;
import com.ironsource.mediationsdk.IronSourceBannerLayout;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.sdk.BannerSmashListener;
import com.ironsource.mediationsdk.sdk.InterstitialSmashListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;

class AppLovinAdapter
extends AbstractAdapter {
    private static final String VERSION = "4.3.3";
    private static final String GitHash = "4806f97b1";
    private static final String ZONE_ID = "zoneId";
    private static final String SDK_KEY = "sdkKey";
    private Activity mActivity;
    private n mAppLovinSdk;
    private Boolean mDidInitSdk = false;
    private ConcurrentHashMap<String, ALBannerListener> mZoneIdToAppLovinListener;
    private ConcurrentHashMap<String, BannerSmashListener> mZoneIdToBannerSmashListener;
    private ConcurrentHashMap<String, FrameLayout.LayoutParams> mZoneIdToBannerLayout;
    private ConcurrentHashMap<String, com.applovin.adview.b> mZoneIdToBannerAd;
    private ConcurrentHashMap<String, Boolean> mZoneIdToIsAdReadyStatus;
    private ConcurrentHashMap<String, a> mZoneIdToIsAd;
    private ConcurrentHashMap<String, com.applovin.adview.g> mZoneIdToIsAdDialog;
    private ConcurrentHashMap<String, InterstitialSmashListener> mZoneIdToIsListener;
    private ConcurrentHashMap<String, com.applovin.adview.e> mZoneIdToRvAd;
    private ConcurrentHashMap<String, RewardedVideoSmashListener> mZoneIdToRvListener;
    private Boolean mConsentCollectingUserData = null;

    public static AppLovinAdapter startAdapter(String string) {
        return new AppLovinAdapter(string);
    }

    private AppLovinAdapter(String string) {
        super(string);
        this.mAllBannerSmashes = new CopyOnWriteArrayList();
        this.mZoneIdToAppLovinListener = new ConcurrentHashMap();
        this.mZoneIdToBannerSmashListener = new ConcurrentHashMap();
        this.mZoneIdToBannerLayout = new ConcurrentHashMap();
        this.mZoneIdToBannerAd = new ConcurrentHashMap();
        this.mZoneIdToIsAd = new ConcurrentHashMap();
        this.mZoneIdToIsAdDialog = new ConcurrentHashMap();
        this.mZoneIdToRvAd = new ConcurrentHashMap();
        this.mZoneIdToIsListener = new ConcurrentHashMap();
        this.mZoneIdToRvListener = new ConcurrentHashMap();
        this.mZoneIdToIsAdReadyStatus = new ConcurrentHashMap();
    }

    public static IntegrationData getIntegrationData(Activity activity) {
        IntegrationData integrationData = new IntegrationData("AppLovin", VERSION);
        integrationData.activities = new String[]{"com.applovin.adview.AppLovinInterstitialActivity", "com.applovin.adview.AppLovinConfirmationActivity"};
        return integrationData;
    }

    public static String getAdapterSDKVersion() {
        String string = null;
        try {
            string = "8.0.1";
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public String getVersion() {
        return VERSION;
    }

    public String getCoreSDKVersion() {
        return "8.0.1";
    }

    public void onResume(Activity activity) {
        this.mActivity = activity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setConsent(boolean bl2) {
        AppLovinAdapter appLovinAdapter = this;
        synchronized (appLovinAdapter) {
            if (this.mDidInitSdk.booleanValue()) {
                m.a(bl2, (Context)this.mActivity);
            } else {
                this.mConsentCollectingUserData = bl2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSdk(Activity activity, String string) {
        AppLovinAdapter appLovinAdapter = this;
        synchronized (appLovinAdapter) {
            if (!this.mDidInitSdk.booleanValue()) {
                p p2 = new p();
                boolean bl2 = false;
                try {
                    bl2 = this.isAdaptersDebugEnabled();
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                p2.b(bl2);
                this.mAppLovinSdk = n.a(string, p2, (Context)activity);
                this.mAppLovinSdk.d();
                this.mDidInitSdk = true;
                if (this.mConsentCollectingUserData != null) {
                    this.setConsent(this.mConsentCollectingUserData);
                }
            }
        }
    }

    public void initRewardedVideo(final Activity activity, String string, final String string2, JSONObject jSONObject, final RewardedVideoSmashListener rewardedVideoSmashListener) {
        final String string3 = jSONObject.optString(SDK_KEY);
        if (TextUtils.isEmpty((CharSequence)string3)) {
            if (rewardedVideoSmashListener != null) {
                rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
            }
            return;
        }
        final String string4 = this.getZoneId(jSONObject);
        this.mActivity = activity;
        if (rewardedVideoSmashListener != null) {
            this.mZoneIdToRvListener.put(string4, rewardedVideoSmashListener);
        }
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AppLovinAdapter.this.initSdk(activity, string3);
                com.applovin.adview.e e2 = null;
                e2 = !TextUtils.isEmpty((CharSequence)string4) ? com.applovin.adview.e.a(string4, AppLovinAdapter.this.mAppLovinSdk) : com.applovin.adview.e.a(AppLovinAdapter.this.mAppLovinSdk);
                AppLovinAdapter.this.mZoneIdToRvAd.put(string4, e2);
                e2.a(string2);
                e2.a(new d(){

                    @Override
                    public void adReceived(a a2) {
                        if (rewardedVideoSmashListener != null) {
                            rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(true);
                        }
                    }

                    @Override
                    public void failedToReceiveAd(int n2) {
                        if (rewardedVideoSmashListener != null) {
                            rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
                        }
                    }
                });
            }
        });
    }

    public void fetchRewardedVideo(JSONObject jSONObject) {
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + ": in fetchRewardedVideo", 0);
        final String string = this.getZoneId(jSONObject);
        if (this.mZoneIdToRvAd.containsKey(string)) {
            this.mZoneIdToRvAd.get(string).a(new d(){

                @Override
                public void adReceived(a a2) {
                    if (AppLovinAdapter.this.mZoneIdToRvListener.containsKey(string)) {
                        ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(string)).onRewardedVideoAvailabilityChanged(true);
                    }
                }

                @Override
                public void failedToReceiveAd(int n2) {
                    if (AppLovinAdapter.this.mZoneIdToRvListener.containsKey(string)) {
                        ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(string)).onRewardedVideoAvailabilityChanged(false);
                    }
                }
            });
        }
    }

    public void showRewardedVideo(JSONObject jSONObject, RewardedVideoSmashListener rewardedVideoSmashListener) {
        String string = this.getZoneId(jSONObject);
        if (rewardedVideoSmashListener == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "AppLovin showRewardedVideo error: null listener", 3);
            return;
        }
        if (!this.mZoneIdToRvAd.containsKey(string) || !this.mZoneIdToRvAd.get(string).b()) {
            rewardedVideoSmashListener.onRewardedVideoAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Rewarded Video"));
            rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.getDynamicUserId())) {
            this.mZoneIdToRvAd.get(string).a(this.getDynamicUserId());
        }
        this.mZoneIdToRvAd.get(string).a((Context)this.mActivity, new e(){

            @Override
            public void userRewardVerified(a a2, Map<String, String> map) {
            }

            @Override
            public void userOverQuota(a a2, Map<String, String> map) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "userOverQuota", 1);
            }

            @Override
            public void userRewardRejected(a a2, Map<String, String> map) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "userRewardRejected", 1);
            }

            @Override
            public void validationRequestFailed(a a2, int n2) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "validationRequestFailed " + AppLovinAdapter.this.getErrorString(n2) + "(" + n2 + ")", 1);
            }

            @Override
            public void userDeclinedToViewAd(a a2) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "userDeclinedToViewAd", 1);
                String string = AppLovinAdapter.this.getZoneId(a2);
                if (AppLovinAdapter.this.mZoneIdToRvListener.containsKey(string)) {
                    ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(string)).onRewardedVideoAdClosed();
                }
            }
        }, new j(){

            @Override
            public void videoPlaybackBegan(a a2) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "videoPlaybackBegan", 1);
                String string = AppLovinAdapter.this.getZoneId(a2);
                if (AppLovinAdapter.this.mZoneIdToRvListener.containsKey(string)) {
                    ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(string)).onRewardedVideoAdStarted();
                }
            }

            @Override
            public void videoPlaybackEnded(a a2, double d2, boolean bl2) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "videoPlaybackEnded ; isFullyWatched: " + bl2, 1);
                String string = AppLovinAdapter.this.getZoneId(a2);
                if (AppLovinAdapter.this.mZoneIdToRvListener.containsKey(string)) {
                    ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(string)).onRewardedVideoAdEnded();
                    if (bl2) {
                        ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(string)).onRewardedVideoAdRewarded();
                    }
                }
            }
        }, new c(){

            @Override
            public void adDisplayed(a a2) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "adDisplayed", 1);
                String string = AppLovinAdapter.this.getZoneId(a2);
                if (AppLovinAdapter.this.mZoneIdToRvListener.containsKey(string)) {
                    ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(string)).onRewardedVideoAdOpened();
                }
            }

            @Override
            public void adHidden(a a2) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "adHidden", 1);
                final String string = AppLovinAdapter.this.getZoneId(a2);
                if (AppLovinAdapter.this.mZoneIdToRvListener.containsKey(string)) {
                    ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(string)).onRewardedVideoAvailabilityChanged(false);
                    ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(string)).onRewardedVideoAdClosed();
                }
                if (AppLovinAdapter.this.mZoneIdToRvAd.containsKey(string)) {
                    ((com.applovin.adview.e)AppLovinAdapter.this.mZoneIdToRvAd.get(string)).a(new d(){

                        @Override
                        public void adReceived(a a2) {
                            if (AppLovinAdapter.this.mZoneIdToRvListener.containsKey(string)) {
                                ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(string)).onRewardedVideoAvailabilityChanged(true);
                            }
                        }

                        @Override
                        public void failedToReceiveAd(int n2) {
                            if (AppLovinAdapter.this.mZoneIdToRvListener.containsKey(string)) {
                                ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(string)).onRewardedVideoAvailabilityChanged(false);
                            }
                        }
                    });
                }
            }
        }, new b(){

            @Override
            public void adClicked(a a2) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "adClicked", 1);
                String string = AppLovinAdapter.this.getZoneId(a2);
                if (AppLovinAdapter.this.mZoneIdToRvListener.containsKey(string)) {
                    ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(string)).onRewardedVideoAdClicked();
                }
            }
        });
    }

    public synchronized boolean isRewardedVideoAvailable(JSONObject jSONObject) {
        String string = this.getZoneId(jSONObject);
        return this.mZoneIdToRvAd.containsKey(string) && this.mZoneIdToRvAd.get(string).b();
    }

    public void initInterstitial(Activity activity, String string, String string2, JSONObject jSONObject, InterstitialSmashListener interstitialSmashListener) {
        String string3 = jSONObject.optString(SDK_KEY);
        if (TextUtils.isEmpty((CharSequence)string3)) {
            this.log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " initInterstitial empty sdkKey", 3);
            if (interstitialSmashListener != null) {
                interstitialSmashListener.onInterstitialInitFailed(ErrorBuilder.buildInitFailedError((String)"initInterstitial empty sdkKey", (String)"Interstitial"));
            }
            return;
        }
        final String string4 = this.getZoneId(jSONObject);
        this.mActivity = activity;
        this.initSdk(activity, string3);
        com.applovin.adview.g g2 = f.a(this.mAppLovinSdk, (Context)activity);
        this.mZoneIdToIsAdDialog.put(string4, g2);
        if (interstitialSmashListener != null) {
            this.mZoneIdToIsListener.put(string4, interstitialSmashListener);
        }
        g2.a(new b(){

            @Override
            public void adClicked(a a2) {
                if (AppLovinAdapter.this.mZoneIdToIsListener.containsKey(string4)) {
                    ((InterstitialSmashListener)AppLovinAdapter.this.mZoneIdToIsListener.get(string4)).onInterstitialAdClicked();
                }
            }
        });
        g2.a(new c(){

            @Override
            public void adDisplayed(a a2) {
                if (AppLovinAdapter.this.mZoneIdToIsListener.containsKey(string4)) {
                    ((InterstitialSmashListener)AppLovinAdapter.this.mZoneIdToIsListener.get(string4)).onInterstitialAdOpened();
                    ((InterstitialSmashListener)AppLovinAdapter.this.mZoneIdToIsListener.get(string4)).onInterstitialAdShowSucceeded();
                }
            }

            @Override
            public void adHidden(a a2) {
                if (AppLovinAdapter.this.mZoneIdToIsListener.containsKey(string4)) {
                    ((InterstitialSmashListener)AppLovinAdapter.this.mZoneIdToIsListener.get(string4)).onInterstitialAdClosed();
                }
            }
        });
        if (interstitialSmashListener != null) {
            interstitialSmashListener.onInterstitialInitSuccess();
        }
    }

    public void loadInterstitial(JSONObject jSONObject, final InterstitialSmashListener interstitialSmashListener) {
        final String string = this.getZoneId(jSONObject);
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " loadInterstitial <" + string + ">", 0);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.mAppLovinSdk.b().a(string, new d(){

                @Override
                public void adReceived(a a2) {
                    IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Interstitial adReceived zoneId=" + AppLovinAdapter.this.getZoneId(a2), 1);
                    if (interstitialSmashListener != null) {
                        interstitialSmashListener.onInterstitialAdReady();
                    }
                    AppLovinAdapter.this.mZoneIdToIsAd.put(string, a2);
                    AppLovinAdapter.this.mZoneIdToIsAdReadyStatus.put(string, true);
                }

                @Override
                public void failedToReceiveAd(int n2) {
                    if (interstitialSmashListener != null) {
                        String string2 = AppLovinAdapter.this.getErrorString(n2) + "( " + n2 + " )";
                        interstitialSmashListener.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError((String)string2));
                        AppLovinAdapter.this.mZoneIdToIsAdReadyStatus.put(string, false);
                    }
                }
            });
        } else {
            this.mAppLovinSdk.b().a(g.d, new d(){

                @Override
                public void adReceived(a a2) {
                    IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Interstitial adReceived", 1);
                    if (interstitialSmashListener != null) {
                        interstitialSmashListener.onInterstitialAdReady();
                    }
                    AppLovinAdapter.this.mZoneIdToIsAd.put(string, a2);
                    AppLovinAdapter.this.mZoneIdToIsAdReadyStatus.put(string, true);
                }

                @Override
                public void failedToReceiveAd(int n2) {
                    if (interstitialSmashListener != null) {
                        String string2 = AppLovinAdapter.this.getErrorString(n2) + "( " + n2 + " )";
                        interstitialSmashListener.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError((String)string2));
                        AppLovinAdapter.this.mZoneIdToIsAdReadyStatus.put(string, false);
                    }
                }
            });
        }
    }

    public void showInterstitial(JSONObject jSONObject, InterstitialSmashListener interstitialSmashListener) {
        String string = this.getZoneId(jSONObject);
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " showInterstitial <" + string + ">", 0);
        if (!this.mZoneIdToIsAd.containsKey(string) || !this.mZoneIdToIsAdDialog.containsKey(string)) {
            if (interstitialSmashListener != null) {
                interstitialSmashListener.onInterstitialAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Interstitial"));
            }
            return;
        }
        this.mZoneIdToIsAdDialog.get(string).a(this.mZoneIdToIsAd.get(string));
        this.mZoneIdToIsAdReadyStatus.put(string, false);
    }

    public boolean isInterstitialReady(JSONObject jSONObject) {
        String string = this.getZoneId(jSONObject);
        return this.mZoneIdToIsAdDialog.containsKey(string) && this.mZoneIdToIsAdReadyStatus.containsKey(string) && this.mZoneIdToIsAdReadyStatus.get(string) != false;
    }

    public void initBanners(final Activity activity, String string, String string2, JSONObject jSONObject, final BannerSmashListener bannerSmashListener) {
        if (bannerSmashListener == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " initBanners listener == null", 3);
        }
        if (jSONObject == null || activity == null) {
            bannerSmashListener.onBannerInitFailed(ErrorBuilder.buildInitFailedError((String)"null parameters", (String)"Banner"));
            return;
        }
        final String string3 = jSONObject.optString(SDK_KEY);
        if (TextUtils.isEmpty((CharSequence)string3)) {
            bannerSmashListener.onBannerInitFailed(ErrorBuilder.buildInitFailedError((String)"Missing params", (String)"Banner"));
            return;
        }
        this.mActivity = activity;
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AppLovinAdapter.this.initSdk(activity, string3);
                bannerSmashListener.onBannerInitSuccess();
            }
        });
    }

    public void loadBanner(final IronSourceBannerLayout ironSourceBannerLayout, JSONObject jSONObject, final BannerSmashListener bannerSmashListener) {
        if (bannerSmashListener == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " loadBanner listener == null", 3);
            return;
        }
        if (ironSourceBannerLayout == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " loadBanner banner == null", 3);
            return;
        }
        final g g2 = this.calculateBannerSize(ironSourceBannerLayout.getSize(), AdapterUtils.isLargeScreen((Activity)ironSourceBannerLayout.getActivity()));
        if (g2 == null) {
            bannerSmashListener.onBannerAdLoadFailed(ErrorBuilder.unsupportedBannerSize((String)this.getProviderName()));
            return;
        }
        final String string = this.getZoneId(jSONObject);
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " loadBanner: " + this.getProviderName() + ", zoneID <" + string + ">", 1);
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    com.applovin.adview.b b2;
                    FrameLayout.LayoutParams layoutParams;
                    if (TextUtils.isEmpty((CharSequence)string)) {
                        layoutParams = AppLovinAdapter.this.calcLayoutParams(ironSourceBannerLayout.getSize(), g2, ironSourceBannerLayout.getActivity());
                        b2 = new com.applovin.adview.b(AppLovinAdapter.this.mAppLovinSdk, g2, (Context)ironSourceBannerLayout.getActivity());
                    } else {
                        layoutParams = AppLovinAdapter.this.calcLayoutParams(ISBannerSize.BANNER, g.a, ironSourceBannerLayout.getActivity());
                        b2 = new com.applovin.adview.b(AppLovinAdapter.this.mAppLovinSdk, g.a, (Context)ironSourceBannerLayout.getActivity());
                    }
                    ALBannerListener aLBannerListener = new ALBannerListener(string);
                    b2.setAdLoadListener(aLBannerListener);
                    b2.setAdClickListener(aLBannerListener);
                    b2.setAdDisplayListener(aLBannerListener);
                    b2.setAdViewEventListener(aLBannerListener);
                    AppLovinAdapter.this.mZoneIdToBannerSmashListener.put(string, bannerSmashListener);
                    AppLovinAdapter.this.mZoneIdToBannerAd.put(string, b2);
                    AppLovinAdapter.this.mZoneIdToBannerLayout.put(string, layoutParams);
                    AppLovinAdapter.this.mZoneIdToAppLovinListener.put(string, aLBannerListener);
                    if (TextUtils.isEmpty((CharSequence)string)) {
                        b2.a();
                    } else {
                        AppLovinAdapter.this.mAppLovinSdk.b().a(string, (d)aLBannerListener);
                    }
                }
                catch (Exception exception) {
                    IronSourceError ironSourceError = ErrorBuilder.buildLoadFailedError((String)(AppLovinAdapter.this.getProviderName() + " loadBanner exception " + exception.getMessage()));
                    bannerSmashListener.onBannerAdLoadFailed(ironSourceError);
                }
            }
        });
    }

    private g calculateBannerSize(ISBannerSize iSBannerSize, boolean bl2) {
        switch (iSBannerSize.getDescription()) {
            case "BANNER": 
            case "LARGE": {
                return g.a;
            }
            case "RECTANGLE": {
                return g.b;
            }
            case "SMART": {
                return bl2 ? g.c : g.a;
            }
            case "CUSTOM": {
                if (iSBannerSize.getHeight() < 40 || iSBannerSize.getHeight() > 60) break;
                return g.a;
            }
        }
        return null;
    }

    private FrameLayout.LayoutParams calcLayoutParams(ISBannerSize iSBannerSize, g g2, Activity activity) {
        int n2 = 320;
        if (iSBannerSize.getDescription().equals("RECTANGLE")) {
            n2 = 300;
        } else if (iSBannerSize.getDescription().equals("SMART") && AdapterUtils.isLargeScreen((Activity)activity)) {
            n2 = 728;
        }
        int n3 = AdapterUtils.dpToPixels((Activity)activity, (int)n2);
        int n4 = AdapterUtils.dpToPixels((Activity)activity, (int)g2.b());
        return new FrameLayout.LayoutParams(n3, n4, 17);
    }

    public void destroyBanner(JSONObject jSONObject) {
        String string = this.getZoneId(jSONObject);
        com.applovin.adview.b b2 = this.mZoneIdToBannerAd.get(string);
        if (b2 != null) {
            b2.b();
        }
        if (this.mZoneIdToBannerAd != null) {
            this.mZoneIdToBannerAd.remove(string);
        }
    }

    public void reloadBanner(JSONObject jSONObject) {
        final String string = this.getZoneId(jSONObject);
        final com.applovin.adview.b b2 = this.mZoneIdToBannerAd.get(string);
        final ALBannerListener aLBannerListener = this.mZoneIdToAppLovinListener.get(string);
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + "Banner reloadBanner: <" + string + ">", 1);
        if (b2 == null || aLBannerListener == null) {
            this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + ":reloadBanner() failed, null parameters", 2);
            return;
        }
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                if (TextUtils.isEmpty((CharSequence)string)) {
                    b2.a();
                } else {
                    AppLovinAdapter.this.mAppLovinSdk.b().a(string, (d)aLBannerListener);
                }
            }
        });
    }

    private String getErrorString(int n2) {
        switch (n2) {
            case -102: {
                return "Ad fetch timeout";
            }
            case -300: {
                return "No ad pre-loaded";
            }
            case -500: {
                return "Server timeout";
            }
            case -400: {
                return "Unknown server error";
            }
            case -600: {
                return "User closed video before reward";
            }
            case 204: {
                return "No fill";
            }
            case -103: {
                return "No network available";
            }
            case -6: {
                return "Unable to render ad";
            }
            case -1: {
                return "Unspecified error";
            }
        }
        return "Unknown error";
    }

    private String getZoneId(JSONObject jSONObject) {
        return !TextUtils.isEmpty((CharSequence)jSONObject.optString(ZONE_ID)) ? jSONObject.optString(ZONE_ID) : "";
    }

    private String getZoneId(a a2) {
        return a2.y() != null ? a2.y() : "";
    }

    private class ALBannerListener
    implements com.applovin.adview.d,
    b,
    c,
    d {
        private String mZoneId;

        ALBannerListener(String string) {
            this.mZoneId = string;
        }

        @Override
        public void adClicked(a a2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, AppLovinAdapter.this.getProviderName() + " Banner adClicked:  <" + this.mZoneId + ">", 1);
            BannerSmashListener bannerSmashListener = (BannerSmashListener)AppLovinAdapter.this.mZoneIdToBannerSmashListener.get(this.mZoneId);
            if (bannerSmashListener != null) {
                bannerSmashListener.onBannerAdClicked();
            }
        }

        @Override
        public void adDisplayed(a a2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, AppLovinAdapter.this.getProviderName() + " Banner adDisplayed: <" + this.mZoneId + ">", 1);
        }

        @Override
        public void adHidden(a a2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, AppLovinAdapter.this.getProviderName() + " Banner adHidden: <" + this.mZoneId + ">", 1);
        }

        @Override
        public void adReceived(final a a2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, AppLovinAdapter.this.getProviderName() + " Banner adReceived: <" + this.mZoneId + ">", 1);
            final com.applovin.adview.b b2 = (com.applovin.adview.b)((Object)AppLovinAdapter.this.mZoneIdToBannerAd.get(this.mZoneId));
            final FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)AppLovinAdapter.this.mZoneIdToBannerLayout.get(this.mZoneId);
            final BannerSmashListener bannerSmashListener = (BannerSmashListener)AppLovinAdapter.this.mZoneIdToBannerSmashListener.get(this.mZoneId);
            if (b2 != null && bannerSmashListener != null && layoutParams != null) {
                Handler handler = new Handler(Looper.getMainLooper());
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        b2.a(a2);
                        bannerSmashListener.onBannerAdLoaded((View)b2, layoutParams);
                    }
                });
            } else {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, AppLovinAdapter.this.getProviderName() + " adReceived: null parameter", 3);
            }
        }

        @Override
        public void failedToReceiveAd(int n2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, AppLovinAdapter.this.getProviderName() + " Banner failedToReceiveAd", 1);
            BannerSmashListener bannerSmashListener = (BannerSmashListener)AppLovinAdapter.this.mZoneIdToBannerSmashListener.get(this.mZoneId);
            if (bannerSmashListener != null) {
                String string = AppLovinAdapter.this.getErrorString(n2) + "(" + n2 + ")";
                IronSourceError ironSourceError = ErrorBuilder.buildLoadFailedError((String)string);
                bannerSmashListener.onBannerAdLoadFailed(ironSourceError);
            }
        }

        @Override
        public void adOpenedFullscreen(a a2, com.applovin.adview.b b2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, AppLovinAdapter.this.getProviderName() + " Banner adOpenedFullscreen", 1);
        }

        @Override
        public void adClosedFullscreen(a a2, com.applovin.adview.b b2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, AppLovinAdapter.this.getProviderName() + " Banner adClosedFullscreen", 1);
        }

        @Override
        public void adLeftApplication(a a2, com.applovin.adview.b b2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, AppLovinAdapter.this.getProviderName() + " adLeftApplication:  <" + this.mZoneId + ">", 1);
            BannerSmashListener bannerSmashListener = (BannerSmashListener)AppLovinAdapter.this.mZoneIdToBannerSmashListener.get(this.mZoneId);
            if (bannerSmashListener != null) {
                bannerSmashListener.onBannerAdLeftApplication();
            }
        }

        public void adFailedToDisplay(a a2, com.applovin.adview.b b2, com.applovin.adview.c c2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, AppLovinAdapter.this.getProviderName() + " Banner adFailedToDisplay", 1);
        }
    }
}

