/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.adapters.admob;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.View;
import android.widget.FrameLayout;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.InterstitialAd;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.reward.RewardItem;
import com.google.android.gms.ads.reward.RewardedVideoAd;
import com.google.android.gms.ads.reward.RewardedVideoAdListener;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AdapterUtils;
import com.ironsource.mediationsdk.ISBannerSize;
import com.ironsource.mediationsdk.IntegrationData;
import com.ironsource.mediationsdk.IronSourceBannerLayout;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.sdk.BannerSmashListener;
import com.ironsource.mediationsdk.sdk.InterstitialSmashListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;

public class AdMobAdapter
extends AbstractAdapter {
    private static final String VERSION = "4.3.0";
    private static final String CORE_SDK_VERSION = "15.0.0";
    private final String IRONSOURCE_REQUEST_AGENT = "ironSource";
    private int mGender;
    private int mAge = -1;
    private ConcurrentHashMap<String, InterstitialAd> mAdIdToIsAd;
    private ConcurrentHashMap<String, Boolean> mInterstitialAdsAvailability;
    private RewardedVideoAd mRewardedVideoAd;
    private boolean mIsRewardedVideoReady = false;
    private Boolean mDidInitSdk = false;
    private final String AD_UNIT_ID = "adUnitId";
    private final String APP_ID = "appId";
    private ConcurrentHashMap<String, AdView> mAdIdToBannerAd;
    private Boolean mConsent = null;
    private RewardedVideoAdListener rewardedVideoAdListener = new RewardedVideoAdListener(){

        public void onRewardedVideoAdLoaded() {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onRewardedVideoAdLoaded", 1);
            AdMobAdapter.this.mIsRewardedVideoReady = true;
            for (RewardedVideoSmashListener rewardedVideoSmashListener : AdMobAdapter.this.mAllRewardedVideoSmashes) {
                if (rewardedVideoSmashListener == null) continue;
                rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(true);
            }
        }

        public void onRewardedVideoAdOpened() {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onRewardedVideoAdOpened", 1);
            AdMobAdapter.this.mIsRewardedVideoReady = false;
            if (AdMobAdapter.this.mActiveRewardedVideoSmash != null) {
                AdMobAdapter.this.mActiveRewardedVideoSmash.onRewardedVideoAdOpened();
            }
            for (RewardedVideoSmashListener rewardedVideoSmashListener : AdMobAdapter.this.mAllRewardedVideoSmashes) {
                if (rewardedVideoSmashListener == null) continue;
                rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
            }
        }

        public void onRewardedVideoStarted() {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onRewardedVideoStarted", 1);
            if (AdMobAdapter.this.mActiveRewardedVideoSmash != null) {
                AdMobAdapter.this.mActiveRewardedVideoSmash.onRewardedVideoAdStarted();
            }
        }

        public void onRewardedVideoCompleted() {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onRewardedVideoCompleted", 1);
            if (AdMobAdapter.this.mActiveRewardedVideoSmash != null) {
                AdMobAdapter.this.mActiveRewardedVideoSmash.onRewardedVideoAdEnded();
            }
        }

        public void onRewardedVideoAdClosed() {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onRewardedVideoAdClosed", 1);
            if (AdMobAdapter.this.mActiveRewardedVideoSmash != null) {
                AdMobAdapter.this.mActiveRewardedVideoSmash.onRewardedVideoAdClosed();
            }
        }

        public void onRewarded(RewardItem rewardItem) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onRewarded", 1);
            if (AdMobAdapter.this.mActiveRewardedVideoSmash != null) {
                AdMobAdapter.this.mActiveRewardedVideoSmash.onRewardedVideoAdRewarded();
            }
        }

        public void onRewardedVideoAdLeftApplication() {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onRewardedVideoAdLeftApplication", 1);
            if (AdMobAdapter.this.mActiveRewardedVideoSmash != null) {
                AdMobAdapter.this.mActiveRewardedVideoSmash.onRewardedVideoAdClicked();
            }
        }

        public void onRewardedVideoAdFailedToLoad(int n2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onRewardedVideoAdFailedToLoad", 1);
            AdMobAdapter.this.mIsRewardedVideoReady = false;
            for (RewardedVideoSmashListener rewardedVideoSmashListener : AdMobAdapter.this.mAllRewardedVideoSmashes) {
                if (rewardedVideoSmashListener == null) continue;
                rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
            }
        }
    };

    public static AdMobAdapter startAdapter(String string) {
        return new AdMobAdapter(string);
    }

    private AdMobAdapter(String string) {
        super(string);
        this.mAllBannerSmashes = new CopyOnWriteArrayList();
        this.mAdIdToIsAd = new ConcurrentHashMap();
        this.mInterstitialAdsAvailability = new ConcurrentHashMap();
        this.mAdIdToBannerAd = new ConcurrentHashMap();
    }

    public static IntegrationData getIntegrationData(Activity activity) {
        IntegrationData integrationData = new IntegrationData("AdMob", VERSION);
        integrationData.activities = new String[]{"com.google.android.gms.ads.AdActivity"};
        return integrationData;
    }

    public String getVersion() {
        return VERSION;
    }

    public String getCoreSDKVersion() {
        return CORE_SDK_VERSION;
    }

    public void onResume(final Activity activity) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                if (AdMobAdapter.this.mRewardedVideoAd != null) {
                    AdMobAdapter.this.mRewardedVideoAd.resume((Context)activity);
                }
            }
        });
    }

    public void onPause(final Activity activity) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                if (AdMobAdapter.this.mRewardedVideoAd != null) {
                    AdMobAdapter.this.mRewardedVideoAd.pause((Context)activity);
                }
            }
        });
    }

    public void setAge(int n2) {
        this.mAge = n2;
    }

    public void setGender(String string) {
        switch (string) {
            case "female": {
                this.mGender = 2;
                break;
            }
            case "male": {
                this.mGender = 1;
                break;
            }
            default: {
                this.mGender = 0;
            }
        }
    }

    private synchronized void initSDK(Activity activity, String string) {
        if (!this.mDidInitSdk.booleanValue()) {
            this.mDidInitSdk = true;
            if (TextUtils.isEmpty((CharSequence)string)) {
                MobileAds.initialize((Context)activity.getApplicationContext());
            } else {
                MobileAds.initialize((Context)activity.getApplicationContext(), (String)string);
            }
        }
    }

    public void initRewardedVideo(final Activity activity, String string, String string2, final JSONObject jSONObject, RewardedVideoSmashListener rewardedVideoSmashListener) {
        if (rewardedVideoSmashListener == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Admob RV init failed: RewardedVideoSmashListener is empty", 2);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)jSONObject.optString("appId"))) {
            rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
            return;
        }
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                AdMobAdapter.this.initSDK(activity, jSONObject.optString("appId"));
                AdMobAdapter.this.mRewardedVideoAd = MobileAds.getRewardedVideoAdInstance((Context)activity);
                AdMobAdapter.this.mRewardedVideoAd.setRewardedVideoAdListener(AdMobAdapter.this.rewardedVideoAdListener);
                AdMobAdapter.this.loadRewardedVideoAd(jSONObject);
            }
        });
    }

    public void fetchRewardedVideo(JSONObject jSONObject) {
        this.loadRewardedVideoAd(jSONObject);
    }

    private void loadRewardedVideoAd(final JSONObject jSONObject) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                String string = jSONObject.optString("adUnitId");
                AdRequest adRequest = AdMobAdapter.this.createAdRequest();
                if (AdMobAdapter.this.mRewardedVideoAd != null) {
                    AdMobAdapter.this.mRewardedVideoAd.loadAd(string, adRequest);
                }
            }
        });
    }

    public boolean isRewardedVideoAvailable(JSONObject jSONObject) {
        return this.mRewardedVideoAd != null && this.mIsRewardedVideoReady;
    }

    public void showRewardedVideo(JSONObject jSONObject, RewardedVideoSmashListener rewardedVideoSmashListener) {
        this.mActiveRewardedVideoSmash = rewardedVideoSmashListener;
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                if (AdMobAdapter.this.mRewardedVideoAd.isLoaded()) {
                    AdMobAdapter.this.mRewardedVideoAd.show();
                } else {
                    if (AdMobAdapter.this.mActiveRewardedVideoSmash != null) {
                        AdMobAdapter.this.mActiveRewardedVideoSmash.onRewardedVideoAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Rewarded Video"));
                    }
                    for (RewardedVideoSmashListener rewardedVideoSmashListener : AdMobAdapter.this.mAllRewardedVideoSmashes) {
                        if (rewardedVideoSmashListener == null) continue;
                        rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
                    }
                }
            }
        });
    }

    public void initInterstitial(final Activity activity, String string, String string2, final JSONObject jSONObject, final InterstitialSmashListener interstitialSmashListener) {
        if (interstitialSmashListener == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Admob interstitial init failed: InterstitialSmashListener is empty", 2);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)jSONObject.optString("appId"))) {
            interstitialSmashListener.onInterstitialInitFailed(ErrorBuilder.buildInitFailedError((String)"Missing params: 'appId' ", (String)"Interstitial"));
            return;
        }
        final String string3 = jSONObject.optString("adUnitId");
        if (TextUtils.isEmpty((CharSequence)string3)) {
            interstitialSmashListener.onInterstitialInitFailed(ErrorBuilder.buildInitFailedError((String)"Missing params: 'adUnitId' ", (String)"Interstitial"));
            return;
        }
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                AdMobAdapter.this.initSDK(activity, jSONObject.optString("appId"));
                InterstitialAd interstitialAd = new InterstitialAd((Context)activity);
                interstitialAd.setAdUnitId(string3);
                AdMobAdapter.this.mAdIdToIsAd.put(string3, interstitialAd);
                interstitialAd.setAdListener(AdMobAdapter.this.createInterstitialAdListener(jSONObject, string3));
                AdMobAdapter.this.mInterstitialPlacementToListenerMap.put(string3, interstitialSmashListener);
                interstitialSmashListener.onInterstitialInitSuccess();
            }
        });
    }

    private AdListener createInterstitialAdListener(final JSONObject jSONObject, final String string) {
        return new AdListener(){

            public void onAdClosed() {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onAdClosed " + string, 1);
                if (AdMobAdapter.this.mInterstitialPlacementToListenerMap.containsKey(string)) {
                    ((InterstitialSmashListener)AdMobAdapter.this.mInterstitialPlacementToListenerMap.get(string)).onInterstitialAdClosed();
                }
                AdMobAdapter.this.setInterstitialAdAvailability(jSONObject);
            }

            public void onAdFailedToLoad(int n2) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onAdFailedToLoad " + string, 1);
                if (AdMobAdapter.this.mInterstitialPlacementToListenerMap.containsKey(string)) {
                    String string2 = AdMobAdapter.this.getErrorString(n2) + "( " + n2 + " )";
                    ((InterstitialSmashListener)AdMobAdapter.this.mInterstitialPlacementToListenerMap.get(string)).onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError((String)string2));
                }
                AdMobAdapter.this.setInterstitialAdAvailability(jSONObject);
            }

            public void onAdLeftApplication() {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onAdLeftApplication " + string, 1);
                if (AdMobAdapter.this.mInterstitialPlacementToListenerMap.containsKey(string)) {
                    ((InterstitialSmashListener)AdMobAdapter.this.mInterstitialPlacementToListenerMap.get(string)).onInterstitialAdClicked();
                }
            }

            public void onAdOpened() {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onAdOpened " + string, 1);
                if (AdMobAdapter.this.mInterstitialPlacementToListenerMap.containsKey(string)) {
                    ((InterstitialSmashListener)AdMobAdapter.this.mInterstitialPlacementToListenerMap.get(string)).onInterstitialAdOpened();
                    ((InterstitialSmashListener)AdMobAdapter.this.mInterstitialPlacementToListenerMap.get(string)).onInterstitialAdShowSucceeded();
                }
            }

            public void onAdLoaded() {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onAdLoaded " + string, 1);
                if (AdMobAdapter.this.mInterstitialPlacementToListenerMap.containsKey(string)) {
                    ((InterstitialSmashListener)AdMobAdapter.this.mInterstitialPlacementToListenerMap.get(string)).onInterstitialAdReady();
                }
                AdMobAdapter.this.setInterstitialAdAvailability(jSONObject);
            }
        };
    }

    public void loadInterstitial(final JSONObject jSONObject, final InterstitialSmashListener interstitialSmashListener) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                InterstitialAd interstitialAd = AdMobAdapter.this.getInterstitialAd(jSONObject);
                if (interstitialAd == null) {
                    if (interstitialSmashListener != null) {
                        interstitialSmashListener.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError((String)"invalid adUnitId"));
                    }
                    return;
                }
                if (interstitialAd.isLoaded()) {
                    String string = jSONObject.optString("adUnitId");
                    if (AdMobAdapter.this.mInterstitialPlacementToListenerMap.containsKey(string)) {
                        ((InterstitialSmashListener)AdMobAdapter.this.mInterstitialPlacementToListenerMap.get(string)).onInterstitialAdReady();
                    }
                } else if (!interstitialAd.isLoading()) {
                    interstitialAd.loadAd(AdMobAdapter.this.createAdRequest());
                }
            }
        });
    }

    public void showInterstitial(final JSONObject jSONObject, final InterstitialSmashListener interstitialSmashListener) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                InterstitialAd interstitialAd = AdMobAdapter.this.getInterstitialAd(jSONObject);
                if (interstitialAd == null || !interstitialAd.isLoaded()) {
                    if (interstitialSmashListener != null) {
                        interstitialSmashListener.onInterstitialAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Interstitial"));
                    }
                    return;
                }
                interstitialAd.show();
            }
        });
    }

    public final boolean isInterstitialReady(JSONObject jSONObject) {
        String string = jSONObject.optString("adUnitId");
        if (this.mInterstitialAdsAvailability.get(string) != null) {
            return this.mInterstitialAdsAvailability.get(string);
        }
        return false;
    }

    public void initBanners(final Activity activity, String string, String string2, final JSONObject jSONObject, final BannerSmashListener bannerSmashListener) {
        if (bannerSmashListener == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Admob banner init failed: BannerSmashListener is empty", 2);
            return;
        }
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                AdMobAdapter.this.initSDK(activity, jSONObject.optString("appId"));
                bannerSmashListener.onBannerInitSuccess();
            }
        });
    }

    private AdSize getAdSize(ISBannerSize iSBannerSize, boolean bl2) {
        switch (iSBannerSize.getDescription()) {
            case "BANNER": {
                return AdSize.BANNER;
            }
            case "LARGE": {
                return AdSize.LARGE_BANNER;
            }
            case "RECTANGLE": {
                return AdSize.MEDIUM_RECTANGLE;
            }
            case "SMART": {
                return bl2 ? AdSize.LEADERBOARD : AdSize.BANNER;
            }
            case "CUSTOM": {
                return new AdSize(iSBannerSize.getWidth(), iSBannerSize.getHeight());
            }
        }
        return null;
    }

    private AdListener createBannerAdListener(final AdView adView, final String string) {
        return new AdListener(){

            public void onAdClosed() {
                super.onAdClosed();
                if (AdMobAdapter.this.mBannerPlacementToListenerMap.containsKey(string)) {
                    ((BannerSmashListener)AdMobAdapter.this.mBannerPlacementToListenerMap.get(string)).onBannerAdScreenDismissed();
                }
            }

            public void onAdFailedToLoad(int n2) {
                super.onAdFailedToLoad(n2);
                if (AdMobAdapter.this.mBannerPlacementToListenerMap.containsKey(string)) {
                    String string2 = AdMobAdapter.this.getErrorString(n2) + "( " + n2 + " )";
                    IronSourceError ironSourceError = ErrorBuilder.buildLoadFailedError((String)string2);
                    ((BannerSmashListener)AdMobAdapter.this.mBannerPlacementToListenerMap.get(string)).onBannerAdLoadFailed(ironSourceError);
                }
            }

            public void onAdLeftApplication() {
                super.onAdLeftApplication();
                if (AdMobAdapter.this.mBannerPlacementToListenerMap.containsKey(string)) {
                    ((BannerSmashListener)AdMobAdapter.this.mBannerPlacementToListenerMap.get(string)).onBannerAdClicked();
                    ((BannerSmashListener)AdMobAdapter.this.mBannerPlacementToListenerMap.get(string)).onBannerAdLeftApplication();
                }
            }

            public void onAdOpened() {
                super.onAdOpened();
                if (AdMobAdapter.this.mBannerPlacementToListenerMap.containsKey(string)) {
                    ((BannerSmashListener)AdMobAdapter.this.mBannerPlacementToListenerMap.get(string)).onBannerAdScreenPresented();
                }
            }

            public void onAdLoaded() {
                super.onAdLoaded();
                if (AdMobAdapter.this.mBannerPlacementToListenerMap.containsKey(string)) {
                    FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
                    layoutParams.gravity = 17;
                    ((BannerSmashListener)AdMobAdapter.this.mBannerPlacementToListenerMap.get(string)).onBannerAdLoaded((View)adView, layoutParams);
                }
            }
        };
    }

    public void loadBanner(final IronSourceBannerLayout ironSourceBannerLayout, JSONObject jSONObject, final BannerSmashListener bannerSmashListener) {
        if (bannerSmashListener == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "AdMob loadBanner listener == null", 3);
            return;
        }
        if (ironSourceBannerLayout == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "AdMob loadBanner banner == null", 3);
            return;
        }
        final String string = jSONObject.optString("adUnitId");
        if (TextUtils.isEmpty((CharSequence)string)) {
            IronSourceError ironSourceError = ErrorBuilder.buildLoadFailedError((String)"AdMobAdapter loadBanner adUnitId is empty");
            bannerSmashListener.onBannerAdLoadFailed(ironSourceError);
            return;
        }
        final AdSize adSize = this.getAdSize(ironSourceBannerLayout.getSize(), AdapterUtils.isLargeScreen((Activity)ironSourceBannerLayout.getActivity()));
        if (adSize == null) {
            bannerSmashListener.onBannerAdLoadFailed(ErrorBuilder.unsupportedBannerSize((String)"AdMob"));
            return;
        }
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    AdView adView = new AdView((Context)ironSourceBannerLayout.getActivity());
                    adView.setAdSize(adSize);
                    adView.setAdUnitId(string);
                    adView.setAdListener(AdMobAdapter.this.createBannerAdListener(adView, string));
                    AdMobAdapter.this.mAdIdToBannerAd.put(string, adView);
                    AdMobAdapter.this.mBannerPlacementToListenerMap.put(string, bannerSmashListener);
                    AdRequest adRequest = AdMobAdapter.this.createAdRequest();
                    adView.loadAd(adRequest);
                }
                catch (Exception exception) {
                    IronSourceError ironSourceError = ErrorBuilder.buildLoadFailedError((String)("AdMobAdapter loadBanner exception " + exception.getMessage()));
                    bannerSmashListener.onBannerAdLoadFailed(ironSourceError);
                }
            }
        });
    }

    public void destroyBanner(final JSONObject jSONObject) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    String string = jSONObject.optString("adUnitId");
                    if (AdMobAdapter.this.mAdIdToBannerAd.containsKey(string)) {
                        AdView adView = (AdView)AdMobAdapter.this.mAdIdToBannerAd.get(string);
                        adView.destroy();
                        AdMobAdapter.this.mAdIdToBannerAd.remove(string);
                    }
                }
                catch (Exception exception) {
                    AdMobAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, "AdMob destroyBanner() exception: " + exception, 3);
                }
            }
        });
    }

    public void reloadBanner(final JSONObject jSONObject) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                if (AdMobAdapter.this.mAdIdToBannerAd.get(jSONObject.optString("adUnitId")) != null) {
                    AdRequest adRequest = AdMobAdapter.this.createAdRequest();
                    ((AdView)AdMobAdapter.this.mAdIdToBannerAd.get(jSONObject.optString("adUnitId"))).loadAd(adRequest);
                }
            }
        });
    }

    private AdRequest createAdRequest() {
        AdRequest.Builder builder = new AdRequest.Builder();
        builder.setGender(this.mGender);
        builder.setRequestAgent("ironSource");
        if (this.mAge > -1) {
            builder.tagForChildDirectedTreatment(this.mAge < 13);
        }
        if (this.mConsent != null && !this.mConsent.booleanValue()) {
            Bundle bundle = new Bundle();
            bundle.putString("npa", "1");
            builder.addNetworkExtrasBundle(com.google.ads.mediation.admob.AdMobAdapter.class, bundle);
        }
        return builder.build();
    }

    private String getErrorString(int n2) {
        switch (n2) {
            case 0: {
                return "Internal error";
            }
            case 1: {
                return "The ad request was invalid";
            }
            case 2: {
                return "The ad request was unsuccessful due to network connectivity";
            }
            case 3: {
                return "The ad request was successful, but no ad was returned due to lack of ad inventory";
            }
        }
        return "Unknown error";
    }

    private InterstitialAd getInterstitialAd(JSONObject jSONObject) {
        String string = jSONObject.optString("adUnitId");
        if (TextUtils.isEmpty((CharSequence)string) || !this.mAdIdToIsAd.containsKey(string)) {
            return null;
        }
        return this.mAdIdToIsAd.get(string);
    }

    private void setInterstitialAdAvailability(final JSONObject jSONObject) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                InterstitialAd interstitialAd = AdMobAdapter.this.getInterstitialAd(jSONObject);
                String string = jSONObject.optString("adUnitId");
                if (interstitialAd != null && string != null) {
                    IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "setInterstitialAdAvailability for " + string + ", avilbility " + interstitialAd.isLoaded(), 1);
                    AdMobAdapter.this.mInterstitialAdsAvailability.put(string, interstitialAd.isLoaded());
                }
            }
        });
    }

    protected void setConsent(boolean bl2) {
        this.mConsent = bl2;
    }
}

