/*
 * Decompiled with CFR 0.152.
 */
package com.uniplay.adsdk.video;

import android.content.Context;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.widget.VideoView;
import com.uniplay.adsdk.utils.SDKLog;
import com.uniplay.adsdk.video.Player;
import com.uniplay.adsdk.video.VideoPlayerListener;
import com.uniplay.adsdk.video.VideoProgressThread;
import java.util.ArrayList;
import java.util.List;

public class TrackingVideoView
extends VideoView
implements MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener {
    private int sysAudio = 0;
    private AudioManager audioManager;
    private int defAudio = 0;
    private final List<VideoPlayerListener> callbacks = new ArrayList<VideoPlayerListener>(1);
    private VideoProgressThread progressThread;
    private PlaybackState state = PlaybackState.STOPPED;
    private Player mPlayer;

    public void setSysMute() {
        this.defAudio = this.sysAudio;
        this.setAudio(this.sysAudio);
    }

    public TrackingVideoView(Context context) {
        super(context);
        this.init(null);
    }

    public TrackingVideoView(Context context, Player player) {
        super(context);
        this.init(player);
    }

    private void init(Player player) {
        super.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
        super.setOnErrorListener((MediaPlayer.OnErrorListener)this);
        this.mPlayer = player;
        this.audioManager = (AudioManager)this.getContext().getSystemService("audio");
        this.sysAudio = this.audioManager.getStreamVolume(3);
        this.audioManager.setStreamVolume(3, this.sysAudio, 4);
        this.defAudio = this.sysAudio;
        this.setAudio(this.sysAudio);
        MediaPlayer.OnPreparedListener onPreparedListener = new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mediaPlayer) {
                for (VideoPlayerListener videoPlayerListener : TrackingVideoView.this.callbacks) {
                    videoPlayerListener.onVideoPlay(TrackingVideoView.this.mPlayer);
                }
                try {
                    mediaPlayer.setOnInfoListener(new MediaPlayer.OnInfoListener(){

                        public boolean onInfo(MediaPlayer mediaPlayer, int n2, int n3) {
                            if (n2 == 3) {
                                TrackingVideoView.this.setBackgroundColor(0);
                                SDKLog.e("info", "mp.setoninfo-true:");
                                return true;
                            }
                            SDKLog.e("info", "mp.setoninfo-false:");
                            return false;
                        }
                    });
                }
                catch (Throwable throwable) {
                    SDKLog.e("info", "mp.setoninfo-err:" + throwable.getMessage());
                }
            }
        };
        this.setOnPreparedListener(onPreparedListener);
    }

    private void setAudio(int n2) {
        this.audioManager.setStreamVolume(3, n2, 4);
    }

    public void setMute() {
        this.defAudio = 0;
        this.setAudio(this.defAudio);
    }

    public void start() {
        super.start();
        PlaybackState playbackState = this.state;
        this.state = PlaybackState.PLAYING;
        switch (playbackState) {
            case STOPPED: {
                this.progressThread = new VideoProgressThread(this.mPlayer, this.callbacks);
                this.progressThread.start();
                break;
            }
            case PAUSED: {
                for (VideoPlayerListener videoPlayerListener : this.callbacks) {
                    videoPlayerListener.onVideoResume(this.mPlayer);
                }
                break;
            }
        }
    }

    public void pause() {
        super.pause();
        this.state = PlaybackState.PAUSED;
        this.setAudio(this.sysAudio);
        for (VideoPlayerListener videoPlayerListener : this.callbacks) {
            videoPlayerListener.onVideoPause(this.mPlayer);
        }
        this.stopPlayback();
    }

    public void resume() {
        super.resume();
        this.setAudio(this.defAudio);
        for (VideoPlayerListener videoPlayerListener : this.callbacks) {
            videoPlayerListener.onVideoResume(this.mPlayer);
        }
    }

    public void stopPlayback() {
        super.stopPlayback();
        this.onStop(null);
    }

    private void onStop(MediaPlayer mediaPlayer) {
        this.setAudio(this.sysAudio);
        if (this.state == PlaybackState.STOPPED) {
            return;
        }
        this.state = PlaybackState.STOPPED;
        if (this.progressThread != null) {
            this.progressThread.quit();
            try {
                this.progressThread.join();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            this.progressThread = null;
        }
    }

    public void onCompletion(MediaPlayer mediaPlayer) {
        this.onStop(mediaPlayer);
        this.setAudio(this.sysAudio);
        for (VideoPlayerListener videoPlayerListener : this.callbacks) {
            videoPlayerListener.onVideoComplete(this.mPlayer);
        }
    }

    public boolean onError(MediaPlayer mediaPlayer, int n2, int n3) {
        for (VideoPlayerListener videoPlayerListener : this.callbacks) {
            videoPlayerListener.onVideoError(this.mPlayer);
        }
        this.onStop(mediaPlayer);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCallback(VideoPlayerListener videoPlayerListener) {
        if (this.callbacks.contains(videoPlayerListener)) {
            return;
        }
        List<VideoPlayerListener> list = this.callbacks;
        synchronized (list) {
            this.callbacks.add(videoPlayerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCallback(VideoPlayerListener videoPlayerListener) {
        List<VideoPlayerListener> list = this.callbacks;
        synchronized (list) {
            this.callbacks.remove(videoPlayerListener);
        }
    }

    public void setOnCompletionListener(MediaPlayer.OnCompletionListener onCompletionListener) {
        throw new UnsupportedOperationException();
    }

    private static enum PlaybackState {
        STOPPED,
        PAUSED,
        PLAYING;

    }
}

