/*
 * Decompiled with CFR 0.152.
 */
package com.uniplay.adsdk.net;

import android.text.TextUtils;
import com.uniplay.adsdk.AppInfo;
import com.uniplay.adsdk.DeviceInfo;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public class HttpManager {
    private static final int MAX_CONN_NUM = 3;
    private static final int CONN_PER_ROUTE_NUM = 10;
    private int BUFFER_SIZE = 8192;
    private static HttpManager sHttpMgr = null;
    private HttpClient mHttpClient = null;

    private HttpManager() {
        BasicHttpParams basicHttpParams = new BasicHttpParams();
        ConnManagerParams.setTimeout((HttpParams)basicHttpParams, (long)15000L);
        ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)basicHttpParams, (ConnPerRoute)new ConnPerRouteBean(10));
        ConnManagerParams.setMaxTotalConnections((HttpParams)basicHttpParams, (int)3);
        HttpProtocolParams.setVersion((HttpParams)basicHttpParams, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)basicHttpParams, (String)"UTF-8");
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)basicHttpParams, (boolean)false);
        HttpClientParams.setRedirecting((HttpParams)basicHttpParams, (boolean)true);
        if (!TextUtils.isEmpty((CharSequence)DeviceInfo.USER_AGENT)) {
            HttpProtocolParams.setUserAgent((HttpParams)basicHttpParams, (String)DeviceInfo.USER_AGENT);
        }
        HttpConnectionParams.setSoTimeout((HttpParams)basicHttpParams, (int)15000);
        HttpConnectionParams.setConnectionTimeout((HttpParams)basicHttpParams, (int)15000);
        HttpConnectionParams.setTcpNoDelay((HttpParams)basicHttpParams, (boolean)true);
        HttpConnectionParams.setSocketBufferSize((HttpParams)basicHttpParams, (int)this.BUFFER_SIZE);
        HttpProtocolParams.setUseExpectContinue((HttpParams)basicHttpParams, (boolean)true);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        schemeRegistry.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
        ThreadSafeClientConnManager threadSafeClientConnManager = new ThreadSafeClientConnManager((HttpParams)basicHttpParams, schemeRegistry);
        this.mHttpClient = new DefaultHttpClient((ClientConnectionManager)threadSafeClientConnManager, (HttpParams)basicHttpParams);
    }

    public static HttpManager getHttpClient() {
        if (sHttpMgr == null) {
            sHttpMgr = new HttpManager();
        }
        return sHttpMgr;
    }

    public void releaseHttpClient() {
        if (this.mHttpClient != null) {
            this.mHttpClient.getConnectionManager().shutdown();
            this.mHttpClient = null;
        }
    }

    public InputStream doPost(String string, StringEntity stringEntity) throws ClientProtocolException, IOException {
        HttpResponse httpResponse;
        InputStream inputStream = null;
        HttpPost httpPost = new HttpPost(string);
        httpPost.setHeader("U-Version", "50804");
        httpPost.setHeader("U-Pkg", AppInfo.packageName);
        httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        httpPost.setHeader("Connection", "close");
        if (stringEntity != null) {
            httpPost.setEntity((HttpEntity)stringEntity);
        }
        if ((httpResponse = this.mHttpClient.execute((HttpUriRequest)httpPost)).getStatusLine().getStatusCode() == 200) {
            HttpEntity httpEntity = httpResponse.getEntity();
            inputStream = httpEntity.getContent();
        }
        return inputStream;
    }

    public InputStream doGet(String string) throws ClientProtocolException, IOException {
        InputStream inputStream = null;
        HttpGet httpGet = new HttpGet(string);
        httpGet.setHeader("U-Version", "50804");
        httpGet.setHeader("U-Pkg", AppInfo.packageName);
        httpGet.setHeader("Connection", "close");
        HttpResponse httpResponse = this.mHttpClient.execute((HttpUriRequest)httpGet);
        if (httpResponse.getStatusLine().getStatusCode() == 200) {
            HttpEntity httpEntity = httpResponse.getEntity();
            inputStream = httpEntity.getContent();
        }
        return inputStream;
    }

    private static interface TimeOutSetting {
        public static final long CONN_POOL_TIME_OUT = 15000L;
        public static final int CONN_TIME_OUT = 15000;
        public static final int SO_TIME_OUT = 15000;
    }
}

