/*
 * Decompiled with CFR 0.152.
 */
package com.uniplay.adsdk.imagecache;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.util.Log;
import com.uniplay.adsdk.utils.SDKLog;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;

public class LoaderImpl {
    private Map<String, SoftReference<Bitmap>> imageCache;
    private boolean cache2FileFlag = false;
    private String cachedDir;
    private Map<String, Long> filesizeCache;

    public LoaderImpl(Map<String, SoftReference<Bitmap>> map, Map<String, Long> map2) {
        this.imageCache = map;
        this.filesizeCache = map2;
    }

    public void setCache2File(boolean bl2) {
        this.cache2FileFlag = bl2;
    }

    public void setCachedDir(String string) {
        this.cachedDir = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap getBitmapFromUrl(String string, boolean bl2, int n2, int n3) {
        File file = null;
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        File file2 = null;
        try {
            File file3;
            int n4;
            URL uRL = new URL(string);
            SDKLog.e(this.getClass().getName(), "lpic_\u7f51\u7edc\u8bf7\u6c42\u65f6\u4fdd\u5b58\u5230\u672c\u5730fileName:" + this.getMD5Str(string));
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            SDKLog.e(this.getClass().getName(), "lpic_ conn.getContentLength()\u7f51\u7edc\u8bf7\u6c42\u65f6\u83b7\u53d6\u5230\u6587\u4ef6\u7684\u5927\u5c0f:" + httpURLConnection.getContentLength());
            httpURLConnection.setConnectTimeout(25000);
            httpURLConnection.setReadTimeout(25000);
            inputStream = httpURLConnection.getInputStream();
            if (inputStream == null) {
                throw new RuntimeException("stream is null");
            }
            String string2 = this.getMD5Str(string);
            String string3 = this.cachedDir;
            if (!new File(string3).exists()) {
                new File(string3).mkdirs();
            }
            fileOutputStream = new FileOutputStream(string3 + "/" + string2 + ".tmp");
            byte[] byArray = new byte[1024];
            while ((n4 = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n4);
            }
            long l2 = fileOutputStream.getChannel().size();
            this.filesizeCache.put(string, l2);
            SDKLog.e(this.getClass().getName(), "lpic_\u7f51\u7edc\u7f13\u5b58\u5230\u672c\u5730getChannel:" + l2);
            file2 = new File(string3 + "/" + string2 + ".tmp");
            if (l2 > 0L) {
                if (file2.exists()) {
                    file3 = new File(string3 + "/" + string2);
                    file2.renameTo(file3);
                    SDKLog.e(this.getClass().getName(), "lpic_\u7f51\u7edc\u7f13\u5b58\u5230\u672c\u5730\u6210\u529f:" + l2);
                    file = this.getBitmapFromMemory(string, n2, n3);
                    if (bl2) {
                        this.imageCache.put(string, new SoftReference<File>(file));
                    }
                }
            } else if (file2.exists()) {
                file2.delete();
            }
            inputStream.close();
            httpURLConnection.disconnect();
            fileOutputStream.close();
            file3 = file;
            return file3;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            if (null != file2 && file2.exists()) {
                file2.delete();
            }
            Bitmap bitmap = null;
            return bitmap;
        }
        finally {
            if (file != null) {
                file = null;
                System.gc();
            }
            try {
                if (null != inputStream) {
                    inputStream.close();
                }
                if (null != fileOutputStream) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public byte[] InputStreamToByte(InputStream inputStream) throws IOException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n2 = inputStream.read()) != -1) {
            byteArrayOutputStream.write(n2);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return byArray;
    }

    public Bitmap loadBitmap(byte[] byArray, int n2, int n3) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)options);
        int n4 = options.outWidth;
        int n5 = options.outHeight;
        int n6 = n2 > n3 ? n3 : n2;
        int n7 = n6 / Math.round((float)n4 / (float)n5);
        Log.e((String)this.getClass().getName(), (String)("lpic view_w:" + n6 + "  view_h:" + n7));
        options.inSampleSize = this.calculateInSampleSize(options, n6, n7);
        Log.e((String)this.getClass().getName(), (String)("lpic \u7f29\u653e\u6bd4:" + options.inSampleSize));
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)options);
    }

    public Bitmap decodeSampledBitmapFromResource(InputStream inputStream, int n2, int n3) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)inputStream, (Rect)new Rect(0, 0, 0, 0), (BitmapFactory.Options)options);
        options.inSampleSize = this.calculateInSampleSize(options, n2, n3);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeStream((InputStream)inputStream, (Rect)new Rect(0, 0, 0, 0), (BitmapFactory.Options)options);
    }

    public int calculateInSampleSize(BitmapFactory.Options options, int n2, int n3) {
        int n4 = options.outHeight;
        int n5 = options.outWidth;
        int n6 = 1;
        if (n4 > n3 || n5 > n2) {
            int n7;
            int n8 = Math.round((float)n4 / (float)n3);
            n6 = n8 < (n7 = Math.round((float)n5 / (float)n2)) ? n8 : n7;
            float f2 = n5 * n4;
            float f3 = n2 * n3 * 2;
            while (f2 / (float)(n6 * n6) > f3) {
                ++n6;
            }
        }
        return n6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap getBitmapFromMemory(String string, int n2, int n3) {
        Bitmap bitmap = null;
        SDKLog.e(this.getClass().getName(), "lpic imageCache.size:" + this.imageCache.size());
        if (this.imageCache.containsKey(string)) {
            Map<String, SoftReference<Bitmap>> map = this.imageCache;
            synchronized (map) {
                SoftReference<Bitmap> softReference = this.imageCache.get(string);
                if (softReference != null) {
                    bitmap = softReference.get();
                    return bitmap;
                }
            }
        }
        if (this.cache2FileFlag) {
            SDKLog.e(this.getClass().getName(), "lpic \u5916\u90e8\u7f13\u5b58\u6587\u4ef6\u8bfb\u53d6:" + this.getMD5Str(string));
            bitmap = this.getBitmapFromFile(string, n2, n3);
            if (bitmap != null) {
                this.imageCache.put(string, new SoftReference<Bitmap>(bitmap));
            }
        }
        return bitmap;
    }

    Bitmap getBitmapFromFile(String string, int n2, int n3) {
        Bitmap bitmap = null;
        String string2 = this.getMD5Str(string);
        if (string2 == null) {
            return null;
        }
        String string3 = this.cachedDir + "/" + string2;
        try {
            File file = new File(string3);
            if (!file.exists()) {
                SDKLog.e(this.getClass().getName(), "lpic getBitmapFromFile-\u5916\u90e8\u7f13\u5b58\u6587\u4ef6\u4e0d\u5b58\u5728:" + file.getPath());
                return null;
            }
            FileInputStream fileInputStream = new FileInputStream(string3);
            SDKLog.e(this.getClass().getName(), "lpic getBitmapFromFile-getChannel().size()\u7f13\u5b58\u6587\u4ef6\u7684\u5927\u5c0f:" + fileInputStream.getChannel().size());
            if (this.filesizeCache.containsKey(string) && this.filesizeCache.get(string).longValue() == fileInputStream.getChannel().size()) {
                SDKLog.e(this.getClass().getName(), "lpic getBitmapFromFile-\u4ece\u5916\u90e8\u6587\u4ef6\u7f13\u5b58\u4e2d\u83b7\u53d6bitmap");
                bitmap = this.loadBitmap(this.InputStreamToByte(fileInputStream), n2, n3);
            } else {
                SDKLog.e(this.getClass().getName(), "lpic getBitmapFromFile-\u6587\u4ef6\u957f\u5ea6\u4e0d\u4e00\u81f4");
            }
            fileInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bitmap = null;
        }
        return bitmap;
    }

    private String getMD5Str(String string) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(string.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.out.println("NoSuchAlgorithmException caught!");
            return null;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return null;
        }
        byte[] byArray = messageDigest.digest();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (Integer.toHexString(0xFF & byArray[i2]).length() == 1) {
                stringBuffer.append("0").append(Integer.toHexString(0xFF & byArray[i2]));
                continue;
            }
            stringBuffer.append(Integer.toHexString(0xFF & byArray[i2]));
        }
        SDKLog.e(this.getClass().getName(), "lpic url:" + string + "  MD5:i_" + stringBuffer.toString());
        return "i_" + stringBuffer.toString();
    }
}

