/*
 * Decompiled with CFR 0.152.
 */
package com.uniplay.adsdk;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.webkit.WebView;
import com.uniplay.adsdk.AdEntity;
import com.uniplay.adsdk.AdManager;
import com.uniplay.adsdk.AdParser;
import com.uniplay.adsdk.AdSize;
import com.uniplay.adsdk.AdWebClient;
import com.uniplay.adsdk.AppInfo;
import com.uniplay.adsdk.ConfigureModule;
import com.uniplay.adsdk.Constants;
import com.uniplay.adsdk.DeviceInfo;
import com.uniplay.adsdk.GeoInfo;
import com.uniplay.adsdk.SplashAdListener;
import com.uniplay.adsdk.WZAdWebView;
import com.uniplay.adsdk.WZAdWebViewCallback;
import com.uniplay.adsdk.animation.SwitchAnime;
import com.uniplay.adsdk.animation.SwitchAnimeFactory;
import com.uniplay.adsdk.api.ErrorCode;
import com.uniplay.adsdk.api.UniplayAdAPI;
import com.uniplay.adsdk.basic.RuleManage;
import com.uniplay.adsdk.interf.ChangeHtml;
import com.uniplay.adsdk.net.HttpUtil;
import com.uniplay.adsdk.net.TaskEntity;
import com.uniplay.adsdk.utils.PreferencesHelper;
import com.uniplay.adsdk.utils.SDKLog;
import com.uniplay.adsdk.utils.Utils;
import org.apache.http.entity.StringEntity;
import org.json.JSONObject;

public class SplashAdView
implements ChangeHtml,
TaskEntity.OnResultListener {
    private String uniplayAppid;
    private String uniplaySlotid = "splash";
    private ViewGroup viewGroup;
    protected WZAdWebView frontWebView;
    private AdWebClient adWebClient;
    private Context context;
    private AdEntity adEntity;
    private int adSize;
    private SplashAdView splashAdView;
    private SplashAdListener splashAdListener;
    private int closeTiem = -1;
    private String adLogo;
    private PreferencesHelper ph;
    Handler mHandler = new Handler(){

        public void handleMessage(Message message) {
            super.handleMessage(message);
            switch (message.what) {
                case 258: {
                    if (SplashAdView.this.splashAdListener == null) break;
                    SplashAdView.this.splashAdListener.onSplashAdDismiss();
                }
            }
        }
    };

    public SplashAdView(Context context, ViewGroup viewGroup, String string, SplashAdListener splashAdListener) {
        this.context = context.getApplicationContext();
        this.viewGroup = viewGroup;
        this.uniplayAppid = string;
        this.splashAdView = this;
        this.splashAdListener = splashAdListener;
        this.adSize = -1;
        this.initAdView(context);
    }

    public void setCLoseBtnBig() {
        Constants.CLOSE_BUTTON = 38;
    }

    private void initAdView(Context context) {
        this.context = context;
        this.ph = PreferencesHelper.getInstance(context);
        Utils.DeleteDownLoadContentFileByTimeInterval(context);
        AdManager.getInstance().initAdManager(context, this.uniplayAppid);
        UniplayAdAPI.getInstance().signIn(context, this.uniplayAppid, this.uniplaySlotid);
        if (this.adSize == -1) {
            this.adSize = AdSize.getFixSplash();
        }
        this.adWebClient = new AdWebClient(context);
        this.adWebClient.callback = new AdViewCallback();
        this.loadAd();
    }

    public void loadAd() {
        block10: {
            try {
                if (!((Boolean)ConfigureModule.getConfigureData("splash", "adswitch")).booleanValue()) {
                    if (this.splashAdListener != null) {
                        this.splashAdListener.onSplashAdFailed("AdSwitch Disable");
                    }
                    return;
                }
                if (Math.abs(AdManager.splashLastUpdate - System.currentTimeMillis()) < 6000L) {
                    if (this.splashAdListener != null) {
                        this.splashAdListener.onSplashAdFailed(ErrorCode.APP_FREQUENCY_LIMIT.getCode());
                    }
                    return;
                }
                if (this.ph != null && !RuleManage.getInstance().isSend(this.context, "splash")) {
                    if (this.splashAdListener != null) {
                        this.splashAdListener.onSplashAdFailed(ErrorCode.NOT_SEND_REQUEST_ONEHOUS_LIMIT.getCode());
                    }
                    return;
                }
                AdManager.splashLastUpdate = System.currentTimeMillis();
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("appid", (Object)this.uniplayAppid);
                jSONObject.put("slotid", (Object)this.uniplaySlotid);
                jSONObject.put("vsdk", 50804);
                jSONObject.put("adt", 4);
                jSONObject.put("adw", AdSize.getAdWidth(this.adSize));
                jSONObject.put("adh", AdSize.getAdHeight(this.adSize));
                jSONObject.put("chn", (Object)ConfigureModule.getConfigureData("", "c").toString());
                if (this.context.getResources().getConfiguration().orientation == 2) {
                    jSONObject.put("dso", 1);
                } else {
                    jSONObject.put("dso", 2);
                }
                jSONObject.put("device", (Object)DeviceInfo.device);
                jSONObject.put("app", (Object)AppInfo.app);
                jSONObject.put("geo", (Object)GeoInfo.loc);
                StringEntity stringEntity = new StringEntity(jSONObject.toString(), "utf-8");
                HttpUtil.AddTaskToQueueHead("http://api.uniplayad.com/phone/get.php", stringEntity, 259, new AdParser(), this);
                AdManager.trackRequestAd();
            }
            catch (Exception exception) {
                if (this.splashAdListener == null) break block10;
                this.splashAdListener.onSplashAdFailed(ErrorCode.PARAMETER_ERR_LIMIT.getCode());
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void onResult(Object object) {
        TaskEntity taskEntity = (TaskEntity)object;
        if (taskEntity.taskId == 259) {
            AdEntity adEntity = (AdEntity)taskEntity.outObject;
            if (adEntity.res == 0) {
                if (RuleManage.getInstance().isValid(this.context, adEntity.denypkg, adEntity.havepkg, adEntity.ruleurl)) {
                    if (this.ph != null) {
                        this.ph.saveScont(0);
                        this.ph.saveStime("");
                        this.ph.savaNoadnum(this.uniplaySlotid, adEntity.noadnum);
                        this.ph.savaNoadwait(this.uniplaySlotid, adEntity.noadwait);
                    }
                    String string = adEntity.html;
                    this.frontWebView = new WZAdWebView(this.context);
                    this.frontWebView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
                    this.frontWebView.setAd(adEntity);
                    this.frontWebView.setSplashListener(this.splashAdListener);
                    this.frontWebView.getSettings().setSupportZoom(false);
                    this.frontWebView.setBackgroundColor(0);
                    this.frontWebView.setWebViewClient(this.adWebClient);
                    this.adWebClient.setAdEntity(adEntity);
                    string = this.changeCloseTiem(this.closeTiem, string);
                    string = this.changeAdLogo(this.adLogo, string);
                    SDKLog.e("info", this.getClass().getName() + "html:" + string);
                    this.frontWebView.loadDataWithBaseURL("", string, "text/html", "UTF-8", "");
                    this.adEntity = adEntity;
                    AdManager.trackFetchedAd();
                } else {
                    AdManager.splashLastUpdate = 0L;
                    if (this.splashAdListener != null) {
                        this.splashAdListener.onSplashAdFailed(ErrorCode.PKG_RULE_LIMIT.getCode());
                    }
                    if (this.ph != null) {
                        this.ph.saveScont(this.ph.getScont() + 1);
                        this.ph.saveStime(Utils.getDate("yyyy-M-d HH:mm:ss"));
                    }
                }
            } else {
                AdManager.splashLastUpdate = 0L;
                if (this.splashAdListener != null) {
                    if (null == adEntity.msg || adEntity.msg.isEmpty()) {
                        this.splashAdListener.onSplashAdFailed(ErrorCode.FOUND_AD_ERR.getCode());
                    } else {
                        this.splashAdListener.onSplashAdFailed(ErrorCode.AD_NOT_FOUND.getCode());
                    }
                }
                if (this.ph != null) {
                    this.ph.saveScont(this.ph.getScont() + 1);
                    this.ph.saveStime(Utils.getDate("yyyy-M-d HH:mm:ss"));
                }
            }
        }
    }

    @Override
    public void onError(Object object) {
        try {
            TaskEntity taskEntity = (TaskEntity)object;
            if (taskEntity.taskId == 259) {
                if (this.splashAdListener != null) {
                    this.splashAdListener.onSplashAdFailed(taskEntity.errorMsg.errorMessage);
                }
                if (this.ph != null) {
                    this.ph.saveScont(this.ph.getScont() + 1);
                    this.ph.saveStime(Utils.getDate("yyyy-M-d HH:mm:ss"));
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public String changeCloseTiem(int n2, String string) {
        if (n2 != -1 && n2 > 0 && string.contains("{_CLOSE-TIME_}")) {
            SDKLog.e("info", this.getClass().getName() + "replaceHtmlTimeAndLogo-setCloseTiem:" + n2);
            string = string.replace("{_CLOSE-TIME_}", n2 + "");
        }
        return string;
    }

    @Override
    public String changeAdLogo(String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string) && string2.contains("{_AD-LOGO_}")) {
            SDKLog.e("info", this.getClass().getName() + "replaceHtmlTimeAndLogo-AD_LOGO:" + string);
            string2 = string2.replace("{_AD-LOGO_}", string);
        }
        return string2;
    }

    public int isVisibility() {
        if (this.frontWebView != null) {
            return this.frontWebView.getVisibility();
        }
        return 8;
    }

    public void setVisible(int n2) {
        this.frontWebView.setVisibility(n2);
    }

    public void setCloseTiem(int n2) {
        this.closeTiem = n2;
    }

    public void setAdLogo(String string) {
        this.adLogo = string;
    }

    private void generateSwitchAnime() {
        SwitchAnime switchAnime = SwitchAnimeFactory.getSwitchAnimation(68);
        Animation animation = switchAnime.getSwichInAnime(this.adSize);
        animation.setAnimationListener((Animation.AnimationListener)new SwicthAnimeListener());
        this.frontWebView.setAnimation(switchAnime.getSwichInAnime(this.adSize));
    }

    private void onLoadAdFinish() {
        block5: {
            try {
                this.viewGroup.removeAllViews();
                this.viewGroup.addView((View)this.frontWebView);
                this.generateSwitchAnime();
                this.viewGroup.requestFocus();
                if (this.splashAdListener != null) {
                    this.splashAdListener.onSplashAdShow();
                }
                if (this.adEntity.adt == 4) {
                    this.mHandler.sendEmptyMessageDelayed(258, 5000L);
                } else {
                    this.frontWebView.loadUrl("javascript:getShowUrl()");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (this.splashAdListener == null) break block5;
                this.splashAdListener.onSplashAdFailed("onLoadAdFinish_AdView Error");
            }
        }
    }

    public void removeSplashAdView() {
        try {
            if (this.viewGroup != null && this.frontWebView != null) {
                this.viewGroup.removeView((View)this.frontWebView);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class SwicthAnimeListener
    implements Animation.AnimationListener {
        private SwicthAnimeListener() {
        }

        public void onAnimationStart(Animation animation) {
        }

        public void onAnimationEnd(Animation animation) {
        }

        public void onAnimationRepeat(Animation animation) {
        }
    }

    private class AdViewCallback
    implements WZAdWebViewCallback {
        private AdViewCallback() {
        }

        @Override
        public void onWebViewLoadFinish(WebView webView) {
            SplashAdView.this.splashAdView.onLoadAdFinish();
        }

        @Override
        public void onWebViewClick(WebView webView, boolean bl2) {
        }

        @Override
        public void onPageStarted() {
        }
    }
}

