/*
 * Decompiled with CFR 0.152.
 */
package com.mintegral.msdk.optimize;

import android.content.ContentResolver;
import android.content.Context;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.NetworkInterface;
import java.util.Collections;
import java.util.UUID;

public class SensitiveDataUtil {
    private static String deviceid;
    private static String macAddress;
    private static String androidID;
    private static String mSelfId;

    private static void writeFile(Context object, File file, String string) throws IOException {
        block6: {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            file.createNewFile();
            object = null;
            try {
                object = new FileOutputStream(file);
                ((FileOutputStream)object).write(string.getBytes());
            }
            catch (Throwable throwable) {
                try {
                    throwable.printStackTrace();
                    return;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    if (object == null) break block6;
                    ((FileOutputStream)object).close();
                }
            }
            ((FileOutputStream)object).close();
            return;
        }
    }

    private static String writeInstallationFile(Context context, File file) throws IOException {
        UUID uUID = UUID.randomUUID();
        SensitiveDataUtil.writeFile(context, file, uUID.toString());
        return uUID.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String readInstallationFile(File object) throws IOException {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile((File)object, "r");
            object = new byte[(int)randomAccessFile.length()];
            randomAccessFile.readFully((byte[])object);
            object = new String((byte[])object);
        }
        catch (Throwable throwable) {
            try {
                throwable.printStackTrace();
                return null;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
        }
        randomAccessFile.close();
        return object;
    }

    public static String getSelfId(Context context) {
        if (mSelfId == null) {
            File file = new File(Environment.getExternalStorageDirectory().toString(), "/.a/track_id.bin");
            try {
                mSelfId = !file.exists() ? SensitiveDataUtil.writeInstallationFile(context, file) : SensitiveDataUtil.readInstallationFile(file);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (mSelfId == null) {
            return "";
        }
        return mSelfId;
    }

    public static String getIMEI(Context context) {
        try {
            if (TextUtils.isEmpty((CharSequence)deviceid) && (deviceid = ((TelephonyManager)context.getSystemService("phone")).getDeviceId()) == null && (deviceid = SensitiveDataUtil.getSelfId(context)) == null) {
                deviceid = "";
            }
        }
        catch (Throwable throwable) {
            deviceid = "";
        }
        return deviceid;
    }

    public static String getMacAddress(Context object) {
        try {
            if (TextUtils.isEmpty((CharSequence)macAddress)) {
                object = Build.VERSION.SDK_INT >= 23 ? SensitiveDataUtil.getMac() : ((WifiManager)object.getSystemService("wifi")).getConnectionInfo().getMacAddress();
                if (object == null) {
                    return "";
                }
                macAddress = object.replaceAll(":", "").toLowerCase();
                return macAddress;
            }
        }
        catch (Exception exception) {
            return "";
        }
        return macAddress;
    }

    private static String getMac() {
        try {
            Object object = Collections.list(NetworkInterface.getNetworkInterfaces()).iterator();
            while (object.hasNext()) {
                Object object2 = (NetworkInterface)object.next();
                if (!((NetworkInterface)object2).getName().equalsIgnoreCase("wlan0")) continue;
                byte[] byArray = ((NetworkInterface)object2).getHardwareAddress();
                object = byArray;
                if (byArray == null) {
                    return "";
                }
                object2 = new StringBuilder();
                for (Object object3 : object) {
                    ((StringBuilder)object2).append(String.format("%02X:", (byte)object3));
                }
                if (((StringBuilder)object2).length() > 0) {
                    ((StringBuilder)object2).deleteCharAt(((StringBuilder)object2).length() - 1);
                }
                return ((StringBuilder)object2).toString();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return "";
    }

    public static String getAndroidID(Context context) {
        try {
            if (TextUtils.isEmpty((CharSequence)androidID)) {
                androidID = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
                if (androidID == null) {
                    androidID = "";
                }
                return androidID;
            }
        }
        catch (Exception exception) {
            androidID = "";
        }
        return androidID;
    }
}

