/*
 * Decompiled with CFR 0.152.
 */
package com.uniplay.adsdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.webkit.WebView;
import android.widget.FrameLayout;
import android.widget.ViewSwitcher;
import com.uniplay.adsdk.ActionMessage;
import com.uniplay.adsdk.AdBannerListener;
import com.uniplay.adsdk.AdEntity;
import com.uniplay.adsdk.AdManager;
import com.uniplay.adsdk.AdParser;
import com.uniplay.adsdk.AdSize;
import com.uniplay.adsdk.AdWebClient;
import com.uniplay.adsdk.AppInfo;
import com.uniplay.adsdk.ClickParser;
import com.uniplay.adsdk.ConfigureModule;
import com.uniplay.adsdk.Constants;
import com.uniplay.adsdk.DeviceInfo;
import com.uniplay.adsdk.GeoInfo;
import com.uniplay.adsdk.WZAdWebView;
import com.uniplay.adsdk.WZAdWebViewCallback;
import com.uniplay.adsdk.animation.SwitchAnime;
import com.uniplay.adsdk.animation.SwitchAnimeFactory;
import com.uniplay.adsdk.api.ErrorCode;
import com.uniplay.adsdk.api.UniplayAdAPI;
import com.uniplay.adsdk.basic.RuleManage;
import com.uniplay.adsdk.net.HttpUtil;
import com.uniplay.adsdk.net.TaskEntity;
import com.uniplay.adsdk.utils.PreferencesHelper;
import com.uniplay.adsdk.utils.SDKLog;
import com.uniplay.adsdk.utils.Utils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import org.apache.http.entity.StringEntity;
import org.json.JSONObject;

public class AdView
extends FrameLayout
implements TaskEntity.OnResultListener {
    protected int adSize;
    protected Context context;
    protected ViewSwitcher viewSwitcher;
    protected WZAdWebView frontWebView;
    protected WZAdWebView backWebView;
    private String uniplayAppid;
    private String uniplaySlotid = "banner";
    private AdView adView;
    private AdWebClient webClient;
    protected AdBannerListener adListener;
    private int animeType;
    private int lastAnimeType;
    private static volatile boolean isOnScreen;
    private int requestInterval = 0;
    private int closeTiem = -1;
    private String adLogo;
    private int sideMarginSize;
    private PreferencesHelper ph;
    Handler mHandler = new Handler(){

        public void handleMessage(Message message) {
            super.handleMessage(message);
            switch (message.what) {
                case 259: {
                    if (AdView.this.requestInterval == -1) {
                        return;
                    }
                    if (AdView.this.adView.hasWindowFocus()) {
                        AdView.this.sendADRequest();
                    }
                    AdView.this.mHandler.removeMessages(259);
                    AdView.this.mHandler.sendEmptyMessageDelayed(259, (long)(AdView.this.requestInterval * 1000));
                    break;
                }
                case 257: {
                    AdEntity adEntity = (AdEntity)message.obj;
                    String string = adEntity.html;
                    string = RuleManage.getInstance().changeCloseTiem(AdView.this.closeTiem, string);
                    string = RuleManage.getInstance().changeAdLogo(AdView.this.adLogo, string);
                    if (AdView.this.frontWebView == null) {
                        AdView.this.frontWebView = new WZAdWebView(AdView.this.context);
                        AdView.this.frontWebView.setAd(adEntity);
                        AdView.this.frontWebView.getSettings().setSupportZoom(false);
                        AdView.this.frontWebView.setBackgroundColor(-1);
                        AdView.this.frontWebView.setWebViewClient(AdView.this.webClient);
                        AdView.this.webClient.setAdEntity(adEntity);
                        AdView.this.frontWebView.loadDataWithBaseURL("", string, "text/html", "UTF-8", "");
                        if (AdView.this.adListener != null) {
                            AdView.this.frontWebView.setBannerListener(AdView.this.adListener);
                            AdView.this.adListener.onAdShow((Object)this);
                        }
                    } else {
                        if (AdView.this.backWebView == null) {
                            AdView.this.backWebView = new WZAdWebView(AdView.this.context);
                            AdView.this.backWebView.setBackgroundColor(0);
                            AdView.this.backWebView.getSettings().setSupportZoom(false);
                        }
                        AdView.this.backWebView.setWebViewClient(AdView.this.webClient);
                        AdView.this.webClient.setAdEntity(adEntity);
                        AdView.this.backWebView.setAd(adEntity);
                        AdView.this.backWebView.loadDataWithBaseURL("", string, "text/html", "UTF-8", "");
                        if (AdView.this.adListener != null) {
                            AdView.this.backWebView.setBannerListener(AdView.this.adListener);
                            AdView.this.adListener.onAdShow((Object)this);
                        }
                    }
                    AdView.this.sendShowTrack(adEntity.imp);
                    break;
                }
            }
        }
    };

    public void setAdListener(AdBannerListener adBannerListener) {
        this.adListener = adBannerListener;
    }

    public AdView(Context context, String string) {
        super(context);
        this.context = context;
        this.uniplayAppid = string;
        this.adSize = -1;
        this.adView = this;
        this.initAdView(context);
    }

    public AdView(Context context, int n2, String string) {
        super(context);
        this.context = context;
        this.uniplayAppid = string;
        this.adSize = n2;
        this.adView = this;
        this.initAdView(context);
    }

    public AdView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.context = context;
        this.adSize = -1;
        this.adSize = attributeSet.getAttributeIntValue("http://schemas.android.com/apk/res/" + context.getPackageName(), "adSize", -1);
        this.uniplayAppid = attributeSet.getAttributeValue("http://schemas.android.com/apk/res/" + context.getPackageName(), "uniplayAppid");
        this.adView = this;
        this.initAdView(context);
    }

    public int getAnimeType() {
        return this.animeType;
    }

    public void setAnimeType(int n2) {
        this.animeType = n2;
    }

    private void initAdView(Context context) {
        try {
            this.requestInterval = (Integer)ConfigureModule.getConfigureData("banner", "intervaltime");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ph = PreferencesHelper.getInstance(context);
        Utils.DeleteDownLoadContentFileByTimeInterval(context);
        this.setAnimationCacheEnabled(true);
        isOnScreen = false;
        this.setFocusable(true);
        this.setDescendantFocusability(262144);
        this.setClickable(true);
        this.animeType = 1;
        this.lastAnimeType = 1;
        this.uniplayAppid = this.uniplayAppid.replace(" ", "").toLowerCase();
        AdManager.getInstance().initAdManager(context, this.uniplayAppid);
        UniplayAdAPI.getInstance().signIn(context, this.uniplayAppid, this.uniplaySlotid);
        this.webClient = new AdWebClient(context);
        this.webClient.callback = new AdViewCallback();
        if (this.adSize == -1) {
            this.adSize = AdSize.getFixAdBanner();
        }
        this.viewSwitcher = new ViewSwitcher(context);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(AdSize.getAdWidth(this.adSize), AdSize.getAdHeight(this.adSize), 153);
        this.viewSwitcher.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.addView((View)this.viewSwitcher);
    }

    public void setCloseTiem(int n2) {
        this.closeTiem = n2;
    }

    public void setAdLogo(String string) {
        this.adLogo = string;
    }

    public void setCLoseBtnBig() {
        Constants.CLOSE_BUTTON = 38;
    }

    public void sideMargin(int n2) {
        this.sideMarginSize = n2;
    }

    protected void sendADRequest() {
        if (!isOnScreen || this.getVisibility() != 0) {
            if (this.adListener != null) {
                this.adListener.onAdError("This AdView is invisible");
            }
            return;
        }
        try {
            if (!((Boolean)ConfigureModule.getConfigureData("banner", "adswitch")).booleanValue()) {
                return;
            }
            if (this.ph != null && !RuleManage.getInstance().isSend(this.context, "banner")) {
                if (this.adListener != null) {
                    this.adListener.onAdError(ErrorCode.NOT_SEND_REQUEST_ONEHOUS_LIMIT.getCode());
                }
                return;
            }
            SDKLog.e("mHandler", "\u8bf7\u6c42\u5e7f\u544a");
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("appid", (Object)this.uniplayAppid);
            jSONObject.put("slotid", (Object)this.uniplaySlotid);
            jSONObject.put("vsdk", 50804);
            if (this.adSize == 8 || this.adSize == 7 || this.adSize == 10 || this.adSize == 9) {
                jSONObject.put("adt", 1);
            } else {
                jSONObject.put("adt", 0);
            }
            jSONObject.put("adw", AdSize.getAdWidth(this.adSize));
            jSONObject.put("adh", AdSize.getAdHeight(this.adSize));
            jSONObject.put("chn", (Object)ConfigureModule.getConfigureData("", "c").toString());
            if (this.context.getResources().getConfiguration().orientation == 2) {
                jSONObject.put("dso", 1);
            } else {
                jSONObject.put("dso", 2);
            }
            jSONObject.put("device", (Object)DeviceInfo.device);
            jSONObject.put("app", (Object)AppInfo.app);
            jSONObject.put("geo", (Object)GeoInfo.loc);
            SDKLog.e("Request", jSONObject.toString());
            StringEntity stringEntity = new StringEntity(jSONObject.toString(), "utf-8");
            HttpUtil.AddTaskToQueueHead("http://api.uniplayad.com/phone/get.php", stringEntity, 259, new AdParser(), this);
            AdManager.trackRequestAd();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void generateSwitchAnime() {
        int n2 = SwitchAnimeFactory.randomAnimeType();
        if (this.lastAnimeType == n2) {
            return;
        }
        this.lastAnimeType = n2;
        SwitchAnime switchAnime = SwitchAnimeFactory.getSwitchAnimation(n2);
        this.viewSwitcher.setInAnimation(switchAnime.getSwichInAnime(this.adSize));
        Animation animation = switchAnime.getSwitchOutAnime(this.adSize);
        animation.setAnimationListener((Animation.AnimationListener)new SwicthAnimeListener());
        this.viewSwitcher.setOutAnimation(animation);
    }

    private void onLoadAdFinish() {
        this.generateSwitchAnime();
        SDKLog.e("doll", "viewSwitcher.getChildCount() " + this.viewSwitcher.getChildCount());
        try {
            switch (this.viewSwitcher.getChildCount()) {
                case 0: {
                    this.viewSwitcher.addView((View)this.frontWebView);
                    break;
                }
                case 1: {
                    this.frontWebView.setWebViewClient(null);
                    this.viewSwitcher.addView((View)this.backWebView);
                    this.viewSwitcher.setDisplayedChild(this.viewSwitcher.indexOfChild((View)this.backWebView));
                    break;
                }
                default: {
                    this.frontWebView.setWebViewClient(null);
                    this.viewSwitcher.setDisplayedChild(this.viewSwitcher.indexOfChild((View)this.backWebView));
                }
            }
            AdManager.trackShowAd();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void switchAdView() {
        if (this.backWebView != null) {
            WZAdWebView wZAdWebView = this.frontWebView;
            this.frontWebView = this.backWebView;
            this.backWebView = wZAdWebView;
            this.backWebView.clearCache(true);
            this.backWebView.destroyDrawingCache();
            this.backWebView.clearView();
        }
    }

    private void sendShowTrack(ArrayList<String> arrayList) {
        Constants.imp_send = arrayList;
        SDKLog.e("info", "AdView--\u663e\u793a\u4e0a\u62a5--");
        try {
            for (String string : arrayList) {
                HttpUtil.AddTaskToQueueHead(string, 260, new ClickParser(), this);
                SDKLog.e("info", "sendShowTrack--\u663e\u793a\u4e0a\u62a5--:" + string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            SDKLog.e("info", "AdView--\u663e\u793a\u4e0a\u62a5\u51fa\u9519--:" + exception.getMessage());
        }
    }

    @SuppressLint(value={"WrongConstant"})
    protected void onAttachedToWindow() {
        SDKLog.e("onAttachedToWindow", "onAttachedToWindow " + this.getVisibility());
        isOnScreen = true;
        this.setRefreshInterval(this.requestInterval);
        if (this.requestInterval != -1) {
            this.sendADRequest();
        }
        super.onAttachedToWindow();
    }

    public int getVisibility() {
        return super.getVisibility();
    }

    @SuppressLint(value={"WrongConstant"})
    protected void onDetachedFromWindow() {
        SDKLog.e("onDetachedFromWindow", "onDetachedFromWindow" + this.getVisibility());
        isOnScreen = false;
        this.setRefreshInterval(-1);
        super.onDetachedFromWindow();
    }

    public void setRefreshInterval(int n2) {
        SDKLog.e("setRefreshInterval", n2 + " setRefreshInterval");
        if (n2 == -1 || n2 == 0) {
            this.requestInterval = -1;
            this.mHandler.removeMessages(259);
            return;
        }
        this.requestInterval = n2;
        this.mHandler.removeMessages(259);
        this.mHandler.sendEmptyMessageDelayed(259, (long)(this.requestInterval * 1000));
    }

    @Override
    public void onResult(Object object) {
        TaskEntity taskEntity = (TaskEntity)object;
        if (taskEntity.taskId == 259) {
            AdEntity adEntity = (AdEntity)taskEntity.outObject;
            if (adEntity.res == 0) {
                if (RuleManage.getInstance().isValid(this.context, adEntity.denypkg, adEntity.havepkg, adEntity.ruleurl)) {
                    if (this.ph != null) {
                        this.ph.saveBcont(0);
                        this.ph.saveBtime("");
                        this.ph.savaNoadnum(this.uniplaySlotid, adEntity.noadnum);
                        this.ph.savaNoadwait(this.uniplaySlotid, adEntity.noadwait);
                    }
                    try {
                        if (this.adSize == -1 && adEntity.adw > 0 && adEntity.adh > 0 && adEntity.adw > adEntity.adh) {
                            DecimalFormat decimalFormat = new DecimalFormat("0.00");
                            double d2 = (double)adEntity.adw * 1.0 / (double)adEntity.adh;
                            SDKLog.e(this.getClass().getName(), "\u5bbd\u9ad8\u6bd4:" + d2);
                            int n2 = (int)TypedValue.applyDimension((int)1, (float)this.sideMarginSize, (DisplayMetrics)this.context.getResources().getDisplayMetrics());
                            int n3 = this.getWidth() - n2 * 2;
                            SDKLog.e(this.getClass().getName(), "-----\u5bbd:" + this.getWidth());
                            int n4 = (int)((double)n3 / d2);
                            n3 = (int)((double)n4 * d2);
                            SDKLog.e(this.getClass().getName(), "\u5b9e\u9645\u5c55\u793a\u7684\u9ad8:" + n4 + "\u5bbd:" + n3);
                            if (this.sideMarginSize > 0) {
                                FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n3, n4, 153);
                                layoutParams.setMargins(n2, 0, n2, 0);
                                this.viewSwitcher.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.mHandler.sendMessage(ActionMessage.obtain(257, adEntity));
                    AdManager.trackFetchedAd();
                } else {
                    if (this.adListener != null) {
                        this.adListener.onAdError(ErrorCode.PKG_RULE_LIMIT.getCode());
                    }
                    if (this.ph != null) {
                        this.ph.saveBcont(this.ph.getBcont() + 1);
                        this.ph.saveBtime(Utils.getDate("yyyy-M-d HH:mm:ss"));
                    }
                    this.setRefreshInterval(this.requestInterval);
                }
            } else {
                if (this.adListener != null) {
                    if (null == adEntity.msg || adEntity.msg.isEmpty()) {
                        this.adListener.onAdError(ErrorCode.FOUND_AD_ERR.getCode());
                    } else {
                        this.adListener.onAdError(adEntity.msg);
                    }
                }
                if (this.ph != null) {
                    this.ph.saveBcont(this.ph.getBcont() + 1);
                    this.ph.saveBtime(Utils.getDate("yyyy-M-d HH:mm:ss"));
                }
                this.setRefreshInterval(this.requestInterval);
            }
        }
    }

    @Override
    public void onError(Object object) {
        try {
            TaskEntity taskEntity = (TaskEntity)object;
            if (taskEntity.taskId == 259) {
                if (this.adListener != null) {
                    this.adListener.onAdError(taskEntity.errorMsg.errorMessage);
                }
                this.setRefreshInterval(this.requestInterval);
                if (this.ph != null) {
                    this.ph.saveBcont(this.ph.getBcont() + 1);
                    this.ph.saveBtime(Utils.getDate("yyyy-M-d HH:mm:ss"));
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected boolean isCover() {
        boolean bl = false;
        Rect rect = new Rect();
        bl = this.getGlobalVisibleRect(rect);
        if (bl && rect.width() >= this.getMeasuredWidth() && rect.height() >= this.getMeasuredHeight()) {
            return !bl;
        }
        return true;
    }

    private class SwicthAnimeListener
    implements Animation.AnimationListener {
        private SwicthAnimeListener() {
        }

        public void onAnimationStart(Animation animation) {
        }

        public void onAnimationEnd(Animation animation) {
            AdView.this.switchAdView();
        }

        public void onAnimationRepeat(Animation animation) {
        }
    }

    private class AdViewCallback
    implements WZAdWebViewCallback {
        private AdViewCallback() {
        }

        @Override
        public void onWebViewLoadFinish(WebView webView) {
            AdView.this.adView.onLoadAdFinish();
        }

        @Override
        public void onWebViewClick(WebView webView, boolean bl) {
        }

        @Override
        public void onPageStarted() {
            AdView.this.mHandler.sendEmptyMessage(259);
        }
    }
}

