/*
 * Decompiled with CFR 0.152.
 */
package com.uniplay.adsdk.utils;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.widget.Toast;
import java.util.ArrayList;
import java.util.List;

public class PermissionUtil {
    private static boolean needCheckPermission() {
        return Build.VERSION.SDK_INT >= 23;
    }

    public static boolean getExternalStoragePermissions(Activity activity, int n2) {
        return PermissionUtil.requestPerssions(activity, n2, "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE");
    }

    public static boolean getCameraPermissions(Activity activity, int n2) {
        return PermissionUtil.requestPerssions(activity, n2, "android.permission.CAMERA", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE");
    }

    public static boolean getAudioPermissions(Activity activity, int n2) {
        return PermissionUtil.requestPerssions(activity, n2, "android.permission.RECORD_AUDIO", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE");
    }

    public static boolean getLocationPermissions(Activity activity, int n2) {
        return PermissionUtil.requestPerssions(activity, n2, "android.permission.ACCESS_COARSE_LOCATION");
    }

    public static boolean getContactsPermissions(Activity activity, int n2) {
        return PermissionUtil.requestPerssions(activity, n2, "android.permission.READ_CONTACTS");
    }

    public static boolean getSendSMSPermissions(Activity activity, int n2) {
        return PermissionUtil.requestPerssions(activity, n2, "android.permission.SEND_SMS");
    }

    public static boolean getCallPhonePermissions(Activity activity, int n2) {
        return PermissionUtil.requestPerssions(activity, n2, "android.permission.CALL_PHONE");
    }

    public static List<String> getDeniedPermissions(Activity activity, String ... stringArray) {
        if (!PermissionUtil.needCheckPermission()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            if (ContextCompat.checkSelfPermission((Context)activity, (String)string) == 0) continue;
            arrayList.add(string);
        }
        if (!arrayList.isEmpty()) {
            return arrayList;
        }
        return null;
    }

    public static boolean hasPermissons(Activity activity, String ... stringArray) {
        if (!PermissionUtil.needCheckPermission()) {
            return true;
        }
        for (String string : stringArray) {
            if (ContextCompat.checkSelfPermission((Context)activity, (String)string) == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean deniedRequestPermissonsAgain(Activity activity, String ... stringArray) {
        if (!PermissionUtil.needCheckPermission()) {
            return false;
        }
        List<String> list = PermissionUtil.getDeniedPermissions(activity, stringArray);
        for (String string : list) {
            if (ContextCompat.checkSelfPermission((Context)activity, (String)string) == -1 || ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)string)) continue;
            return true;
        }
        return false;
    }

    public static void startApplicationDetailsSettings(Activity activity, int n2) {
        Toast.makeText((Context)activity, (CharSequence)"\u70b9\u51fb\u6743\u9650\uff0c\u5e76\u6253\u5f00\u5168\u90e8\u6743\u9650", (int)0).show();
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        Uri uri = Uri.fromParts((String)"package", (String)activity.getPackageName(), null);
        intent.setData(uri);
        activity.startActivityForResult(intent, n2);
    }

    public static boolean requestPerssions(Activity activity, int n2, String ... stringArray) {
        if (!PermissionUtil.needCheckPermission()) {
            return true;
        }
        if (!PermissionUtil.hasPermissons(activity, stringArray)) {
            if (PermissionUtil.deniedRequestPermissonsAgain(activity, stringArray)) {
                PermissionUtil.startApplicationDetailsSettings(activity, n2);
            } else {
                List<String> list = PermissionUtil.getDeniedPermissions(activity, stringArray);
                if (list != null) {
                    ActivityCompat.requestPermissions((Activity)activity, (String[])list.toArray(new String[list.size()]), (int)n2);
                }
            }
            return false;
        }
        return true;
    }

    public static void onRequestPermissionsResult(int n2, String[] stringArray, int[] nArray, OnRequestPermissionsResultCallbacks onRequestPermissionsResultCallbacks) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            if (nArray[i2] == 0) {
                arrayList.add(string);
                continue;
            }
            arrayList2.add(string);
        }
        if (null != onRequestPermissionsResultCallbacks) {
            if (!arrayList.isEmpty()) {
                onRequestPermissionsResultCallbacks.onPermissionsGranted(n2, arrayList, arrayList2.isEmpty());
            }
            if (!arrayList2.isEmpty()) {
                onRequestPermissionsResultCallbacks.onPermissionsDenied(n2, arrayList2, arrayList.isEmpty());
            }
        }
    }

    public static interface OnRequestPermissionsResultCallbacks {
        public void onPermissionsGranted(int var1, List<String> var2, boolean var3);

        public void onPermissionsDenied(int var1, List<String> var2, boolean var3);
    }
}

