/*
 * Decompiled with CFR 0.152.
 */
package com.uniplay.adsdk.download;

import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import com.uniplay.adsdk.download.DownloadDelivery;
import com.uniplay.adsdk.download.DownloadDispatcher;
import com.uniplay.adsdk.download.DownloadRequest;
import com.uniplay.adsdk.download.DownloadState;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

final class DownloadRequestQueue {
    private static final String TAG = DownloadRequestQueue.class.getSimpleName();
    private static final int CAPACITY = 20;
    private static final int DEFAULT_DOWNLOAD_THREAD_POOL_SIZE = 3;
    private final Set<DownloadRequest> currentRequests = new HashSet<DownloadRequest>();
    private PriorityBlockingQueue<DownloadRequest> downloadQueue = new PriorityBlockingQueue(20);
    private DownloadDispatcher[] dispatchers;
    private final DownloadDelivery delivery;
    private final AtomicInteger sequenceGenerator = new AtomicInteger();

    DownloadRequestQueue(int n2) {
        if (n2 < 1 || n2 > 10) {
            n2 = 3;
        }
        this.dispatchers = new DownloadDispatcher[n2];
        this.delivery = new DownloadDelivery(new Handler(Looper.getMainLooper()));
    }

    void start() {
        this.stop();
        for (int i2 = 0; i2 < this.dispatchers.length; ++i2) {
            DownloadDispatcher downloadDispatcher;
            this.dispatchers[i2] = downloadDispatcher = new DownloadDispatcher(this.downloadQueue, this.delivery);
            downloadDispatcher.start();
        }
    }

    void stop() {
        for (DownloadDispatcher downloadDispatcher : this.dispatchers) {
            if (downloadDispatcher == null) continue;
            downloadDispatcher.quit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean add(DownloadRequest downloadRequest) {
        if (this.query(downloadRequest.downloadId()) != DownloadState.INVALID || this.query(downloadRequest.uri()) != DownloadState.INVALID) {
            return false;
        }
        downloadRequest.setDownloadRequestQueue(this);
        Set<DownloadRequest> set = this.currentRequests;
        synchronized (set) {
            this.currentRequests.add(downloadRequest);
        }
        this.downloadQueue.add(downloadRequest);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean cancel(int n2) {
        Set<DownloadRequest> set = this.currentRequests;
        synchronized (set) {
            for (DownloadRequest downloadRequest : this.currentRequests) {
                if (downloadRequest.downloadId() != n2) continue;
                downloadRequest.cancel();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelAll() {
        Set<DownloadRequest> set = this.currentRequests;
        synchronized (set) {
            for (DownloadRequest downloadRequest : this.currentRequests) {
                downloadRequest.cancel();
            }
        }
        this.currentRequests.clear();
    }

    int getDownloadingSize() {
        return this.currentRequests.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DownloadState query(int n2) {
        Set<DownloadRequest> set = this.currentRequests;
        synchronized (set) {
            for (DownloadRequest downloadRequest : this.currentRequests) {
                if (downloadRequest.downloadId() != n2) continue;
                return downloadRequest.downloadState();
            }
        }
        return DownloadState.INVALID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DownloadState query(Uri uri) {
        Set<DownloadRequest> set = this.currentRequests;
        synchronized (set) {
            for (DownloadRequest downloadRequest : this.currentRequests) {
                if (!downloadRequest.uri().toString().equals(uri.toString())) continue;
                return downloadRequest.downloadState();
            }
        }
        return DownloadState.INVALID;
    }

    int getSequenceNumber() {
        return this.sequenceGenerator.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finish(DownloadRequest downloadRequest) {
        Set<DownloadRequest> set = this.currentRequests;
        synchronized (set) {
            this.currentRequests.remove(downloadRequest);
        }
    }

    void release() {
        this.cancelAll();
        if (this.downloadQueue != null) {
            this.downloadQueue = null;
        }
        if (this.dispatchers != null) {
            this.stop();
            for (int i2 = 0; i2 < this.dispatchers.length; ++i2) {
                this.dispatchers[i2] = null;
            }
            this.dispatchers = null;
        }
    }
}

