package com.yodo1ads.plugin.admob;

import android.app.Activity;
import android.text.TextUtils;

import com.google.android.gms.ads.MobileAds;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.ValidateUtils;

import java.util.Arrays;
import java.util.List;

/**
 * Created by yodo1 on 2016/3/22.
 */
public class AdvertCoreAdMob {

    private static AdvertCoreAdMob instance;
    private AdvertCoreAdMob(){}
    public static AdvertCoreAdMob getInstance(){
        if(instance == null){
            instance = new AdvertCoreAdMob();
        }
        return instance;
    }

    private boolean isValidate = false;

    public void validateAds(Activity activity){
        if(!isValidate) {
            List<String> adcolonyActivities = Arrays.asList(new String[] { "com.google.android.gms.ads.AdActivity" });
            ValidateUtils.validateActivities(activity,adcolonyActivities);
            isValidate = true;
        }
    }


    private boolean init = false;

    public void initAdMob(Activity activity){
        if(!init) {
            //此处读取key
            String appid = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd, AdConfigAdMob.CHANNEL_CODE
                    , AdConfigAdMob.KEY_AdMob_BANNER_APPID);

            if (TextUtils.isEmpty(appid)){
                appid = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, AdConfigAdMob.CHANNEL_CODE
                        , AdConfigAdMob.KEY_AdMob_VIDEO_APPID);
            }
            if (TextUtils.isEmpty(appid)){
                appid = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, AdConfigAdMob.CHANNEL_CODE
                        , AdConfigAdMob.KEY_AdMob_INTERSTITIAL_APPID);
            }

            if (!TextUtils.isEmpty(appid)){
                MobileAds.initialize(activity.getApplicationContext(),
                        appid);
                init = true;
            }

        }
    }
}
