package com.yodo1ads.adapter.video;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.text.TextUtils;

import com.mintegral.msdk.out.MTGRewardVideoHandler;
import com.mintegral.msdk.out.RewardVideoListener;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.advert.video.AdVideoAdapterBase;
import com.yodo1.advert.video.Yodo1VideoCallback;
import com.yodo1.advert.video.Yodo1VideoReloadCallback;
import com.yodo1.sdk.kit.YLog;
import com.yodo1ads.plugin.mobvista.AdConfigMobvista;
import com.yodo1ads.plugin.mobvista.AdvertCoreMobVista;

/**
 * Created by yodo1 on 2017/9/27.
 */
public class AdvertAdaptermintegral extends AdVideoAdapterBase {
    private MTGRewardVideoHandler mMvRewardVideoHandler;
    private Yodo1VideoCallback videoCallback; //视频回调
    private Yodo1VideoReloadCallback reloadCallback; //视频预加载回调
    private String mRewardUnitId = "2163";
    private String mRewardId = "12817";
    private String appId = "24282";
    private String appKey = "7c22942b749fe6a6e361b675e96b3ee9";

    private boolean isloded = false;

    @Override
    public void showVideoAdvert(Activity activity, Yodo1VideoCallback callback) {
        this.videoCallback = callback;
        YLog.d("Mintegral  showVideoAdvert");
        if (mMvRewardVideoHandler !=null && mMvRewardVideoHandler.isReady()) {
            mMvRewardVideoHandler.show(AdConfigMobvista.RewardId);
        } else {
            callback.onAdError(Yodo1VideoCallback.ADVERT_ERROR_COMMON, "未成功预加载", getAdvertCode());
        }

        isloded = false;
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1VideoReloadCallback reloadCallback) {
        this.reloadCallback = reloadCallback;
        YLog.d("Mintegral   reloadVideoAdvert");
        if (mMvRewardVideoHandler != null){
            mMvRewardVideoHandler.load();
        }

    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return isloded;
    }

    @Override
    public void validateAdsAdapter(Activity activity) {
        AdvertCoreMobVista.getInstance().validateAdsAdapter(activity);

    }

    @Override
    public String getAdvertCode() {
        return AdConfigMobvista.CHANNEL_CODE;
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(Activity activity) {
        AdvertCoreMobVista.getInstance().init(activity);

        String RewardUnitId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd,
                AdConfigMobvista.CHANNEL_CODE,AdConfigMobvista.KEY_MOBVISTA_RewardUnitId);
        String RewardId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd,
                AdConfigMobvista.CHANNEL_CODE,AdConfigMobvista.KEY_MOBVISTA_RewardId);
//        RewardUnitId = "58394";
        if (TextUtils.isEmpty(RewardUnitId)){
            YLog.e("Mintegral  RewardUnitId未获取到");
            return;
        }
        YLog.i("Mintegral  RewardVideo  UniteId :  " +  RewardUnitId);
        mMvRewardVideoHandler = new MTGRewardVideoHandler(activity, RewardUnitId);
        mMvRewardVideoHandler.setRewardVideoListener(new RewardVideoListener() {

            @Override
            public void onVideoLoadSuccess(String s) {
                YLog.d("Mintegral  onVideoLoadSuccess");
                isloded = true;
                if(reloadCallback != null){
                    reloadCallback.onResult(Yodo1VideoReloadCallback.ADVERT_VIDEO_RELOAD_FINISH,getAdvertCode());
                }
            }

            @Override
            public void onLoadSuccess(String s) {
                YLog.d("Mintegral  onLoadSuccess");
            }

            @Override
            public void onVideoLoadFail(String s) {
                YLog.d("Mintegral  onVideoLoadFail ：" + s);
                if(reloadCallback != null){
                    reloadCallback.onResult(Yodo1VideoReloadCallback.ADVERT_VIDEO_RELOAD_FAILED,getAdvertCode());
                }
            }

            @Override
            public void onShowFail(String errorMsg) {
                YLog.d("Mintegral  onShowFail=" + errorMsg);
                if(videoCallback != null){
                    videoCallback.onAdError(Yodo1VideoCallback.ADVERT_EVENT_CLOSE, errorMsg, getAdvertCode());
                }
            }

            @Override
            public void onAdShow() {
                YLog.d("Mintegral  onAdShow");
                if(videoCallback != null){
                    videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_DISPLAY, getAdvertCode());
                }
            }

            @Override
            public void onAdClose(boolean isCompleteView, String RewardName, float RewardAmout) {
                YLog.d("Mintegral  reward info :" + "RewardName:  " + RewardName + "  RewardAmout: " + RewardAmout  + "  isCompleteView:   " + isCompleteView);
                if(isCompleteView){
                    if(videoCallback != null){
                        videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_FINISH, getAdvertCode());
                    }
                }
                if(videoCallback != null){
                    videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_CLOSE, getAdvertCode());
                }
            }

            @Override
            public void onVideoAdClicked(String unitId) {
                YLog.d("Mintegral  onVideoAdClicked");
                if(videoCallback != null){
                    videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_CLICK, getAdvertCode());
                }
            }

        });

    }

    @Override
    public void onStart(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }

    @Override
    public void onRestart(Activity activity) {

    }

    @Override
    public void onStop(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {

    }

    @Override
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {

    }

    @Override
    public void onNewIntent(Activity activity, Intent intent) {

    }
}
