package com.yodo1.advert.video;


public interface Yodo1VideoCallback {
	/** 用户关闭广告 */
	public static final int ADVERT_EVENT_CLOSE = 0;
	/** 用户点击广告 */
	public static final int ADVERT_EVENT_CLICK = 2;
	/** 广告已成功加载 */
	public static final int ADVERT_EVENT_LOADED = 3;
	/** 广告已展示 */
	public static final int ADVERT_EVENT_DISPLAY = 4;
	/** 广告已展示完成 */
	public static final int ADVERT_EVENT_FINISH = 5;
	/** 广告已展示 */
	public static final int ADVERT_EVENT_DISPLAY_FAILED  = 6;

	/** 广告调用发生异常 */
	public static final int ADVERT_ERROR_COMMON = 0;
	/** 该渠道不支持此类型广告 */
	public static final int ADVERT_ERROR_NO_SUPPORT = 1;
	/** 广告加载失败 */
	public static final int ADVERT_ERROR_LOADED_FAILED = 2;
	/** 没有广告量 */
	public static final int ADVERT_ERROR_NO_AD = 3;

	/**
	 * 事件回调
	 * @param eventCode 事件
	 * @param advertCode 渠道号
	 */
	public void onEvent(int eventCode, String advertCode);
	/**
	 * 错误回调
	 * @param errorCode 错误列表
	 * @param errorCode 错误信息
	 * @param advertCode 渠道号
	 */
	public void onAdError(int errorCode, String errorMsg, String advertCode);

}
