package com.yodo1.advert.utils;

import android.app.Activity;
import android.text.TextUtils;

import com.yodo1.advert.factory.Yodo1AdvertAdapterFactory;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.onlineconfig.Yodo1OnlineConfig;
import com.yodo1.sdk.kit.YLog;

import java.util.Locale;

/**
 * 在线参数获取工具
 * <p>
 * Created by yodo1 on 2016/3/18.
 */
public class YOnlineConfigUtils {
    private static String AdSwitchInChinese = "Platform_AdSwitchInChinese";//中文条件下广告开关
    private static String RequestPermisson = "Platform_RequestPermisson";//是否需要请求权限
    /**
     * 获取插屏广告的播放开关是否打开
     *
     * @return
     */
    public static boolean isTrunOnAdvertInterstitial() {
        String value = Yodo1OnlineConfigAgent.getActiveConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd);

        if (!TextUtils.isEmpty(value) && "on".equals((value.trim()).toLowerCase(Locale.getDefault()))) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * 获取游戏视频广告的播放开关是否打开
     *
     * @return
     */
    public static boolean isTrunOnAdvertVideo() {
        String value = Yodo1OnlineConfigAgent.getActiveConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd);
        if (!TextUtils.isEmpty(value) && "on".equals((value.trim()).toLowerCase(Locale.getDefault()))) {
            return true;
        } else {
            return false;
        }
    }


    /**
     * 获取Baner的播放开关是否打开
     *
     * @return
     */
    public static boolean isTrunOnAdvertBanner() {
        String value = Yodo1OnlineConfigAgent.getActiveConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd);
        if (!TextUtils.isEmpty(value) && "on".equals((value.trim()).toLowerCase(Locale.getDefault()))) {
            return true;
        } else {
            return false;
        }
    }



    /**
     * 获取插屏广告显示间隔
     * <p>
     * 在线参数单位为秒，但该方法会转为毫秒
     *
     * @return 返回毫秒
     */
    public static long getIntervalAdvertInterstitial() {
        String value = Yodo1OnlineConfigAgent.getIntervalConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd);

        if (!TextUtils.isEmpty(value)) {
            try {
                long time = Long.parseLong(value);
                return time * 1000;
            } catch (NumberFormatException e) {
                YLog.e("YOnlineConfigUtils, 获取插屏间隔失败 >>> 类型转换失败，请检查后台填写是否有错");
                e.printStackTrace();
            }
        }
        return 0;
    }


    /**
     * 获取插屏广告显示间隔
     * <p>
     * 在线参数单位为秒，但该方法会转为毫秒
     *
     * @return 返回毫秒
     */
    public static long getSwitchingCycle() {
        String value = Yodo1OnlineConfigAgent.getSwitchingCycleConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd);

        if (!TextUtils.isEmpty(value)) {
            try {
                long time = Long.parseLong(value);
                return time * 1000;
            } catch (NumberFormatException e) {
                YLog.e("YOnlineConfigUtils, 获取插屏间隔失败 >>> 类型转换失败，请检查后台填写是否有错");
                e.printStackTrace();
            }
        }
        return 30 * 1000;
    }




    /**
     * 获取中文环境下广告开关   如果该开关打开，表示只有在中文环境下才初始化
     * @return
     */
    public static boolean isTrunOnAdForChina(Activity activity){
        String value = Yodo1OnlineConfig.getInstance().getConfigParam(AdSwitchInChinese,"off");//默认关闭
        YLog.i("开关： " + value);
        if(!TextUtils.isEmpty(value) && "on".equals((value.trim()).toLowerCase(Locale.getDefault()))){//开关是否打开
            if (!activity.getResources().getConfiguration().locale.getCountry().equals("CN")){//开关已经打开 判断语言环境 中文打开
                return true;
            }
        }
        return false;
    }

    /**
     * 是否请求权限
     * @return
     */
    public static boolean isNeedRequestPermisson(){
        String value = Yodo1OnlineConfig.getInstance().getConfigParam(RequestPermisson,"off");//默认关闭
        if (!TextUtils.isEmpty(value) && "on".equals((value.trim()).toLowerCase(Locale.getDefault()))) {
            return true;
        } else {
            return false;
        }
    }
}
