/*
 * Decompiled with CFR 0.152.
 */
package com.uniplay.adsdk.utils;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.uniplay.adsdk.utils.DatabaseHelper;
import java.util.List;

public class DatabaseProvider {
    private Context context;
    private DatabaseHelper dbHelper = null;
    private static DatabaseProvider provider = null;

    private DatabaseProvider(Context context) {
        if (context == null) {
            return;
        }
        this.context = context.getApplicationContext();
        this.dbHelper = new DatabaseHelper(this.context);
    }

    public static synchronized DatabaseProvider getDBProvider(Context context) {
        if (provider == null) {
            provider = new DatabaseProvider(context);
        }
        return provider;
    }

    public synchronized Cursor query(String string, String[] stringArray, String string2, String[] stringArray2, String string3) {
        if (this.dbHelper == null) {
            return null;
        }
        Cursor cursor = null;
        try {
            SQLiteDatabase sQLiteDatabase = this.dbHelper.getWritableDatabase();
            cursor = sQLiteDatabase.query(string, stringArray, string2, stringArray2, null, null, string3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cursor;
    }

    public synchronized long insert(String string, ContentValues contentValues) {
        if (this.dbHelper == null) {
            return -1L;
        }
        long l2 = -1L;
        try {
            SQLiteDatabase sQLiteDatabase = this.dbHelper.getWritableDatabase();
            l2 = sQLiteDatabase.replace(string, null, contentValues);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long transactInsert(String string, List<ContentValues> list) {
        if (this.dbHelper == null) {
            return -1L;
        }
        SQLiteDatabase sQLiteDatabase = this.dbHelper.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        long l2 = -1L;
        try {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                l2 = sQLiteDatabase.insert(string, null, list.get(i2));
            }
            sQLiteDatabase.setTransactionSuccessful();
        }
        catch (Exception exception) {
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
        return l2;
    }

    public synchronized int delete(String string, String string2, String[] stringArray) {
        if (this.dbHelper == null) {
            return 0;
        }
        SQLiteDatabase sQLiteDatabase = this.dbHelper.getWritableDatabase();
        int n2 = 0;
        try {
            n2 = sQLiteDatabase.delete(string, string2, stringArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }

    public synchronized int update(String string, ContentValues contentValues, String string2, String[] stringArray) {
        if (this.dbHelper == null) {
            return 0;
        }
        int n2 = 0;
        try {
            SQLiteDatabase sQLiteDatabase = this.dbHelper.getWritableDatabase();
            n2 = sQLiteDatabase.update(string, contentValues, string2, stringArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return n2;
    }

    public synchronized void close() {
        if (this.dbHelper == null) {
            return;
        }
        this.dbHelper.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount(String string) {
        if (this.dbHelper == null) {
            return 0;
        }
        int n2 = 0;
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.dbHelper.getWritableDatabase();
            cursor = sQLiteDatabase.rawQuery("select count(*) from " + string, null);
            if (cursor.moveToNext()) {
                n2 = cursor.getInt(0);
            }
        }
        return n2;
    }
}

