/*
 * Decompiled with CFR 0.152.
 */
package com.uniplay.adsdk.utils.rsa;

import com.uniplay.adsdk.utils.rsa.CipherStrategy;
import com.uniplay.adsdk.utils.rsa.RSAUtils;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.PublicKey;

public class RSACipherStrategy
extends CipherStrategy {
    private PublicKey mPublicKey;
    private PrivateKey mPrivateKey;

    public void initPublicKey(String string) {
        try {
            this.mPublicKey = RSAUtils.loadPublicKey(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void initPublicKey(InputStream inputStream) {
        try {
            this.mPublicKey = RSAUtils.loadPublicKey(inputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void initPrivateKey(String string) {
        try {
            this.mPrivateKey = RSAUtils.loadPrivateKey(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void initPrivateKey(InputStream inputStream) {
        try {
            this.mPrivateKey = RSAUtils.loadPrivateKey(inputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public String encrypt(String string) {
        if (this.mPublicKey == null) {
            throw new NullPointerException("PublicKey is null, please init it first");
        }
        byte[] byArray = RSAUtils.encryptData(string.getBytes(), this.mPublicKey);
        return this.encodeConvert(byArray);
    }

    @Override
    public String decrypt(String string) {
        if (this.mPrivateKey == null) {
            throw new NullPointerException("PrivateKey is null, please init it first");
        }
        byte[] byArray = this.decodeConvert(string);
        byte[] byArray2 = RSAUtils.decryptData(byArray, this.mPrivateKey);
        return new String(byArray2);
    }
}

