/*
 * Decompiled with CFR 0.152.
 */
package com.uniplay.adsdk.utils;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.net.Uri;
import android.os.Build;
import android.support.v4.content.FileProvider;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.Toast;
import com.uniplay.adsdk.AppInfo;
import com.uniplay.adsdk.ClickParser;
import com.uniplay.adsdk.DownloadService;
import com.uniplay.adsdk.net.HttpUtil;
import com.uniplay.adsdk.net.TaskEntity;
import com.uniplay.adsdk.utils.Base64;
import com.uniplay.adsdk.utils.DatabaseUtils;
import com.uniplay.adsdk.utils.PreferencesHelper;
import com.uniplay.adsdk.utils.Record;
import com.uniplay.adsdk.utils.SDKLog;
import com.uniplay.adsdk.widget.CloseView;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import javax.crypto.Cipher;
import org.json.JSONException;
import org.json.JSONObject;

public class Utils {
    private static ThreadPoolExecutor mThreadPool = (ThreadPoolExecutor)Executors.newFixedThreadPool(2);
    private static final String KEY_ALGORITHM = "RSA";
    private static final int MAX_ENCRYPT_BLOCK = 240;

    public static boolean isDeepLink(String string) {
        return !Utils.isHttpUrl(string);
    }

    public static boolean isHttpUrl(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith("http:") || string.startsWith("https:");
    }

    public static boolean deviceCanHandleIntent(Context context, Intent intent) {
        try {
            PackageManager packageManager = context.getPackageManager();
            List list = packageManager.queryIntentActivities(intent, 0);
            return !list.isEmpty();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static ArrayList<String> string2List(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            SDKLog.e("info", "string2List:" + string);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "@@");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    public static String list2String(List<String> list) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            for (String string : list) {
                stringBuffer.append(string).append("@@");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    public static void showToast(Context context, String string) {
        Toast.makeText((Context)context, (CharSequence)string, (int)0).show();
    }

    public static byte[] getImage(String string) {
        try {
            URL uRL = new URL(string);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setReadTimeout(6000);
            InputStream inputStream = null;
            if (httpURLConnection.getResponseCode() == 200) {
                inputStream = httpURLConnection.getInputStream();
                byte[] byArray = Utils.readStream(inputStream);
                inputStream.close();
                return byArray;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static byte[] readStream(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        int n2 = -1;
        while ((n2 = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        byteArrayOutputStream.close();
        inputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private static String encryptByPublic(byte[] byArray, String string) {
        byte[] byArray2 = Base64.decode(string);
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray2);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(1, publicKey);
        int n2 = byArray.length;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n3 = 0;
        int n4 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (n2 - n3 > 0) {
            if (n2 - n3 > 240) {
                stringBuffer.append("str" + n4).append("=" + URLEncoder.encode(Base64.encode(cipher.doFinal(byArray, n3, 240))));
            } else {
                stringBuffer.append("str" + n4).append("=" + URLEncoder.encode(Base64.encode(cipher.doFinal(byArray, n3, n2 - n3))));
            }
            stringBuffer.append("&");
            n3 = ++n4 * 240;
        }
        stringBuffer.append("num=" + n4);
        stringBuffer.append("&");
        stringBuffer.append("encode=1");
        return stringBuffer.toString();
    }

    public static boolean apkExists(String string) {
        File file = new File(string);
        SDKLog.e("info", "exists:" + file.exists() + "");
        if (!file.exists()) {
            return false;
        }
        return string.contains(".apk") || string.contains(".ap") || !string.contains(".tmp");
    }

    public static void DeleteDownLoadContentFileByTimeInterval(Context context) {
        try {
            long l2 = PreferencesHelper.getInstance(context).getDelDirTime();
            if (l2 == 0L) {
                PreferencesHelper.getInstance(context).saveDelDirTime();
            }
            long l3 = PreferencesHelper.getInstance(context).getDelDirTime();
            long l4 = System.currentTimeMillis();
            SDKLog.e("info", "s-->" + (l4 - l3) + "   t-->" + 86400000);
            long l5 = (l4 - l3) / 86400000L;
            SDKLog.e("info", "s--->" + l5);
            if (l5 >= 1L) {
                File file = new File(DownloadService.DL_PATH);
                Utils.deleteDirWihtFile(file, false);
                PreferencesHelper.getInstance(context).saveDelDirTime();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void deleteDirWihtFile(File file, boolean bl) {
        if (file == null || !file.exists() || !file.isDirectory()) {
            return;
        }
        SDKLog.e("info:", "deleteDirWihtFile--->");
        for (File file2 : file.listFiles()) {
            if (file2.isFile()) {
                file2.delete();
                continue;
            }
            if (!file2.isDirectory()) continue;
            Utils.deleteDirWihtFile(file2, false);
        }
        if (bl) {
            file.delete();
        }
    }

    public static void deleteFile(File file) {
        SDKLog.e("info", "VurlMd5 deleteFile:" + file.toString());
        if (file == null || !file.exists()) {
            SDKLog.e("info:", "deleteFile--->\u6587\u4ef6\u4e0d\u5b58\u5728");
            return;
        }
        if (file.exists()) {
            file.delete();
        }
    }

    public static String getUrlFromDepLink(String string) {
        Uri uri = Uri.parse((String)string);
        Set set = Uri.parse((String)string).getQueryParameterNames();
        for (String string2 : set) {
            if (!string2.equals("params")) continue;
            List list = uri.getQueryParameters("params");
            SDKLog.e("info", list.toString());
            for (String string3 : list) {
                if (!string3.contains("url")) continue;
                JSONObject jSONObject = null;
                try {
                    jSONObject = new JSONObject(string3);
                    string = jSONObject.getString("url");
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
        }
        SDKLog.e("info", "getUrlFromDepLink:" + string);
        return string;
    }

    public static ArrayList<String> replaceClickId(ArrayList<String> arrayList, String string) {
        if (arrayList != null && !TextUtils.isEmpty((CharSequence)string)) {
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                String string2 = arrayList.get(i2);
                String string3 = string2.replaceAll("__CLICK_ID__", string);
                arrayList.set(i2, string3);
            }
            SDKLog.e("info", "replaceClickId-\u4e0a\u62a5\u4e8b\u4ef6\u66ff\u6362 ----:" + arrayList.toString());
        }
        return arrayList;
    }

    public static Bitmap rotateBitmap(Bitmap bitmap, float f2) {
        if (bitmap == null) {
            return null;
        }
        int n2 = bitmap.getWidth();
        int n3 = bitmap.getHeight();
        Matrix matrix = new Matrix();
        matrix.setRotate(f2);
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)n2, (int)n3, (Matrix)matrix, (boolean)false);
        if (bitmap2.equals(bitmap)) {
            return bitmap2;
        }
        bitmap.recycle();
        return bitmap2;
    }

    public static String saveBitmap(String string, Bitmap bitmap) {
        if (!new File(DownloadService.DL_PATH).exists()) {
            new File(DownloadService.DL_PATH).mkdirs();
        }
        File file = new File(DownloadService.DL_PATH + string + ".png");
        try {
            file.createNewFile();
        }
        catch (IOException iOException) {
            System.out.println("\u5728\u4fdd\u5b58\u56fe\u7247\u65f6\u51fa\u9519\uff1a" + iOException.toString());
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        try {
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fileOutputStream);
        }
        catch (Exception exception) {
            return "create_bitmap_error";
        }
        try {
            fileOutputStream.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return file.getAbsolutePath();
    }

    public static ArrayList<String> mergeList(ArrayList<String> arrayList, ArrayList<String> arrayList2) {
        ArrayList<String> arrayList3 = new ArrayList<String>();
        if (arrayList != null) {
            arrayList3.addAll(arrayList);
        }
        if (arrayList2 != null) {
            arrayList3.addAll(arrayList2);
        }
        return new ArrayList<String>(new HashSet(arrayList3));
    }

    public static ArrayList<String> filterClickData(ArrayList<String> arrayList, ArrayList<String> arrayList2) {
        ArrayList<Object> arrayList3 = new ArrayList<String>();
        if (arrayList2 != null && !arrayList2.isEmpty()) {
            arrayList3 = arrayList2;
        }
        if (arrayList != null) {
            arrayList3.addAll(arrayList);
        }
        for (int i2 = 0; i2 < arrayList3.size(); ++i2) {
            if (!arrayList2.toString().contains((CharSequence)arrayList3.get(i2))) continue;
            arrayList3.remove(i2);
        }
        return new ArrayList<Object>(new HashSet<Object>(arrayList3));
    }

    public static ArrayList<String> filterImpData(ArrayList<String> arrayList, ArrayList<String> arrayList2) {
        ArrayList<String> arrayList3 = new ArrayList<String>();
        if (arrayList2 != null && !arrayList2.isEmpty()) {
            arrayList3 = arrayList2;
        }
        if (arrayList != null) {
            arrayList3.addAll(arrayList);
        }
        ArrayList<String> arrayList4 = new ArrayList<String>(new HashSet(arrayList3));
        for (int i2 = 0; i2 < arrayList4.size(); ++i2) {
            if (!arrayList2.toString().contains(arrayList4.get(i2))) continue;
            arrayList4.remove(i2);
            --i2;
        }
        return arrayList4;
    }

    public static String changeFilePath(String string) {
        int n2;
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        if (string.contains(".apk") && (n2 = string.indexOf(".apk")) > 0) {
            string = string.substring(0, n2 + 3);
        }
        SDKLog.e("info", "apkfile_path-changeFilePath:" + string);
        return string;
    }

    public static Intent getIntent(Context context, String string, Intent intent) {
        String string2 = string.toString();
        if (Build.VERSION.SDK_INT >= 24) {
            int n2;
            if (!TextUtils.isEmpty((CharSequence)string2) && (n2 = string2.toString().indexOf(".apk")) > 0) {
                string2 = string2.substring(0, n2 + 4);
            }
            SDKLog.e("info", "apkfile_path-getIntent-replace:" + string2);
            try {
                Uri uri = FileProvider.getUriForFile((Context)context, (String)(AppInfo.packageName + ".uniplay.fileprovider"), (File)new File(string2));
                SDKLog.e("info", "apkfile_path-getIntent-apkUri:" + uri);
                intent.addFlags(0x10000000);
                intent.addFlags(1);
                intent.setDataAndType(uri, "application/vnd.android.package-archive");
            }
            catch (Throwable throwable) {
                try {
                    Log.e((String)"Utils", (String)("getIntent: .uniplay.fileprovider_err ,geturifor_.fileprovider:" + throwable.getMessage()));
                    Uri uri = FileProvider.getUriForFile((Context)context, (String)(AppInfo.packageName + ".fileprovider"), (File)new File(string2));
                    SDKLog.e("info", "apkfile_path-getIntent-apkUri:" + uri);
                    intent.addFlags(0x10000000);
                    intent.addFlags(1);
                    intent.setDataAndType(uri, "application/vnd.android.package-archive");
                }
                catch (Throwable throwable2) {
                    Log.e((String)"Utils", (String)("getIntent: .fileprovider_err :" + throwable2.getMessage()));
                }
            }
        } else {
            intent.addFlags(0x10000000);
            intent.setDataAndType(Uri.parse((String)("file://" + string.toString())), "application/vnd.android.package-archive");
        }
        return intent;
    }

    public static int getBtnsz(int n2, int n3, float f2) {
        if (n3 > 25 && n3 <= 36) {
            n2 = (int)((float)n3 * f2);
        }
        return n2;
    }

    public static String isValidApk(String string, Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageArchiveInfo(string, 0);
            if (packageInfo != null) {
                return packageInfo.packageName;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "";
    }

    public static boolean isApplicationAvilible(Context context, String string) {
        SDKLog.e("info", "isApplicationAvilible_pkgname:" + string);
        PackageManager packageManager = context.getPackageManager();
        List list = packageManager.getInstalledPackages(0);
        if (list != null) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                String string2 = ((PackageInfo)list.get((int)i2)).packageName;
                if (!string.equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isDownloaded(String string, Record record) {
        SDKLog.e("info", "isDownloaded-filepath:" + record.getFilePath());
        if (TextUtils.isEmpty((CharSequence)record.getFilePath())) {
            return false;
        }
        SDKLog.e("info", "isDownloaded-filepath:" + record.getFilePath());
        if (!Utils.apkExists(record.getFilePath())) {
            return false;
        }
        SDKLog.e("info", "isDownloaded-filepath:" + !Utils.apkExists(record.getFilePath()));
        return true;
    }

    public static void silentInstall(Context context, String string, File file) {
        try {
            Intent intent = new Intent();
            intent.setClassName("com.ktouch.tycushotapps", "com.yingyonghui.market.service.SilentInstallService");
            if (string != null) {
                intent.putExtra("installing_apk_title", string);
            }
            intent.putExtra("com.yingyonghui.market", "com.ktouch.tycushotapps");
            intent.putExtra("installing_apk_path", file.getAbsolutePath());
            context.startService(intent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isTYSilentInstallServiceExists(Context context) {
        boolean bl = true;
        ApplicationInfo applicationInfo = null;
        try {
            applicationInfo = context.getPackageManager().getApplicationInfo("cn.ktouch.silentinstall", 4);
        }
        catch (Exception exception) {
            applicationInfo = null;
            return false;
        }
        bl = applicationInfo != null;
        return bl;
    }

    public static String getDate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return simpleDateFormat.format(new Date());
    }

    public static String getDate(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        return simpleDateFormat.format(new Date());
    }

    public static boolean isAPK(String string) {
        try {
            String string2 = Uri.parse((String)string).getPath().toLowerCase();
            if (string2.endsWith(".apk") || string.endsWith(".apk")) {
                return true;
            }
            if (string.contains("&s={\"down_x\":") && string.contains("down_y") && string.contains("up_x") && string.contains("up_y")) {
                String string3 = Uri.parse((String)string).getPath().toLowerCase();
                if (string3.endsWith(".apk")) {
                    return true;
                }
                String string4 = string.substring(0, string.indexOf("&s={\"down_x\":"));
                SDKLog.e("info", string4);
                if (string4.endsWith(".apk")) {
                    return true;
                }
                String string5 = Uri.parse((String)string4).getPath().toLowerCase();
                if (string5.endsWith(".apk")) {
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static boolean isOneHours(String string, String string2, int n2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-M-d HH:mm:ss");
        SDKLog.e("info", "\u683c\u5f0f\u5316\u6210\u5c0f\u65f6-o_date:" + string);
        SDKLog.e("info", "\u683c\u5f0f\u5316\u6210\u5c0f\u65f6-now_date:" + string2);
        Date date = simpleDateFormat.parse(string);
        Date date2 = simpleDateFormat.parse(string2);
        long l2 = date2.getTime() - date.getTime();
        double d2 = (double)l2 * 1.0 / 3600000.0;
        SDKLog.e("info", "\u683c\u5f0f\u5316\u6210\u5c0f\u65f6:" + d2);
        return d2 <= (double)n2;
    }

    public static boolean stringIsEmpty(String string) {
        return null == string || string.isEmpty() || string.equals("null");
    }

    public static void CheckgetReportTaskd(Context context) {
        try {
            ArrayList<Record> arrayList = DatabaseUtils.getRecentRecords(context.getApplicationContext());
            for (Record record : arrayList) {
                String string;
                if (record == null || Utils.stringIsEmpty(record.getPkgName()) || !Utils.isApplicationAvilible(context, record.getPkgName())) continue;
                PackageManager packageManager = context.getApplicationContext().getPackageManager();
                PackageInfo packageInfo = packageManager.getPackageInfo(record.getPkgName(), 0);
                long l2 = packageInfo.firstInstallTime + 240000L;
                long l3 = System.currentTimeMillis() - l2;
                SDKLog.e("info", "system time : " + (System.currentTimeMillis() - l2));
                if (l3 >= 0L) continue;
                PreferencesHelper preferencesHelper = PreferencesHelper.getInstance(context);
                String string2 = preferencesHelper.getInstallsucc(record.getUrl());
                if (!Utils.stringIsEmpty(string2)) {
                    Utils.sendTrack(context, Utils.string2List(string2), record, "Installsucc");
                }
                if (Utils.stringIsEmpty(string = preferencesHelper.getAppactive(record.getUrl()))) continue;
                Utils.sendTrack(context, Utils.string2List(string), record, "Appactive");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static View getDrawCloseView(final Activity activity, int n2) {
        if (n2 < 25 || n2 > 36) {
            n2 = 26;
        }
        RelativeLayout relativeLayout = new RelativeLayout((Context)activity);
        int n3 = (int)TypedValue.applyDimension((int)1, (float)(n2 + 44), (DisplayMetrics)activity.getResources().getDisplayMetrics());
        int n4 = (int)TypedValue.applyDimension((int)1, (float)(n2 - 8), (DisplayMetrics)activity.getResources().getDisplayMetrics());
        relativeLayout.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(n3, n3));
        CloseView closeView = new CloseView((Context)activity);
        closeView.setPadding(n4, n4, n4, n4);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        closeView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        relativeLayout.addView((View)closeView);
        relativeLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (!activity.isFinishing()) {
                    activity.finish();
                }
            }
        });
        return relativeLayout;
    }

    public static void sendTrack(final Context context, ArrayList<String> arrayList, final Record record, final String string) {
        try {
            if (null == arrayList || arrayList.isEmpty()) {
                return;
            }
            for (String string2 : arrayList) {
                SDKLog.e("info", "sendTrack-\u4e0a\u62a5 url:" + string2 + " pkg:" + record.getUrl());
                HttpUtil.AddTaskToQueueHead(string2, 260, new ClickParser(), new TaskEntity.OnResultListener(){

                    @Override
                    public void onResult(Object object) {
                        TaskEntity taskEntity = (TaskEntity)object;
                        SDKLog.e("info", "sendTrack-\u4e0a\u62a5 \u6210\u529furl:" + taskEntity.baseUrl);
                        if (!Utils.stringIsEmpty(string)) {
                            ArrayList<String> arrayList;
                            PreferencesHelper preferencesHelper = PreferencesHelper.getInstance(context);
                            if (string.equals("Installsucc") && !Utils.stringIsEmpty(preferencesHelper.getInstallsucc(record.getUrl())) && null != (arrayList = Utils.string2List(preferencesHelper.getInstallsucc(record.getUrl()))) && !arrayList.isEmpty() && arrayList.contains(taskEntity.baseUrl)) {
                                arrayList.remove(taskEntity.baseUrl);
                                preferencesHelper.savaInstallsucc(record.getUrl(), Utils.list2String(arrayList));
                                SDKLog.e(this.getClass().getName(), "sendTrack-\u4e0a\u62a5\u6210\u529f\u540e\u5220\u9664\u4e0a\u62a5\u5730\u5740:" + preferencesHelper.getInstallsucc(record.getUrl()));
                            }
                            if (string.equals("Appactive") && !Utils.stringIsEmpty(preferencesHelper.getAppactive(record.getUrl())) && null != (arrayList = Utils.string2List(preferencesHelper.getAppactive(record.getUrl()))) && !arrayList.isEmpty() && arrayList.contains(taskEntity.baseUrl)) {
                                arrayList.remove(taskEntity.baseUrl);
                                preferencesHelper.savaAppactive(record.getUrl(), Utils.list2String(arrayList));
                                SDKLog.e(this.getClass().getName(), "sendTrack-\u4e0a\u62a5\u6210\u529f\u540e\u5220\u9664\u4e0a\u62a5\u5730\u5740:" + preferencesHelper.getAppactive(record.getUrl()));
                            }
                        }
                    }

                    @Override
                    public void onError(Object object) {
                        SDKLog.e("info", "sendTrack-\u4e0a\u62a5 \u5931\u8d25:");
                    }
                });
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static String replaceXY(String string, float f2, float f3, float f4, float f5, String string2) {
        SDKLog.e(string2, "\u66ff\u6362\u524d-\u5750\u6807" + f2 + ":" + f3 + ":" + f4 + ";" + f5 + "url:" + string);
        string = string.replaceAll("__DWXY__", f2 + "x" + f3).replaceAll("__UPXY__", f4 + "x" + f5);
        return string.replaceAll("IT_CLK_PNT_DOWN_X", f2 + "").replaceAll("IT_CLK_PNT_DOWN_Y", f3 + "").replaceAll("IT_CLK_PNT_UP_X", f4 + "").replaceAll("IT_CLK_PNT_UP_Y", f5 + "");
    }
}

