/*
 * Decompiled with CFR 0.152.
 */
package com.uniplay.adsdk.utils;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.text.TextUtils;
import com.uniplay.adsdk.DeviceInfo;
import com.uniplay.adsdk.utils.DatabaseProvider;
import com.uniplay.adsdk.utils.Record;
import com.uniplay.adsdk.utils.SDKLog;
import java.util.ArrayList;

public class DatabaseUtils {
    public static synchronized long insertRecord(Context context, Record record) {
        if (record == null) {
            return -1L;
        }
        DatabaseProvider databaseProvider = DatabaseProvider.getDBProvider(context);
        String[] stringArray = new String[]{record.getUrl()};
        Cursor cursor = databaseProvider.query("table_records", new String[]{"_id"}, "url=?", stringArray, null);
        if (cursor != null) {
            int n2 = -1;
            while (cursor.moveToNext()) {
                n2 = cursor.getInt(0);
            }
            if (cursor != null) {
                cursor.close();
            }
            if (n2 != -1) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("url", record.getUrl());
                if (!TextUtils.isEmpty((CharSequence)record.getPkgName())) {
                    contentValues.put("pkgName", record.getPkgName());
                }
                contentValues.put("cname", record.getCname());
                contentValues.put("iaction", record.getIaction());
                contentValues.put("md5", record.getApkmd5());
                contentValues.put("downsucc", record.getDownsucc());
                contentValues.put("installsucc", record.getInstallsucc());
                contentValues.put("appactive", record.getAppactive());
                contentValues.put("sin", Integer.valueOf(record.getSin()));
                contentValues.put("rpt", Integer.valueOf(record.getRpt()));
                contentValues.put("appname", record.getAppname());
                contentValues.put("appicon", record.getAppicon());
                int n3 = databaseProvider.update("table_records", contentValues, "_id=" + n2, null);
                SDKLog.e("DatabaseUtils:insertRecord --> update ", "id " + n2 + " count " + n3);
                return n2;
            }
            ContentValues contentValues = new ContentValues();
            contentValues.put("url", record.getUrl());
            if (!TextUtils.isEmpty((CharSequence)record.getPkgName())) {
                contentValues.put("pkgName", record.getPkgName());
            }
            contentValues.put("cname", record.getCname());
            contentValues.put("iaction", record.getIaction());
            contentValues.put("md5", record.getApkmd5());
            contentValues.put("downsucc", record.getDownsucc());
            contentValues.put("installsucc", record.getInstallsucc());
            contentValues.put("appactive", record.getAppactive());
            contentValues.put("sin", Integer.valueOf(record.getSin()));
            contentValues.put("rpt", Integer.valueOf(record.getRpt()));
            contentValues.put("appname", record.getAppname());
            contentValues.put("appicon", record.getAppicon());
            contentValues.put("dayOfYear", Integer.valueOf(record.getDayofyear()));
            long l2 = databaseProvider.insert("table_records", contentValues);
            SDKLog.e("DatabaseUtils:insertRecord --> insert ", "retId " + l2);
            return l2;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("url", record.getUrl());
        if (!TextUtils.isEmpty((CharSequence)record.getPkgName())) {
            contentValues.put("pkgName", record.getPkgName());
        }
        contentValues.put("cname", record.getCname());
        contentValues.put("iaction", record.getIaction());
        contentValues.put("md5", record.getApkmd5());
        contentValues.put("downsucc", record.getDownsucc());
        contentValues.put("installsucc", record.getInstallsucc());
        contentValues.put("appactive", record.getAppactive());
        contentValues.put("sin", Integer.valueOf(record.getSin()));
        contentValues.put("rpt", Integer.valueOf(record.getRpt()));
        contentValues.put("appname", record.getAppname());
        contentValues.put("appicon", record.getAppicon());
        contentValues.put("dayOfYear", Integer.valueOf(record.getDayofyear()));
        long l3 = databaseProvider.insert("table_records", contentValues);
        SDKLog.e("DatabaseUtils:insertRecord --> else insert ", "retId " + l3);
        return l3;
    }

    public static synchronized long updateRecord(Context context, Record record, long l2) {
        if (record == null) {
            return -1L;
        }
        DatabaseProvider databaseProvider = DatabaseProvider.getDBProvider(context);
        String[] stringArray = new String[]{String.valueOf(l2)};
        Cursor cursor = databaseProvider.query("table_records", new String[]{"_id"}, "_id=?", stringArray, null);
        if (cursor != null) {
            ContentValues contentValues = new ContentValues();
            if (!TextUtils.isEmpty((CharSequence)record.getPkgName())) {
                contentValues.put("pkgName", record.getPkgName());
            }
            contentValues.put("filePath", record.getFilePath());
            contentValues.put("dayOfYear", Integer.valueOf(record.getDayofyear()));
            int n2 = databaseProvider.update("table_records", contentValues, "_id=" + l2, null);
            SDKLog.e("DatabaseUtils:insertRecord --> updateRecord ", record.getFilePath() + " id " + l2 + " count " + n2 + record.getPkgName());
            return l2;
        }
        return -1L;
    }

    public static synchronized ArrayList<Record> getRptRecord(Context context) {
        DatabaseProvider databaseProvider = DatabaseProvider.getDBProvider(context);
        String[] stringArray = new String[]{String.valueOf(1)};
        Cursor cursor = databaseProvider.query("table_records", new String[]{"_id", "url", "pkgName", "filePath", "cname", "iaction", "md5", "downsucc", "installsucc", "appactive", "sin", "rpt", "dayOfYear", "deltimes", "appname", "appicon"}, "rpt = ? and deltimes <= 2 ", stringArray, null);
        ArrayList<Record> arrayList = new ArrayList<Record>();
        while (cursor != null && cursor.moveToNext()) {
            if (cursor.getInt(0) == -1) continue;
            Record record = new Record();
            record.setId(cursor.getLong(0));
            record.setUrl(cursor.getString(1));
            record.setPkgName(cursor.getString(2));
            record.setFilePath(cursor.getString(3));
            record.setCname(cursor.getString(4));
            record.setIaction(cursor.getString(5));
            record.setApkmd5(cursor.getString(6));
            record.setDownsucc(cursor.getString(7));
            record.setInstallsucc(cursor.getString(8));
            record.setAppactive(cursor.getString(9));
            record.setSin(cursor.getInt(10));
            record.setRpt(cursor.getInt(11));
            record.setDayofyear(cursor.getInt(12));
            record.setDelTimes(cursor.getInt(13));
            record.setAppname(cursor.getString(14));
            record.setAppicon(cursor.getString(15));
            arrayList.add(record);
        }
        if (cursor != null) {
            cursor.close();
        }
        return arrayList;
    }

    public static synchronized ArrayList<Record> getRecentRecords(Context context) {
        DatabaseProvider databaseProvider = DatabaseProvider.getDBProvider(context);
        String[] stringArray = new String[]{String.valueOf(DeviceInfo.getToday())};
        Cursor cursor = databaseProvider.query("table_records", new String[]{"_id", "url", "pkgName", "filePath", "cname", "iaction", "md5", "downsucc", "installsucc", "appactive", "sin", "rpt", "dayOfYear", "appname", "appicon"}, "dayOfYear = ? ", stringArray, null);
        ArrayList<Record> arrayList = new ArrayList<Record>();
        while (cursor != null && cursor.moveToNext()) {
            if (cursor.getInt(0) == -1) continue;
            Record record = new Record();
            record.setId(cursor.getLong(0));
            record.setUrl(cursor.getString(1));
            record.setPkgName(cursor.getString(2));
            record.setFilePath(cursor.getString(3));
            record.setCname(cursor.getString(4));
            record.setIaction(cursor.getString(5));
            record.setApkmd5(cursor.getString(6));
            record.setDownsucc(cursor.getString(7));
            record.setInstallsucc(cursor.getString(8));
            record.setAppactive(cursor.getString(9));
            record.setSin(cursor.getInt(10));
            record.setRpt(cursor.getInt(11));
            record.setDayofyear(cursor.getInt(12));
            record.setAppname(cursor.getString(13));
            record.setAppicon(cursor.getString(14));
            arrayList.add(record);
        }
        if (cursor != null) {
            cursor.close();
        }
        return arrayList;
    }

    public static synchronized Record getRecord(Context context, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        DatabaseProvider databaseProvider = DatabaseProvider.getDBProvider(context);
        String[] stringArray = new String[]{String.valueOf(string)};
        Cursor cursor = databaseProvider.query("table_records", new String[]{"_id", "url", "pkgName", "filePath", "cname", "iaction", "md5", "downsucc", "installsucc", "appactive", "sin", "rpt", "dayOfYear"}, "url=?", stringArray, null);
        Record record = null;
        while (cursor != null && cursor.moveToNext()) {
            if (cursor.getInt(0) == -1) continue;
            record = new Record();
            record.setUrl(cursor.getString(1));
            record.setPkgName(cursor.getString(2));
            record.setFilePath(cursor.getString(3));
            record.setCname(cursor.getString(4));
            record.setIaction(cursor.getString(5));
            record.setApkmd5(cursor.getString(6));
            record.setDownsucc(cursor.getString(7));
            record.setInstallsucc(cursor.getString(8));
            record.setAppactive(cursor.getString(9));
            record.setSin(cursor.getInt(10));
            record.setRpt(cursor.getInt(11));
            record.setDayofyear(cursor.getInt(12));
        }
        if (cursor != null) {
            cursor.close();
        }
        return record;
    }

    public static synchronized void updateTaskid(Context context, long l2, int n2) {
        DatabaseProvider databaseProvider = DatabaseProvider.getDBProvider(context);
        ContentValues contentValues = new ContentValues();
        contentValues.put("deltimes", Integer.valueOf(n2));
        int n3 = databaseProvider.update("table_records", contentValues, "_id=" + l2, null);
        SDKLog.e(" doll", "updateTaskid " + n3);
    }

    public static synchronized void updateDayOfYear(Context context, ArrayList<Long> arrayList) {
        DatabaseProvider databaseProvider = DatabaseProvider.getDBProvider(context);
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("dayOfYear", Integer.valueOf(DeviceInfo.getToday()));
            int n2 = databaseProvider.update("table_records", contentValues, "_id=" + arrayList.get(i2), null);
            SDKLog.e(" doll", "updateDayOfYear " + n2);
        }
    }

    public static synchronized Record getRecordById(Context context, long l2) {
        if (l2 == -1L) {
            return null;
        }
        DatabaseProvider databaseProvider = DatabaseProvider.getDBProvider(context);
        String[] stringArray = new String[]{String.valueOf(l2)};
        Cursor cursor = databaseProvider.query("table_records", new String[]{"_id", "url", "pkgName", "filePath", "cname", "iaction", "md5", "downsucc", "installsucc", "appactive", "sin", "rpt", "dayOfYear", "appname", "appicon"}, "_id=?", stringArray, null);
        Record record = null;
        while (cursor != null && cursor.moveToNext()) {
            if (cursor.getInt(0) == -1) continue;
            record = new Record();
            record.setUrl(cursor.getString(1));
            record.setPkgName(cursor.getString(2));
            record.setFilePath(cursor.getString(3));
            record.setCname(cursor.getString(4));
            record.setIaction(cursor.getString(5));
            record.setApkmd5(cursor.getString(6));
            record.setDownsucc(cursor.getString(7));
            record.setInstallsucc(cursor.getString(8));
            record.setAppactive(cursor.getString(9));
            record.setSin(cursor.getInt(10));
            record.setRpt(cursor.getInt(11));
            record.setDayofyear(cursor.getInt(12));
            record.setAppname(cursor.getString(13));
            record.setAppicon(cursor.getString(14));
        }
        if (cursor != null) {
            cursor.close();
        }
        return record;
    }

    public static synchronized Record getRecordByPkg(Context context, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        DatabaseProvider databaseProvider = DatabaseProvider.getDBProvider(context);
        String[] stringArray = new String[]{String.valueOf(string)};
        Cursor cursor = databaseProvider.query("table_records", new String[]{"_id", "url", "pkgName", "filePath", "cname", "iaction", "md5", "downsucc", "installsucc", "appactive", "sin", "rpt", "dayOfYear", "appname", "appicon"}, "pkgName=?", stringArray, null);
        Record record = null;
        while (cursor != null && cursor.moveToNext()) {
            if (cursor.getInt(0) == -1) continue;
            record = new Record();
            record.setUrl(cursor.getString(1));
            record.setPkgName(cursor.getString(2));
            record.setFilePath(cursor.getString(3));
            record.setCname(cursor.getString(4));
            record.setIaction(cursor.getString(5));
            record.setApkmd5(cursor.getString(6));
            record.setDownsucc(cursor.getString(7));
            record.setInstallsucc(cursor.getString(8));
            record.setAppactive(cursor.getString(9));
            record.setSin(cursor.getInt(10));
            record.setRpt(cursor.getInt(11));
            record.setDayofyear(cursor.getInt(12));
            record.setAppname(cursor.getString(13));
            record.setAppicon(cursor.getString(14));
        }
        if (cursor != null) {
            cursor.close();
        }
        return record;
    }
}

