/*
 * Decompiled with CFR 0.152.
 */
package com.uniplay.adsdk;

import android.content.Context;
import android.os.Environment;
import android.util.Log;
import com.mi.adtracker.MiAdTracker;
import com.uniplay.adsdk.AppInfo;
import com.uniplay.adsdk.ConfigureModule;
import com.uniplay.adsdk.DeviceInfo;
import com.uniplay.adsdk.GeoInfo;
import com.uniplay.adsdk.utils.PreferencesHelper;
import com.uniplay.adsdk.utils.SDKLog;
import com.uniplay.adsdk.utils.Utils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class AdManager {
    private static AdManager instance = new AdManager();
    private boolean isInited = false;
    public static long interstLastUpdate;
    public static long splashLastUpdate;

    public static AdManager getInstance() {
        return instance;
    }

    protected void finalize() {
        super.finalize();
    }

    public void initAdManager(Context context, String string) {
        try {
            File file;
            if (this.isInited && DeviceInfo.device != null) {
                return;
            }
            try {
                file = new File(Environment.getExternalStorageDirectory().toString() + File.separator + "Uniplay");
                if (file.exists()) {
                    long l2 = file.lastModified();
                    SDKLog.e("AdManager", "file create time:" + l2 + "  format_time:" + new SimpleDateFormat("yyyy-MM-dd").format(new Date(l2)));
                    long l3 = System.currentTimeMillis();
                    SDKLog.e("AdManager", "nowTime:" + l2 + "  format_nowTime:" + new SimpleDateFormat("yyyy-MM-dd").format(new Date(l3)));
                    long l4 = (l3 - l2) / 86400000L;
                    SDKLog.e("AdManager", "interval day:" + l4);
                    if (l4 > 16L) {
                        Utils.deleteDirWihtFile(file, true);
                    }
                }
            }
            catch (Throwable throwable) {
                Log.e((String)"AdManager", (String)"change filepath err ");
            }
            file = new File(Environment.getExternalStorageDirectory().toString() + File.separator + "Uniplay/Data/");
            if (!file.exists()) {
                file.mkdirs();
            }
            if (!(file = new File(Environment.getExternalStorageDirectory().toString() + File.separator + "Uniplay/Download/")).exists()) {
                file.mkdirs();
            }
            GeoInfo.initGeoInfo(context);
            AppInfo.initAppInfo(context);
            DeviceInfo.initDeviceInfo(context);
            ConfigureModule.initConfigModule(context, string);
            PreferencesHelper.getInstance(context).saveAppid(string);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            if (ConfigureModule.getConfigureData("", "c").toString().equals("mi")) {
                MiAdTracker.trackInit((Context)context, (String)"miad2016wanzhuan");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.isInited = true;
    }

    public static void trackRequestAd() {
        try {
            if (ConfigureModule.getConfigureData("", "c").toString().equals("mi")) {
                MiAdTracker.trackRequestAd();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static void trackShowAd() {
        try {
            if (ConfigureModule.getConfigureData("", "c").toString().equals("mi")) {
                MiAdTracker.trackShowAd();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static void trackFetchedAd() {
        try {
            if (ConfigureModule.getConfigureData("", "c").toString().equals("mi")) {
                MiAdTracker.trackFetchedAd();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

