/*
 * Decompiled with CFR 0.152.
 */
package com.ksc.ad.sdk.plugin;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.util.Log;
import com.ksc.ad.sdk.IKsyunAdApi;
import com.ksc.ad.sdk.PluginActivityInterface;
import com.ksc.ad.sdk.PluginServiceInterface;
import com.ksc.ad.sdk.R;
import com.ksc.ad.sdk.util.KsyunFileUtils;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class KsyunPluginManager {
    private static final String DEX = "dex";
    private static final String SDK_PROXY_CLASS = "com.ksc.ad.plugin.KsyunAdSdkProxy";
    private static final String PLUGIN_MIPMAP = "com.ksc.ad.plugin.R$mipmap";
    private static final String SDK_PROXY_GET_INSTANCE_METHOD = "getInstance";
    private static volatile KsyunPluginManager mInstance;
    private static Context mApplicationContext;
    private String mDexOutputPath;
    private DexClassLoader mPluginClassLoader;
    private Resources mPluginResources;
    private AssetManager mAssetManager;
    private PackageInfo mPackageInfo;
    private static final String SERVICE_NAME = "com.ksc.ad.plugin.service.PluginService";

    private KsyunPluginManager(Context context) {
        mApplicationContext = context.getApplicationContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KsyunPluginManager getInstance(Context context) {
        KsyunPluginManager ksyunPluginManager = mInstance;
        if (null != ksyunPluginManager) return ksyunPluginManager;
        Class<KsyunPluginManager> clazz = KsyunPluginManager.class;
        synchronized (KsyunPluginManager.class) {
            ksyunPluginManager = mInstance;
            if (null != ksyunPluginManager) return ksyunPluginManager;
            mInstance = ksyunPluginManager = new KsyunPluginManager(context);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ksyunPluginManager;
        }
    }

    public Resources getPluginResource() {
        return this.mPluginResources;
    }

    public AssetManager getAssetManager() {
        return this.mAssetManager;
    }

    public DexClassLoader getPluginClassLoader() {
        return this.mPluginClassLoader;
    }

    public void loadPlugin(Context context, final PluginManagerListener pluginManagerListener) {
        KsyunFileUtils.fetchPlugin(context, new KsyunFileUtils.FileOperationListener(){

            @Override
            public void onFileOperateSuccess(String string) {
                Log.d((String)"ad_trace", (String)("init: " + string));
                KsyunPluginManager.this.loadPluginManager(string);
                if (null != pluginManagerListener) {
                    pluginManagerListener.onLoadPluginSuccess();
                }
            }

            @Override
            public void onFileOperateFailure(int n2, String string) {
                if (null != pluginManagerListener) {
                    pluginManagerListener.onLoadPluginFailure(n2, string);
                }
            }
        });
    }

    private void loadPluginManager(String string) {
        this.getPluginPackageInfo(string);
        this.getPluginDexClassLoader(string);
        this.getPluginResource(string);
    }

    private void getPluginPackageInfo(String string) {
        if (null != this.mPackageInfo) {
            Log.d((String)"ad_trace", (String)"init: mPackageInfo!=null");
            return;
        }
        this.mPackageInfo = mApplicationContext.getPackageManager().getPackageArchiveInfo(string, 5);
    }

    private void getPluginResource(String string) {
        if (null != this.mPluginResources) {
            Log.d((String)"ad_trace", (String)"init: mPluginResources!=null");
            return;
        }
        try {
            AssetManager assetManager = (AssetManager)AssetManager.class.newInstance();
            Method method = assetManager.getClass().getMethod("addAssetPath", String.class);
            method.invoke((Object)assetManager, string);
            this.mAssetManager = assetManager;
            Resources resources = mApplicationContext.getResources();
            this.mPluginResources = new Resources(assetManager, resources.getDisplayMetrics(), resources.getConfiguration());
        }
        catch (Exception exception) {
            Log.e((String)"ad_trace", (String)"AssetManager addAssetPath method is not found");
            exception.printStackTrace();
        }
    }

    private void getPluginDexClassLoader(String string) {
        if (null != this.mPluginClassLoader) {
            Log.d((String)"ad_trace", (String)"init: mPluginClassLoader!=null");
            return;
        }
        File file = mApplicationContext.getDir(DEX, 0);
        this.mDexOutputPath = file.getAbsolutePath();
        this.mPluginClassLoader = new DexClassLoader(string, this.mDexOutputPath, null, mApplicationContext.getClassLoader());
    }

    public IKsyunAdApi getPluginSdkProxy() {
        IKsyunAdApi iKsyunAdApi = null;
        try {
            if (null != this.mPluginClassLoader) {
                Class clazz = this.mPluginClassLoader.loadClass(SDK_PROXY_CLASS);
                Method method = clazz.getMethod(SDK_PROXY_GET_INSTANCE_METHOD, new Class[0]);
                iKsyunAdApi = (IKsyunAdApi)method.invoke(null, new Object[0]);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.e((String)"ad_trace", (String)"getPluginSdkProxy caused ClassNotFoundException");
            classNotFoundException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.e((String)"ad_trace", (String)"getPluginSdkProxy caused IllegalAccessException");
            illegalAccessException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        return iKsyunAdApi;
    }

    public Drawable getPluginDrawable(String string) {
        try {
            Class clazz = this.mPluginClassLoader.loadClass(PLUGIN_MIPMAP);
            Field field = clazz.getDeclaredField(string);
            int n2 = field.getInt(R.id.class);
            return this.getPluginResource().getDrawable(n2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        return null;
    }

    public PluginActivityInterface getPluginActivityInterface(String string) {
        PluginActivityInterface pluginActivityInterface = null;
        try {
            if (null != this.mPluginClassLoader) {
                Class clazz = this.mPluginClassLoader.loadClass(string);
                pluginActivityInterface = (PluginActivityInterface)clazz.newInstance();
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        return pluginActivityInterface;
    }

    public PluginServiceInterface getPluginServiceInterface() {
        PluginServiceInterface pluginServiceInterface = null;
        try {
            if (null != this.mPluginClassLoader) {
                Class clazz = this.mPluginClassLoader.loadClass(SERVICE_NAME);
                pluginServiceInterface = (PluginServiceInterface)clazz.newInstance();
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        return pluginServiceInterface;
    }

    public static interface PluginManagerListener {
        public void onLoadPluginSuccess();

        public void onLoadPluginFailure(int var1, String var2);
    }
}

