package com.yodo1ads.adapter.interstitial;


import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.os.Handler;
import android.text.TextUtils;

import com.uniplay.adsdk.InterstitialAd;
import com.uniplay.adsdk.InterstitialAdListener;
import com.yodo1.advert.interstitial.Yodo1InterstitialReloadCallback;
import com.yodo1.advert.interstitial.AdInterstitialAdapterBase;
import com.yodo1.advert.interstitial.Yodo1InterstitialCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1ads.plugin.uniplay.AdConfigUniplay;
import com.yodo1ads.plugin.uniplay.AdvertCoreUniplay;


/**
 * Created by yodo1 on 2016/3/21.
 */
public class AdvertAdapteruniplay extends AdInterstitialAdapterBase {

    private Yodo1InterstitialCallback interstitialCallback;
    private InterstitialAd interstitialAd;
    private Yodo1InterstitialReloadCallback callback;

    private InterstitialAdListener adListener = new InterstitialAdListener() {
        @Override
        public void onInterstitialAdReady() {
            if(callback != null){
                callback.onResult(Yodo1InterstitialReloadCallback.ADVERT_INTERSTITIAL_RELOAD_FINISH, getAdvertCode());
            }
        }

        @Override
        public void onInterstitialAdShow() {
            if(interstitialCallback != null){
                interstitialCallback.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_DISPLAY, AdConfigUniplay.CHANNEL_CODE);
            }
        }

        @Override
        public void onInterstitialAdClick() {
            if(interstitialCallback != null){
                interstitialCallback.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_CLICK, AdConfigUniplay.CHANNEL_CODE);
            }
        }

        @Override
        public void onInterstitialAdFailed(String s) {
            YLog.i("uniplay,  onInterstitialAdFailed ： " + s);
        }

        @Override
        public void onInterstitialAdClose() {
            YLog.i("uniplay,  onInterstitialAdClose  " );
            if(interstitialCallback != null){
                interstitialCallback.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_CLOSE, AdConfigUniplay.CHANNEL_CODE);
            }
        }
    };
    @Override
    public void showIntersititalAdvert(Activity activity, Yodo1InterstitialCallback callback) {
        this.interstitialCallback = callback;
        YLog.i("yodo1 advert uniplay,  call showIntersititalAdvert...");
        if (TextUtils.isEmpty( AdConfigUniplay.INTERSTITIAL_ID)){
            callback.onAdError(Yodo1InterstitialCallback.ADVERT_ERROR_LOADED_FAILED, "Uniplay INTERSTITIAL_ID  null", AdConfigUniplay.CHANNEL_CODE);

            YLog.e("Uniplay INTERSTITIAL_ID  null");
            return;
        }
        if (interstitialAd != null && interstitialAd.isInterstitialAdReady()) {
            interstitialAd.showInterstitialAd(activity);
            hasLoded = false;
        } else {
            callback.onAdError(Yodo1InterstitialCallback.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", AdConfigUniplay.CHANNEL_CODE);
        }

    }

    private int index = 0;
    private boolean hasLoded = false;
    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1InterstitialReloadCallback callback) {
        this.callback=callback;
        if (TextUtils.isEmpty( AdConfigUniplay.INTERSTITIAL_ID)){
            YLog.e("Uniplay INTERSTITIAL_ID  null");
            return;
        }

        if (hasLoded){
            YLog.i("Uniplay  Has loadInterstitialAd");
            return;
        }
        if (interstitialAd != null){

            if (index == 0){
                interstitialAd.loadInterstitialAd();
                index ++;
            } else {
                new Handler().postDelayed(new Runnable() {

                    @Override
                    public void run() {
                        YLog.i("Uniplay  loadInterstitialAd   1min后");
                        interstitialAd.loadInterstitialAd();//一分钟后再请求广告
                    }
                },60 * 1000);
            }

        }
        hasLoded = true;
    }
    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return interstitialAd != null && interstitialAd.isInterstitialAdReady();
    }
    @Override
    public String getAdvertCode() {
        return AdConfigUniplay.CHANNEL_CODE;
    }

    @Override
    public void onCreateApplication(Application application) {

    }
    @Override
    public void validateAdsAdapter(Activity activity) {
        AdvertCoreUniplay.getInstance().validateAdsAdapter(activity);
    }

    @Override
    public void onCreate(Activity activity) {
        AdConfigUniplay.INTERSTITIAL_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd,
                AdConfigUniplay.CHANNEL_CODE, AdConfigUniplay.KEY_Uniplay_INTERSTITIAL_ID);

        if (TextUtils.isEmpty( AdConfigUniplay.INTERSTITIAL_ID)){

            YLog.e("Uniplay INTERSTITIAL_ID  null");
            return;
        }
        interstitialAd = new InterstitialAd(activity, AdConfigUniplay.INTERSTITIAL_ID);
        interstitialAd.setInterstitialAdListener(adListener);

    }

    @Override
    public void onStart(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }

    @Override
    public void onRestart(Activity activity) {

    }

    @Override
    public void onStop(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {

    }

    @Override
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {
    }

    @Override
    public void onNewIntent(Activity activity, Intent intent) {

    }
}
