package com.yodo1ads.plugin.uniplay;

import android.app.Activity;

import com.yodo1.sdk.kit.ValidateUtils;

import java.util.Arrays;
import java.util.List;


/**
 * Created by yodo1 on 2016/4/21.
 */
public class AdvertCoreUniplay {
    private static AdvertCoreUniplay instance;
    private AdvertCoreUniplay(){}
    public static AdvertCoreUniplay getInstance(){
        if(instance == null){
            instance = new AdvertCoreUniplay();
        }
        return instance;
    }

    private boolean validate = false;

    public  void validateAdsAdapter(Activity activity){

        if(!validate) {

            List<String> uniplayActivities = Arrays.asList(new String[] { "com.uniplay.adsdk.AdActivity", "com.uniplay.adsdk.InterstitialAdActivity" });
            ValidateUtils.validateActivities(activity,uniplayActivities);

            List<String> uniplayService = Arrays.asList(new String[] { "com.uniplay.adsdk.DownloadService" });
            ValidateUtils.validateServices(activity,uniplayService);


            List<String> uniplayBroadcastReceivers = Arrays.asList(new String[] { "com.uniplay.adsdk.PackageReceiver" });
            ValidateUtils.validateBroadcastReceivers(activity,uniplayBroadcastReceivers);


            validate = true;
        }

    }


}
