package com.yodo1ads.adapter.video;

import android.app.Activity;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.text.TextUtils;

import com.ironsource.mediationsdk.IronSource;

import com.ironsource.mediationsdk.integration.IntegrationHelper;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.model.Placement;
import com.ironsource.mediationsdk.sdk.RewardedVideoListener;
import com.yodo1ads.plugin.supersonic.AdConfigSupersonic;
import com.yodo1ads.plugin.supersonic.AdvertCoreSupersonic;
import com.yodo1.advert.video.AdVideoAdapterBase;
import com.yodo1.advert.video.Yodo1VideoCallback;
import com.yodo1.advert.video.Yodo1VideoReloadCallback;
import com.yodo1.sdk.kit.YLog;

/**
 * Created by yodo1 on 2016/4/7.
 */
public class AdvertAdaptersupersonic extends AdVideoAdapterBase {
    private Yodo1VideoCallback videoCallback; //视频回调
    private Yodo1VideoReloadCallback reloadCallback; //视频预加载回调
    private boolean setListener = false;
    RewardedVideoListener mRewardedVideoListener = new RewardedVideoListener()
    {

        @Override
        public void onRewardedVideoAdClosed() {
            // TODO Auto-generated method stub
            // called when the video is closed
            YLog.d("Supersonic.onRewardedVideoAdClosed");
            // here we show a dialog to the user if he was rewarded
            if(videoCallback != null){
               videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoAvailabilityChanged(boolean available) {
            YLog.d( "Supersonic.onVideoAvailabilityChanged : " + available);
            if (reloadCallback != null){
                if (available){
                    reloadCallback.onResult(Yodo1VideoReloadCallback.ADVERT_VIDEO_RELOAD_FINISH,getAdvertCode());
                } else {
                    reloadCallback.onResult(Yodo1VideoReloadCallback.ADVERT_VIDEO_RELOAD_FAILED,getAdvertCode());
                }

            }
        }

        @Override
        public void onRewardedVideoAdStarted() {
            YLog.d("Supersonic onRewardedVideoAdStarted ");
        }

        @Override
        public void onRewardedVideoAdEnded() {
            YLog.d("Supersonic onRewardedVideoAdEnded ");
        }


        @Override
        public void onRewardedVideoAdShowFailed(IronSourceError ironSourceError) {
            YLog.e("Supersonic.onRewardedVideoShowFail" + ironSourceError.getErrorMessage());
            if(videoCallback != null){
                videoCallback.onAdError(Yodo1VideoCallback.ADVERT_EVENT_DISPLAY_FAILED, "onRewardedVideoAdShowFailed ： " + ironSourceError.getErrorMessage(), getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoAdClicked(Placement placement) {
            if(videoCallback != null){
                videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoAdOpened() {
            // TODO Auto-generated method stub
            YLog.d("Supersonic.onRewardedVideoAdOpened");
            if (videoCallback != null){
                videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoAdRewarded(Placement placement) {
            // TODO Auto-generated method stub
            // called when the video has been rewarded and a reward can be given to the user
            String rewardName = placement.getRewardName();
            int rewardAmount = placement.getRewardAmount();
            YLog.d("Supersonic, onRewardedVideoAdRewarded: rewardName=" + rewardName + ", rewardAmount=" + rewardAmount);

            if(videoCallback != null){
                videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_FINISH, getAdvertCode());
            }

        }


    };

    @Override
    public void showVideoAdvert(Activity activity, Yodo1VideoCallback callback) {
        this.videoCallback = callback;
        YLog.d("Supersonic, showVideoAdvert ... ");
        if (videoAdvertIsLoaded(activity)) {
                //show rewarded video
            IronSource.showRewardedVideo();
        } else {
            videoCallback.onAdError(Yodo1VideoCallback.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1VideoReloadCallback reloadCallback) {
        this.reloadCallback = reloadCallback;

        if (AdvertCoreSupersonic.initSuccess && !setListener){

            if (!setListener){
                setListener = true;
                IronSource.setRewardedVideoListener(mRewardedVideoListener);
            }
            IronSource.loadInterstitial();
        }
        reloadCallback.onReload(Yodo1VideoReloadCallback.ADVERT_VIDEO_RELOAD,getAdvertCode());
        YLog.d("Supersonic, requestRewardVideo ... ");
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        if (TextUtils.isEmpty(AdConfigSupersonic.SUPERSONIC_ID)){
            YLog.e("Supersonic  APPID  is null");
            return false;
        }

        boolean result = IronSource.isRewardedVideoAvailable();
        YLog.d("Supeirsonic isLoaded = " + result);
        return result;
    }

    @Override
    public String getAdvertCode() {
        return AdConfigSupersonic.CHANNEL_CODE;
    }

    @Override
    public void onCreateApplication(Application application) {
    }
    @Override
    public void validateAdsAdapter(Activity activity) {
        AdvertCoreSupersonic.getInstance().validateAdsAdapter(activity);
    }
    @Override
    public void onCreate(Activity activity) {
        YLog.d("supersonic  onCreate");
        AdvertCoreSupersonic.getInstance().startIronSourceInitTask(activity);
        IntegrationHelper.validateIntegration(activity);
//        IronSource.setAdaptersDebug(true);

    }


    @Override
    public void onStart(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {
        YLog.d("supersonic  onResume");
        AdvertCoreSupersonic.getInstance().onResume(activity);
    }

    @Override
    public void onPause(Activity activity) {
        AdvertCoreSupersonic.getInstance().onPause(activity);
    }

    @Override
    public void onRestart(Activity activity) {

    }

    @Override
    public void onStop(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {
    }

    @Override
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {

    }

    @Override
    public void onNewIntent(Activity activity, Intent intent) {

    }

}
