package com.yodo1.advert.banner;

import android.app.Activity;
import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;

/**
 * Created by zhuxiaochen on 2017/10/18.
 */

public class Yodo1BannerAlign {

    public static final int BannerAlignLeft = 1 << 0;
    public static final int BannerAlignHorizontalCenter = 1 << 1;
    public static final int BannerAlignRight = 1 << 2;
    public static final int BannerAlignTop = 1 << 3;
    public static final int BannerAlignVerticalCenter = 1 << 4;
    public static final int BannerAlignBottom = 1 << 5;


    public static RelativeLayout getRel(Activity activity){
        RelativeLayout relativeLayout = null;

        if (relativeLayout == null){
            FrameLayout frameLayout = (FrameLayout)activity.findViewById(android.R.id.content);
            relativeLayout = new RelativeLayout(activity);
            frameLayout.addView(relativeLayout);
        }

        return relativeLayout;
    }

    /**
     * 设置banner展示
     * @param activity
     * @param view
     */
    public static void removeYodo1BannerLayout(Activity activity, ViewGroup view ) {
        if ((ViewGroup)view.getParent() != null && ((ViewGroup)view.getParent()).getChildCount() > 0){
            ((ViewGroup)view.getParent()).removeView(view);
        }

    }

    /**
     * 设置banner展示
     * @param activity
     * @param view
     */
    public static void removeYodo1BannerAllLayout(Activity activity, ViewGroup view ) {
        ViewGroup parent = (ViewGroup) view.getParent();
        if (parent != null) {
            parent.removeAllViews();
        }

    }

    /**
     * 设置banner展示
     * @param activity
     * @param view
     */
    public static void setYodo1BannerLayout(Activity activity, ViewGroup view , int align) {
        RelativeLayout relativeLayout = getRel(activity);

        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams
                (ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);

        if ((align & BannerAlignLeft) == BannerAlignLeft){
            params.addRule(RelativeLayout.ALIGN_PARENT_LEFT, RelativeLayout.TRUE);//左
        } else if ((align & BannerAlignHorizontalCenter) == BannerAlignHorizontalCenter){
            params.addRule(RelativeLayout.CENTER_HORIZONTAL, RelativeLayout.TRUE);//水平居中
        } else if ((align & BannerAlignRight) == BannerAlignRight){
            params.addRule(RelativeLayout.ALIGN_PARENT_RIGHT, RelativeLayout.TRUE);//水平居中
        }

        if ((align & BannerAlignTop) == BannerAlignTop){
            params.addRule(RelativeLayout.ALIGN_PARENT_TOP, RelativeLayout.TRUE);//水平居中
        } else if ((align & BannerAlignVerticalCenter) == BannerAlignVerticalCenter){
            params.addRule(RelativeLayout.CENTER_VERTICAL, RelativeLayout.TRUE);//水平居中
        } else if ((align & BannerAlignBottom) == BannerAlignBottom){
            params.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM, RelativeLayout.TRUE);//水平居中
        }

        view.setLayoutParams(params);
        relativeLayout.addView(view);//将view添加到当前Activity中
    }


    /**
     * 设置banner展示  展示固定大小 暂时InMobi banner展示必须设置大小
     * @param activity
     * @param view
     */
    public static void setYodo1BannerLayoutForSize(Activity activity, ViewGroup view , int align) {
        RelativeLayout relativeLayout = getRel(activity);

        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams
                (320*3, 50*3);

        if ((align & Yodo1BannerAlign.BannerAlignLeft) == Yodo1BannerAlign.BannerAlignLeft){
            params.addRule(RelativeLayout.ALIGN_PARENT_LEFT, RelativeLayout.TRUE);//左
        } else if ((align & Yodo1BannerAlign.BannerAlignHorizontalCenter) == Yodo1BannerAlign.BannerAlignHorizontalCenter){
            params.addRule(RelativeLayout.CENTER_HORIZONTAL, RelativeLayout.TRUE);//水平居中
        } else if ((align & Yodo1BannerAlign.BannerAlignRight) == Yodo1BannerAlign.BannerAlignRight){
            params.addRule(RelativeLayout.ALIGN_PARENT_RIGHT, RelativeLayout.TRUE);//水平居中
        }

        if ((align & Yodo1BannerAlign.BannerAlignTop) == Yodo1BannerAlign.BannerAlignTop){
            params.addRule(RelativeLayout.ALIGN_PARENT_TOP, RelativeLayout.TRUE);//水平居中
        } else if ((align & Yodo1BannerAlign.BannerAlignVerticalCenter) == Yodo1BannerAlign.BannerAlignVerticalCenter){
            params.addRule(RelativeLayout.CENTER_VERTICAL, RelativeLayout.TRUE);//水平居中
        } else if ((align & Yodo1BannerAlign.BannerAlignBottom) == Yodo1BannerAlign.BannerAlignBottom){
            params.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM, RelativeLayout.TRUE);//水平居中
        }

        view.setLayoutParams(params);
        relativeLayout.addView(view);//将view添加到当前Activity中
    }
}
