/*
 * Decompiled with CFR 0.152.
 */
package com.uniplay.adsdk.download;

import android.content.Context;
import android.net.Uri;
import android.os.Environment;
import com.uniplay.adsdk.download.DownloadCallback;
import com.uniplay.adsdk.download.DownloadRequestQueue;
import com.uniplay.adsdk.download.DownloadState;
import com.uniplay.adsdk.download.Downloader;
import com.uniplay.adsdk.download.Preconditions;
import com.uniplay.adsdk.download.Priority;
import com.uniplay.adsdk.utils.Utils;
import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class DownloadRequest
implements Comparable<DownloadRequest> {
    private static final String DEFAULT_DIR = Environment.getExternalStorageDirectory().toString() + File.separator + "Uniplay/Download/";
    private int downloadId = -1;
    private final AtomicInteger retryTime;
    private Context context;
    private DownloadState downloadState;
    private final Uri uri;
    private final String destinationDirectory;
    private String destinationFilePath;
    private final long progressInterval;
    private final long retryInterval;
    private DownloadRequestQueue downloadRequestQueue;
    private final long timestamp;
    private final Priority priority;
    private boolean canceled = false;
    private Downloader downloader;
    private final DownloadCallback downloadCallback;

    private DownloadRequest(Builder builder) {
        this.uri = builder.uri;
        this.priority = Preconditions.checkNotNull(builder.priority, "priority == null");
        this.retryTime = new AtomicInteger(builder.retryTime);
        this.destinationDirectory = Preconditions.checkNotNull(builder.destinationDirectory, "destinationDirectory == null");
        this.destinationFilePath = builder.destinationFilePath;
        this.downloadCallback = Preconditions.checkNotNull(builder.downloadCallback, "downloadCallback == null");
        this.progressInterval = builder.progressInterval;
        this.retryInterval = builder.retryInterval;
        this.downloadState = DownloadState.PENDING;
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    public int compareTo(DownloadRequest downloadRequest) {
        Priority priority;
        Priority priority2 = this.priority();
        return priority2 == (priority = downloadRequest.priority()) ? (int)(this.timestamp - downloadRequest.timestamp) : priority.ordinal() - priority2.ordinal();
    }

    Priority priority() {
        return this.priority;
    }

    Downloader downloader() {
        return this.downloader;
    }

    void setDownloader(Downloader downloader) {
        this.downloader = downloader;
    }

    DownloadCallback downloadCallback() {
        return this.downloadCallback;
    }

    void setDownloadRequestQueue(DownloadRequestQueue downloadRequestQueue) {
        this.downloadRequestQueue = downloadRequestQueue;
        this.downloadId = this.downloadRequestQueue.getSequenceNumber();
    }

    void updateDownloadState(DownloadState downloadState) {
        this.downloadState = downloadState;
    }

    DownloadState downloadState() {
        return this.downloadState;
    }

    int downloadId() {
        return this.downloadId;
    }

    int retryTime() {
        return this.retryTime.decrementAndGet();
    }

    long progressInterval() {
        return this.progressInterval;
    }

    long retryInterval() {
        return this.retryInterval;
    }

    void setContext(Context context) {
        this.context = context;
    }

    Context context() {
        return this.context;
    }

    Uri uri() {
        return this.uri;
    }

    void updateDestinationFilePath(String string2) {
        string2 = Utils.changeFilePath(string2);
        String string3 = this.destinationDirectory.endsWith("/") ? "" : File.separator;
        this.destinationFilePath = this.destinationDirectory + string3 + string2;
        File file = new File(this.destinationFilePath);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
    }

    String destinationFilePath() {
        return this.destinationFilePath;
    }

    String tempFilePath() {
        return this.destinationFilePath() + ".tmp";
    }

    void cancel() {
        this.canceled = true;
    }

    boolean isCanceled() {
        return this.canceled;
    }

    void finish() {
        if (this.downloadRequestQueue != null) {
            this.downloadRequestQueue.finish(this);
        }
    }

    public static final class Builder {
        private Uri uri;
        private int retryTime = 1;
        private long retryInterval = 3000L;
        private String destinationDirectory;
        private String destinationFilePath;
        private Priority priority = Priority.NORMAL;
        private long progressInterval = 100L;
        private DownloadCallback downloadCallback;

        public Builder() {
            this.destinationDirectory = DEFAULT_DIR;
            this.downloadCallback = DownloadCallback.EMPTY_CALLBACK;
        }

        public Builder url(String string2) {
            return this.uri(Uri.parse((String)string2));
        }

        public Builder uri(Uri uri) {
            this.uri = Preconditions.checkNotNull(uri, "uri == null");
            String string2 = uri.getScheme();
            if (!"http".equals(string2) && !"https".equals(string2)) {
                throw new IllegalArgumentException("url should start with http or https");
            }
            return this;
        }

        public Builder destinationDirectory(String string2) {
            this.destinationDirectory = string2;
            return this;
        }

        public Builder destinationFilePath(String string2) {
            if (new File(string2).isDirectory()) {
                throw new IllegalArgumentException("destinationFilePath cannot be a directory");
            }
            this.destinationFilePath = string2;
            return this;
        }

        public Builder priority(Priority priority) {
            this.priority = priority;
            return this;
        }

        public Builder retryTime(int n2) {
            if (n2 < 0) {
                throw new IllegalArgumentException("retryTime < 0");
            }
            this.retryTime = n2;
            return this;
        }

        public Builder retryInterval(long l2, TimeUnit timeUnit) {
            if (l2 <= 0L) {
                throw new IllegalArgumentException("interval <= 0");
            }
            long l3 = (timeUnit = Preconditions.checkNotNull(timeUnit, "unit == null")).toMillis(l2);
            if (l3 > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("interval too large");
            }
            this.retryInterval = l3;
            return this;
        }

        public Builder progressInterval(long l2, TimeUnit timeUnit) {
            if (l2 < 0L) {
                throw new IllegalArgumentException("interval < 0");
            }
            long l3 = (timeUnit = Preconditions.checkNotNull(timeUnit, "unit == null")).toMillis(l2);
            if (l3 > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("interval too large");
            }
            this.progressInterval = l3;
            return this;
        }

        public Builder downloadCallback(DownloadCallback downloadCallback) {
            this.downloadCallback = downloadCallback;
            return this;
        }

        public DownloadRequest build() {
            return new DownloadRequest(this);
        }
    }
}

