/*
 * Decompiled with CFR 0.152.
 */
package com.uniplay.adsdk;

import android.app.AlarmManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.IBinder;
import android.os.SystemClock;
import android.text.TextUtils;
import com.uniplay.adsdk.AdEntity;
import com.uniplay.adsdk.ClickParser;
import com.uniplay.adsdk.DeviceInfo;
import com.uniplay.adsdk.PackageReceiver;
import com.uniplay.adsdk.download.DownloadCallback;
import com.uniplay.adsdk.download.DownloadManager;
import com.uniplay.adsdk.download.DownloadRequest;
import com.uniplay.adsdk.download.Priority;
import com.uniplay.adsdk.net.HttpUtil;
import com.uniplay.adsdk.utils.AppUtils;
import com.uniplay.adsdk.utils.DatabaseUtils;
import com.uniplay.adsdk.utils.Record;
import com.uniplay.adsdk.utils.SDKLog;
import com.uniplay.adsdk.utils.Utils;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DownloadService
extends Service
implements DownloadCallback {
    public static final String ACTION_DOWNLOAD_START = "b";
    public static final String ACTION_PKG_ADD = "d";
    private NotificationManager mNotificationManager;
    private static volatile HashMap<Integer, Long> hashMap = new HashMap();
    public static final String DL_PATH = Environment.getExternalStorageDirectory().toString() + File.separator + "Uniplay/Download/";
    private static DownloadManager downloadManager;
    private ThreadPoolExecutor mThreadPool;
    private boolean isDtimes = true;
    private boolean isFistDtimes = true;
    private int dtimes = 1;
    private int dtimes_cont = 1;
    private Runnable mCheckUnfinishedRunnable = new Runnable(){

        @Override
        public void run() {
            ArrayList<Record> arrayList = DatabaseUtils.getRecentRecords((Context)DownloadService.this);
            if (downloadManager == null) {
                DownloadService.downloadManager = new DownloadManager.Builder().context((Context)DownloadService.this).threadPoolSize(3).build();
            }
            for (Record record : arrayList) {
                String string2 = record.getPkgName();
                if (!TextUtils.isEmpty((CharSequence)string2) && !AppUtils.isPkgInstalled((Context)DownloadService.this, string2)) {
                    Object object;
                    string2 = DownloadService.this.isValidApk(record.getFilePath(), (Context)DownloadService.this);
                    if (TextUtils.isEmpty((CharSequence)string2)) {
                        object = new DownloadRequest.Builder().url(record.getUrl()).downloadCallback(DownloadService.this).retryTime(1).retryInterval(5L, TimeUnit.SECONDS).progressInterval(1L, TimeUnit.SECONDS).priority(Priority.HIGH).build();
                        int n2 = downloadManager.add((DownloadRequest)object);
                        SDKLog.e("mCheckUnfinishedRunnable " + n2, record.toString());
                        hashMap.put(n2, record.getId());
                    } else {
                        object = DownloadService.this.getAppName(record.getFilePath(), (Context)DownloadService.this);
                        if (TextUtils.isEmpty((CharSequence)object)) {
                            SDKLog.e("doll", "appName " + (String)object);
                            DownloadService.this.showDownloadedNotification((Context)DownloadService.this, string2, record.getFilePath(), (String)object, record.getAppicon(), record.getSin());
                        } else {
                            SDKLog.e("doll", "appName 123 " + (String)object);
                            DownloadService.this.showDownloadedNotification((Context)DownloadService.this, string2, record.getFilePath(), record.getAppname(), record.getAppicon(), record.getSin());
                        }
                    }
                }
                SDKLog.e("mCheckUnfinishedRunnable", record.toString());
            }
        }
    };
    private static HashMap<Long, Integer> backMap;
    private static ThreadPoolExecutor mThread;
    public static final String INSTALLING_APK_TITLE = "installing_apk_title";
    public static final String PACKAGE_NAME = "com.yingyonghui.market";
    public static final String INSTALLING_APK_PATH = "installing_apk_path";

    public DownloadService() {
        if (this.mThreadPool == null) {
            this.mThreadPool = (ThreadPoolExecutor)Executors.newFixedThreadPool(1);
        }
    }

    public int onStartCommand(Intent intent, int n2, int n3) {
        if (intent == null) {
            return super.onStartCommand(intent, n2, n3);
        }
        try {
            String string2 = intent.getStringExtra("action");
            if (intent.hasExtra("dtimes")) {
                this.dtimes = intent.getIntExtra("dtimes", 0);
            }
            if (ACTION_DOWNLOAD_START.equals(string2)) {
                Object object;
                boolean bl = false;
                long l2 = intent.getLongExtra("id", -1L);
                Record record = DatabaseUtils.getRecordById((Context)this, l2);
                String string3 = "";
                if (record != null && (bl = this.isDownloaded(string3 = this.isValidApk(record.getFilePath(), (Context)this), record))) {
                    object = new Record();
                    ((Record)object).setPkgName(string3);
                    ((Record)object).setFilePath(record.getFilePath());
                    ((Record)object).setDayofyear(DeviceInfo.getToday());
                    DatabaseUtils.updateRecord((Context)this, (Record)object, l2);
                }
                if (bl) {
                    SDKLog.e("info", "onStartCommand-apk\u5df2\u7ecf\u4e0b\u8f7d,\u76f4\u63a5\u6253\u5f00");
                    if (DownloadService.isTYSilentInstallServiceExists((Context)this)) {
                        this.silentInstall(string3, new File(record.getFilePath()));
                    } else {
                        object = new Intent("android.intent.action.VIEW");
                        object = Utils.getIntent(this.getBaseContext(), record.getFilePath(), (Intent)object);
                        this.startActivity((Intent)object);
                        this.showDownloadedNotification((Context)this, string3, record.getFilePath(), record.getAppname(), record.getAppicon(), record.getSin());
                    }
                    if (!TextUtils.isEmpty((CharSequence)record.getDownsucc())) {
                        SDKLog.e("info", "onStartCommand-record.getDownsucc()= false:Downsucc\u4e0a\u62a5:" + record.getDownsucc());
                        this.sendTrack(Utils.string2List(record.getDownsucc()));
                    }
                    return super.onStartCommand(intent, n2, n3);
                }
                if (downloadManager == null) {
                    downloadManager = new DownloadManager.Builder().context((Context)this).threadPoolSize(3).build();
                }
                if (record != null) {
                    object = new DownloadRequest.Builder().url(record.getUrl()).downloadCallback(this).retryTime(1).retryInterval(5L, TimeUnit.SECONDS).progressInterval(2L, TimeUnit.SECONDS).priority(Priority.HIGH).build();
                    if (intent.getBooleanExtra("isdown", true)) {
                        int n4 = downloadManager.add((DownloadRequest)object);
                        SDKLog.e("record != null--->" + n4, l2 + " " + record.getUrl());
                        hashMap.put(n4, l2);
                    }
                } else {
                    SDKLog.e("record == null--->", "" + l2);
                }
            } else if (ACTION_PKG_ADD.equals(string2) && intent.hasExtra("extra")) {
                Bundle bundle = intent.getBundleExtra("extra");
                String string4 = bundle.getString("pkg");
                this.cancelNotification((Context)this, string4);
                Record record = DatabaseUtils.getRecordByPkg((Context)this, string4);
                if (record != null) {
                    ArrayList<String> arrayList;
                    if (!TextUtils.isEmpty((CharSequence)record.getInstallsucc())) {
                        SDKLog.e("info", "onStartCommand-record.getInstallsucc()= false:\u5b89\u88c5\u4e0a\u62a5:" + record.getInstallsucc());
                        arrayList = Utils.string2List(record.getInstallsucc());
                        this.sendTrack(arrayList);
                    }
                    if (!TextUtils.isEmpty((CharSequence)record.getAppactive())) {
                        arrayList = Utils.string2List(record.getAppactive());
                        SDKLog.e("info", "onStartCommand-record.getAppactive()= false:\u6fc0\u6d3b\u4e0a\u62a5:" + record.getAppactive());
                        if (arrayList.size() > 0) {
                            Intent intent2 = this.getPackageManager().getLaunchIntentForPackage(string4);
                            intent2.addFlags(0x10000000);
                            this.startActivity(intent2);
                            this.sendTrack(arrayList);
                        }
                    }
                    this.showPackAddNotification((Context)this, string4, record.getFilePath(), record.getAppname(), record.getAppicon());
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return super.onStartCommand(intent, n2, n3);
    }

    private boolean isDownloaded(String string2, Record record) {
        SDKLog.e("info", "isDownloaded-filepath:" + record.getFilePath());
        if (TextUtils.isEmpty((CharSequence)record.getFilePath())) {
            return false;
        }
        SDKLog.e("info", "isDownloaded-filepath:" + record.getFilePath());
        if (!Utils.apkExists(record.getFilePath())) {
            return false;
        }
        SDKLog.e("info", "isDownloaded-filepath:" + !Utils.apkExists(record.getFilePath()));
        return true;
    }

    private void checkUnfinishRecord() {
        if (!this.mThreadPool.getQueue().contains(this.mCheckUnfinishedRunnable)) {
            this.mThreadPool.execute(this.mCheckUnfinishedRunnable);
        }
    }

    private void showPackAddNotification(final Context context, final String string2, String string3, final String string4, String string5) {
        mThread.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    DownloadService.this.mNotificationManager = (NotificationManager)context.getSystemService("notification");
                    Notification notification = new Notification();
                    notification.flags |= 1;
                    notification.flags |= 8;
                    notification.defaults = -1;
                    notification.icon = 17301634;
                    notification.when = System.currentTimeMillis();
                    Intent intent = DownloadService.this.getPackageManager().getLaunchIntentForPackage(string2);
                    intent.addFlags(0x10000000);
                    notification.tickerText = string4 + "\u5df2\u5b89\u88c5\u6210\u529f,\u70b9\u51fb\u8fdb\u5165!";
                    PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)intent, (int)0);
                    notification.setLatestEventInfo(context, (CharSequence)string4, notification.tickerText, pendingIntent);
                    DownloadService.this.mNotificationManager.notify(string2.hashCode(), notification);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void onTaskRemoved(Intent intent) {
        super.onTaskRemoved(intent);
        try {
            Intent intent2 = new Intent((Context)this, PackageReceiver.class);
            intent2.setAction("uniplay_action_start_up");
            intent2.setPackage(this.getPackageName());
            if (Build.VERSION.SDK_INT >= 12) {
                intent2.setFlags(32);
            }
            PendingIntent pendingIntent = null;
            AlarmManager alarmManager = (AlarmManager)this.getSystemService("alarm");
            pendingIntent = PendingIntent.getBroadcast((Context)this, (int)1, (Intent)intent2, (int)0x8000000);
            alarmManager.cancel(pendingIntent);
            alarmManager.set(2, SystemClock.elapsedRealtime() + 900000L, pendingIntent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public IBinder onBind(Intent intent) {
        return new DownloadBinder();
    }

    private void cancelNotification(Context context, String string2) {
        try {
            this.mNotificationManager = (NotificationManager)context.getSystemService("notification");
            this.mNotificationManager.cancel(string2.hashCode());
            SDKLog.e("cancelNotification ", string2 + " " + string2.hashCode());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void showDownloadedNotification(final Context context, final String string2, final String string3, final String string4, String string5, final int n2) {
        mThread.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    DownloadService.this.mNotificationManager = (NotificationManager)context.getSystemService("notification");
                    Notification notification = new Notification();
                    notification.flags |= 1;
                    if (n2 == 1) {
                        notification.flags |= 2;
                        notification.defaults = -1;
                    } else {
                        notification.flags |= 8;
                    }
                    notification.icon = 17301634;
                    notification.when = System.currentTimeMillis();
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.addFlags(0x10000000);
                    intent.setDataAndType(Uri.parse((String)("file://" + string3)), "application/vnd.android.package-archive");
                    notification.tickerText = string4 + "\u5df2\u4e0b\u8f7d\u5b8c\u6210,\u70b9\u51fb\u8bf7\u5b89\u88c5!";
                    PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)intent, (int)0);
                    notification.setLatestEventInfo(context, (CharSequence)string4, notification.tickerText, pendingIntent);
                    DownloadService.this.mNotificationManager.notify(string2.hashCode(), notification);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private void installApk(Context context, String string2) {
        SDKLog.e("info", "installApk:-->filePath:" + string2);
        if (DownloadService.isTYSilentInstallServiceExists((Context)this)) {
            this.silentInstall(string2, new File(string2));
        } else {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent = Utils.getIntent(context, string2, intent);
            context.startActivity(intent);
        }
    }

    private String isValidApk(String string2, Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageArchiveInfo(string2, 0);
            if (packageInfo != null) {
                return packageInfo.packageName;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "";
    }

    private String getAppName(String string2, Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageArchiveInfo(string2, 0);
            if (packageInfo != null) {
                return packageInfo.applicationInfo.loadLabel(packageManager).toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private Bitmap getDrawable(String string2, Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageArchiveInfo(string2, 0);
            if (packageInfo != null) {
                return DownloadService.drawableToBitmap(packageInfo.applicationInfo.loadIcon(packageManager));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static Bitmap drawableToBitmap(Drawable drawable2) {
        int n2 = drawable2.getIntrinsicWidth();
        int n3 = drawable2.getIntrinsicHeight();
        Bitmap bitmap = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)(drawable2.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565));
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, n2, n3);
        drawable2.draw(canvas);
        return bitmap;
    }

    public long insertDownloadRecord(Context context, AdEntity adEntity) {
        Record record = new Record();
        record.setUrl(adEntity.lpg);
        record.setPkgName(adEntity.pkg);
        record.setCname(Utils.list2String(adEntity.cname));
        record.setIaction(adEntity.iaction);
        record.setDownsucc(Utils.list2String(adEntity.downsucc));
        record.setInstallsucc(Utils.list2String(adEntity.installsucc));
        record.setAppactive(Utils.list2String(adEntity.appactive));
        record.setApkmd5(adEntity.md5);
        record.setSin(adEntity.sin);
        record.setRpt(adEntity.rpt);
        record.setAppname(adEntity.appname);
        record.setAppicon(adEntity.appicon);
        return DatabaseUtils.insertRecord(context, record);
    }

    @Override
    public void onStart(int n2, long l2) {
    }

    @Override
    public void onRetry(int n2) {
    }

    @Override
    public void onProgress(int n2, long l2, long l3) {
        if (hashMap.containsKey(n2)) {
            long l4 = hashMap.get(n2);
            Record record = DatabaseUtils.getRecordById((Context)this, l4);
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(0);
            String string2 = numberFormat.format((float)l2 / (float)l3 * 100.0f) + "%";
            this.showDownloadingNotification((Context)this, record.getPkgName(), record.getAppname(), record.getAppicon(), string2);
        }
    }

    private void showDownloadingNotification(final Context context, final String string2, final String string3, String string4, final String string5) {
        mThread.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    DownloadService.this.mNotificationManager = (NotificationManager)context.getSystemService("notification");
                    Notification notification = new Notification();
                    notification.flags |= 1;
                    notification.flags |= 8;
                    notification.icon = 0x1080081;
                    notification.when = System.currentTimeMillis();
                    Intent intent = new Intent("android.intent.action.VIEW");
                    if (TextUtils.isEmpty((CharSequence)string3)) {
                        notification.tickerText = string2 + "\u5df2\u4e0b\u8f7d " + string5;
                        notification.setLatestEventInfo(context, (CharSequence)string2, notification.tickerText, null);
                        DownloadService.this.mNotificationManager.notify(string2.hashCode(), notification);
                    } else {
                        notification.tickerText = string3 + "\u5df2\u4e0b\u8f7d " + string5;
                        notification.setLatestEventInfo(context, (CharSequence)string3, notification.tickerText, null);
                        DownloadService.this.mNotificationManager.notify(string2.hashCode(), notification);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void onSuccess(int n2, String string2) {
        SDKLog.e("onSuccess", "success: " + n2 + " size: " + new File(string2).length());
        try {
            File file = new File(string2);
            String string3 = this.isValidApk(file.getPath(), (Context)this);
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                Record record;
                SDKLog.e("onSuccess", "1 " + string3);
                long l2 = hashMap.get(n2);
                if (backMap.containsKey(l2) && backMap.get(l2) == 1) {
                    record = DatabaseUtils.getRecordById((Context)this, l2);
                    if (!TextUtils.isEmpty((CharSequence)record.getDownsucc())) {
                        SDKLog.e("info", "\u4e0b\u8f7d\u6210\u529f\u4e0a\u62a5");
                        this.sendTrack(Utils.string2List(record.getDownsucc()));
                    }
                    this.showDownloadedNotification((Context)this, string3, string2, record.getAppname(), record.getAppicon(), record.getSin());
                    backMap.remove(l2);
                } else {
                    SDKLog.e("onSuccess", "2 " + string3);
                    record = DatabaseUtils.getRecordById((Context)this, l2);
                    if (record != null) {
                        if (!TextUtils.isEmpty((CharSequence)record.getDownsucc())) {
                            SDKLog.e("info", "onSuccess-record.getDownsucc()= false:\u4e0b\u8f7d\u6210\u529f\u4e0a\u62a5:" + record.getDownsucc());
                            this.sendTrack(Utils.string2List(record.getDownsucc()));
                        }
                        this.installApk((Context)this, string2);
                        this.showDownloadedNotification((Context)this, string3, string2, record.getAppname(), record.getAppicon(), record.getSin());
                        hashMap.remove(n2);
                    } else {
                        SDKLog.e("onSuccess", "3 " + string3);
                        record = DatabaseUtils.getRecordByPkg((Context)this, string3);
                        if (record != null) {
                            if (!TextUtils.isEmpty((CharSequence)record.getDownsucc())) {
                                SDKLog.e("info", "onSuccess-record.getDownsucc()= false:\u4e0b\u8f7d\u6210\u529f\u4e0a\u62a5:" + record.getDownsucc());
                                this.sendTrack(Utils.string2List(record.getDownsucc()));
                            }
                            this.installApk((Context)this, string2);
                            this.showDownloadedNotification((Context)this, string3, string2, record.getAppname(), record.getAppicon(), record.getSin());
                            hashMap.remove(n2);
                        }
                    }
                }
                SDKLog.e("onSuccess ", "4 " + string3 + " " + string2);
                record = new Record();
                record.setPkgName(string3);
                record.setFilePath(string2);
                record.setDayofyear(DeviceInfo.getToday());
                DatabaseUtils.updateRecord((Context)this, record, l2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void onFailure(int n2, int n3, String string2) {
        try {
            if (this.isDtimes) {
                long l2 = hashMap.get(n2);
                Record record = DatabaseUtils.getRecordById((Context)this, l2);
                if (this.isFistDtimes) {
                    DownloadRequest downloadRequest = new DownloadRequest.Builder().url(record.getUrl()).downloadCallback(this).retryTime(1).retryInterval(30L, TimeUnit.MINUTES).progressInterval(1L, TimeUnit.SECONDS).priority(Priority.HIGH).build();
                    this.isFistDtimes = false;
                    hashMap.put(downloadManager.add(downloadRequest), l2);
                    SDKLog.e(this.getClass().getName(), "\u4e0b\u8f7d\u534a\u5c0f\u65f6\u91cd\u8fde-dtimes_cont-onFailure:" + this.dtimes_cont);
                } else {
                    DownloadRequest downloadRequest = new DownloadRequest.Builder().url(record.getUrl()).downloadCallback(this).retryTime(1).retryInterval(5L, TimeUnit.SECONDS).progressInterval(1L, TimeUnit.SECONDS).priority(Priority.HIGH).build();
                    hashMap.put(downloadManager.add(downloadRequest), l2);
                    SDKLog.e(this.getClass().getName(), "\u5931\u8d25\u91cd\u8fde-dtimes_cont-onFailure:" + this.dtimes_cont);
                }
                ++this.dtimes_cont;
                SDKLog.e(this.getClass().getName(), "\u5931\u8d25\u91cd\u8fde\u8ba1\u6570-onFailure:" + this.dtimes + "--dtimes_cont:" + this.dtimes_cont);
                if (this.dtimes_cont >= this.dtimes) {
                    this.isDtimes = false;
                }
            }
            SDKLog.e(this.getClass().getName(), "\u5931\u8d25\u91cd\u8fdedtimes-onFailure-isDtimes:" + this.isDtimes + "--isFistDtimes:" + this.isFistDtimes);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void sendTrack(ArrayList<String> arrayList) {
        try {
            for (String string2 : arrayList) {
                SDKLog.e("info", "sendTrack-\u4e0a\u62a5 url:" + string2);
                HttpUtil.AddTaskToQueueHead(string2, 260, new ClickParser(), null);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static boolean isTYSilentInstallServiceExists(Context context) {
        boolean bl = true;
        ApplicationInfo applicationInfo = null;
        try {
            applicationInfo = context.getPackageManager().getApplicationInfo("cn.ktouch.silentinstall", 4);
        }
        catch (Exception exception) {
            applicationInfo = null;
            return false;
        }
        bl = applicationInfo != null;
        return bl;
    }

    public void silentInstall(String string2, File file) {
        try {
            Intent intent = new Intent();
            intent.setClassName("com.ktouch.tycushotapps", "com.yingyonghui.market.service.SilentInstallService");
            if (string2 != null) {
                intent.putExtra(INSTALLING_APK_TITLE, string2);
            }
            intent.putExtra(PACKAGE_NAME, "com.ktouch.tycushotapps");
            intent.putExtra(INSTALLING_APK_PATH, file.getAbsolutePath());
            this.startService(intent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        backMap = new HashMap();
        mThread = (ThreadPoolExecutor)Executors.newFixedThreadPool(3);
    }

    public class DownloadBinder
    extends Binder {
        public DownloadService getService() {
            return DownloadService.this;
        }

        public void startDownload() {
        }
    }
}

